/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import oracle.ide.util.Assert;
import oracle.javatools.util.Log;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.JavaDependencyProvider;
import oracle.jdevimpl.javacompiler.JavacClassLoader;
import oracle.jdevimpl.javacompiler.LogDiagnosticListener;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.jdevimpl.javacompiler.StorageJavaFileObject;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;
import oracle.ojc.storage.JarStorage;

public class JDevJavaCompiler {
    static final Log logger = new Log("JavaCompiler");
    private boolean verbose;
    private String modulePath;

    static boolean allowAnnotationProcessing() {
        return true;
    }

    public int compile(JavaCompiler compiler, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) throws IllegalArgumentException {
        return this.compileImpl(compiler, null, javaFileManager, sources, options, log);
    }

    public int compile(File toolsJar, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) {
        return this.compileImpl(null, toolsJar, javaFileManager, sources, options, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canCompileInProcess(File toolsJarWithJavac) {
        if (toolsJarWithJavac != null) {
            boolean bl;
            JavacClassLoader javacClassLoader = null;
            ClassLoader contextClassLoader = null;
            try {
                contextClassLoader = Thread.currentThread().getContextClassLoader();
                javacClassLoader = new JavacClassLoader(toolsJarWithJavac, toolsJarWithJavac.getClass().getClassLoader());
                Thread.currentThread().setContextClassLoader(javacClassLoader);
                javacClassLoader.loadClass("com.sun.tools.javac.api.JavacTool");
                bl = true;
            }
            catch (Throwable throwable) {
                JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
            }
            catch (Throwable throwable) {
                JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
                throw throwable;
            }
            JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int compileImpl(JavaCompiler compiler, File toolsJar, JavaFileManager javaFileManager, Iterable<? extends JavaFileObject> sources, Iterable<String> options, JavaCompilerLog<? extends JavaFileObject> log) throws IllegalArgumentException {
        File cdiFile;
        ArrayList<String> trimmedOptions = new ArrayList<String>();
        String cdiFileName = null;
        String encoding = null;
        boolean rebuild = false;
        boolean elapsedTime = false;
        String sourceJDK = null;
        boolean cdiHashCodes = false;
        String sourcePath = null;
        String annotationProcessors = null;
        String annotationProcessorPath = null;
        if (log == null) {
            log = new NullLog();
        }
        if (options != null) {
            Iterator<String> optionsIterator = options.iterator();
            while (optionsIterator.hasNext()) {
                void var19_32;
                String option = optionsIterator.next().trim();
                if (option.isEmpty()) continue;
                if (option.startsWith("@")) {
                    String[] stringArray2 = new String[]{option};
                    stringArray2 = JDevJavaCompiler.expandFile(stringArray2, 0, log);
                    if (stringArray2 == null) {
                        return 1;
                    }
                    Object newOptions = new ArrayList();
                    for (String expandedOption : stringArray2) {
                        newOptions.add(expandedOption);
                    }
                    while (optionsIterator.hasNext()) {
                        newOptions.add(optionsIterator.next());
                    }
                    optionsIterator = newOptions.iterator();
                    continue;
                }
                Object var19_23 = null;
                switch (option) {
                    case "-exclude": {
                        if (optionsIterator.hasNext()) {
                            optionsIterator.next();
                        }
                        String msg = ResourceUtils.getString("EXCLUDE_OPTION_NOT_SUPPORTED_ANYMORE", "The -exclude option is not supported anymore");
                        log.warning(null, 0L, 0L, 0, msg);
                        break;
                    }
                    case "-make": {
                        if (optionsIterator.hasNext()) {
                            cdiFileName = optionsIterator.next();
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-encoding": {
                        trimmedOptions.add(option);
                        if (optionsIterator.hasNext()) {
                            encoding = optionsIterator.next();
                            trimmedOptions.add(encoding);
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-source": {
                        trimmedOptions.add(option);
                        if (optionsIterator.hasNext()) {
                            sourceJDK = optionsIterator.next();
                            trimmedOptions.add(sourceJDK);
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-rebuild": {
                        rebuild = true;
                        break;
                    }
                    case "-et": {
                        elapsedTime = true;
                        break;
                    }
                    case "-version": {
                        break;
                    }
                    case "-Xbootclasspath/a:": 
                    case "-Xbootclasspath/p:": {
                        if (optionsIterator.hasNext()) {
                            trimmedOptions.add(option + optionsIterator.next());
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-nowarn": 
                    case "-Xlint:none": {
                        int len = trimmedOptions.size();
                        for (int optionCount = len - 1; optionCount >= 0; --optionCount) {
                            String trimmedOption = (String)trimmedOptions.get(optionCount);
                            if (!trimmedOption.equals("-deprecation") && !trimmedOption.startsWith("-Xlint")) continue;
                            trimmedOptions.remove(optionCount);
                        }
                        trimmedOptions.add(option);
                        break;
                    }
                    case "-cdihashcodes": {
                        cdiHashCodes = true;
                        break;
                    }
                    case "-sourcepath": {
                        trimmedOptions.add(option);
                        if (optionsIterator.hasNext()) {
                            sourcePath = optionsIterator.next();
                            trimmedOptions.add(sourcePath);
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-processor": {
                        if (optionsIterator.hasNext()) {
                            annotationProcessors = optionsIterator.next();
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "-processorpath": {
                        if (optionsIterator.hasNext()) {
                            annotationProcessorPath = optionsIterator.next();
                            break;
                        }
                        String string = option;
                        break;
                    }
                    case "--module-path": {
                        trimmedOptions.add(option);
                        if (optionsIterator.hasNext()) {
                            String path = optionsIterator.next();
                            if (this.modulePath == null) {
                                this.modulePath = path;
                            } else {
                                this.modulePath = this.modulePath.trim();
                                if (!this.modulePath.endsWith(File.pathSeparator)) {
                                    this.modulePath = this.modulePath + File.pathSeparator;
                                }
                                this.modulePath = this.modulePath + path;
                            }
                            trimmedOptions.add(this.modulePath);
                            break;
                        }
                        String string = option;
                        break;
                    }
                    default: {
                        trimmedOptions.add(option);
                    }
                }
                if (var19_32 == null) continue;
                String msg = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", var19_32);
                log.error(null, 0L, 0L, 0, msg);
                return 1;
            }
        }
        ArrayList<String> processorList = new ArrayList<String>();
        if (annotationProcessors != null) {
            String[] processors;
            for (String processor : processors = annotationProcessors.split(",")) {
                if (!"oracle.jdevimpl.javacompiler.TestAnnotation".equals(processor)) continue;
                processorList.add(processor);
            }
        }
        if (processorList.isEmpty()) {
            trimmedOptions.add("-proc:none");
        } else {
            trimmedOptions.add("-processor");
            StringBuilder buf = new StringBuilder();
            boolean bl = false;
            for (String processor : processorList) {
                boolean bl2;
                if (bl2) {
                    buf.append(',');
                } else {
                    bl2 = true;
                }
                buf.append(processor);
            }
            trimmedOptions.add(buf.toString());
            if (annotationProcessorPath != null) {
                trimmedOptions.add("-processorpath");
                trimmedOptions.add(annotationProcessorPath);
            }
        }
        long currentTime = System.currentTimeMillis();
        JavaDependencyProvider dependencyProvider = new JavaDependencyProvider(encoding, cdiHashCodes);
        if (sourceJDK != null) {
            dependencyProvider.setSourceJdk(sourceJDK);
        }
        File file = cdiFile = cdiFileName != null ? new File(cdiFileName) : null;
        if (cdiFile != null) {
            sources = JDevJavaCompiler.checkDependencies(dependencyProvider, cdiFile, sources, rebuild, encoding, sourcePath);
        }
        long cdiTime = System.currentTimeMillis() - currentTime;
        if (!sources.iterator().hasNext()) {
            String msg = ResourceUtils.getString("NOTHING_TO_BUILD", "Nothing to build");
            log.println(msg);
            return 0;
        }
        currentTime = System.currentTimeMillis();
        long compileTime = 0L;
        try {
            int result = this.compileImpl(compiler, toolsJar, log, javaFileManager, trimmedOptions, sources);
            compileTime = System.currentTimeMillis() - currentTime;
            if (result == 0 && cdiFile != null) {
                try {
                    File dir = cdiFile.getParentFile();
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException();
                    }
                    dependencyProvider.save(cdiFile);
                }
                catch (IOException e) {
                    String msg = ResourceUtils.format("CANNOT_WRITE_CDI_FILE", "Cannot write cdi file: {0}", cdiFile.getPath());
                    log.error(null, 0L, 0L, 0, msg);
                    result = 1;
                }
            }
            int n = result;
            return n;
        }
        finally {
            if (elapsedTime) {
                System.out.println("Compilation time: " + compileTime + " msec, cdi generation time: " + cdiTime + " msec.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileImpl(JavaCompiler compiler, File toolsJar, JavaCompilerLog<? extends JavaFileObject> log, JavaFileManager javaFileManager, List<String> options, Iterable<? extends JavaFileObject> sources) {
        int n;
        JavacClassLoader javacClassLoader = null;
        ClassLoader contextClassLoader = null;
        JavaFileManager javaFileManagerToUse = null;
        LogDiagnosticListener diagnosticListener = null;
        try {
            JavaCompiler.CompilationTask task;
            JDevJavaFileManager jdevJavaFileManager;
            if (this.verbose) {
                String[] lines;
                log.println("\n\n--------------  Final compiler options  --------------\n");
                String output = JDevJavaCompiler.prettifyCommandLine(options);
                for (String line : lines = output.split("\n")) {
                    log.println(line);
                }
                log.println("\n");
            }
            int count = 0;
            Iterator<? extends JavaFileObject> sourceIterator = sources.iterator();
            JDevJavaFileManager jDevJavaFileManager = jdevJavaFileManager = javaFileManager instanceof JDevJavaFileManager ? (JDevJavaFileManager)javaFileManager : null;
            while (sourceIterator.hasNext()) {
                ++count;
                JavaFileObject source = sourceIterator.next();
                if (jdevJavaFileManager == null || !(source instanceof StorageJavaFileObject)) continue;
                ((StorageJavaFileObject)source).setJDevJavaFileManager(jdevJavaFileManager);
            }
            String msg = count == 1 ? ResourceUtils.getString("COMPILING_ONE_SOURCE", "Compiling 1 source") : ResourceUtils.format("COMPILING_COUNT_SOURCES", "Compiling {0} sources", count);
            log.println(msg);
            JavaCompiler compilerToUse = compiler;
            if (compilerToUse == null) {
                if (toolsJar != null) {
                    contextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Method method;
                        javacClassLoader = new JavacClassLoader(toolsJar, log.getClass().getClassLoader());
                        Thread.currentThread().setContextClassLoader(javacClassLoader);
                        Class<?> javacTool = javacClassLoader.loadClass("com.sun.tools.javac.api.JavacTool");
                        if (javacTool != null && (method = javacTool.getMethod("create", new Class[0])) != null) {
                            compilerToUse = (JavaCompiler)method.invoke(null, new Object[0]);
                        }
                        if (compilerToUse == null) {
                            logger.trace("Cannot create JavacTool from tools.jar");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (compilerToUse == null) {
                        JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
                        javacClassLoader = null;
                        msg = ResourceUtils.getString("CANNOT_USE_JSR199_JAVAC_FROM_TOOLS_JAR", "Cannot use jsr199 Javac from tools.jar");
                        log.warning(null, 0L, 0L, 0, msg);
                    }
                }
                if (compilerToUse == null) {
                    compilerToUse = ToolProvider.getSystemJavaCompiler();
                }
            }
            JavaCompilerLog<? extends JavaFileObject> logToUse = log;
            diagnosticListener = new LogDiagnosticListener(logToUse, null);
            javaFileManagerToUse = javaFileManager;
            if (javaFileManagerToUse == null) {
                javaFileManagerToUse = new JDevJavaFileManager();
            }
            if (jdevJavaFileManager != null) {
                jdevJavaFileManager.setJavacClassLoader(compilerToUse.getClass().getClassLoader());
                jdevJavaFileManager.setModulePath(this.modulePath);
                StandardJavaFileManager standardJavaFileManager = compilerToUse.getStandardFileManager(diagnosticListener, null, null);
                jdevJavaFileManager.setStandardJavaFileManager(standardJavaFileManager);
            }
            n = (task = compilerToUse.getTask(new LogWriter(logToUse), javaFileManagerToUse, diagnosticListener, options, null, sources)).call().equals(Boolean.TRUE) ? 0 : 1;
        }
        catch (Throwable t) {
            try {
                if (!Thread.currentThread().isInterrupted()) {
                    if (t instanceof IllegalArgumentException && t.getMessage() != null && t.getMessage().length() > 0) {
                        log.error(null, 0L, 0L, 0, t.getMessage());
                    } else {
                        JDevJavaCompiler.handleThrownException(t, log.nerrors() <= 0, true, "EXCEPTION_THROWN_DURING_COMPILATION", "Exception thrown during compilation: {0}", log);
                    }
                }
                int n2 = 1;
                return n2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
                ClassLoader classLoader = this.getClass().getClassLoader();
                ResourceBundle.clearCache(classLoader);
                if (javaFileManager == null) {
                    try {
                        javaFileManagerToUse.close();
                    }
                    catch (IOException iOException) {}
                    assert (JarStorage.getOpenJarCount() == 0) : "Some jars were not closed";
                }
                if (diagnosticListener != null) {
                    diagnosticListener.release();
                }
            }
        }
        JDevJavaCompiler.releaseJavacClassLoader(javacClassLoader, contextClassLoader);
        ClassLoader classLoader = this.getClass().getClassLoader();
        ResourceBundle.clearCache(classLoader);
        if (javaFileManager == null) {
            try {
                javaFileManagerToUse.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            assert (JarStorage.getOpenJarCount() == 0) : "Some jars were not closed";
        }
        if (diagnosticListener != null) {
            diagnosticListener.release();
        }
        return n;
    }

    private static void releaseJavacClassLoader(JavacClassLoader javacClassLoader, ClassLoader contextClassLoader) {
        if (javacClassLoader != null) {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            ResourceBundle.clearCache(javacClassLoader);
            JDevJavaCompiler.clearLogManager(javacClassLoader);
            javacClassLoader.release();
        }
    }

    private static void handleThrownException(Throwable t, boolean printStacktrace, boolean emitErrorMessage, String resourceKey, String resourceValue, JavaCompilerLog<? extends JavaFileObject> log) {
        if (printStacktrace) {
            t.printStackTrace();
        }
        StringBuilder buf = new StringBuilder();
        boolean addSemi = false;
        for (Throwable thrown = t; thrown != null; thrown = thrown.getCause()) {
            String exceptionMessage = thrown.getMessage();
            if (exceptionMessage == null || exceptionMessage.length() <= 0) continue;
            if (addSemi) {
                buf.append("; ");
            } else {
                addSemi = true;
            }
            buf.append(exceptionMessage);
        }
        if (buf.length() == 0) {
            buf.append(ResourceUtils.getString("UNKNOWN_CAUSE", "Unknown cause"));
        }
        String msg = ResourceUtils.format(resourceKey, resourceValue, buf.toString());
        logger.trace(msg, (Object)t);
        if (emitErrorMessage) {
            log.error(null, 0L, 0L, 0, msg);
        }
    }

    public StorageJavaFileObject getJavaFileObject(String packageName, Storage storage, String encoding) {
        return new StorageJavaFileObject(packageName, storage, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args) {
        int result;
        String msg;
        NullLog log = new NullLog();
        for (int x = 0; x < args.length; ++x) {
            String[] lines;
            if (!"-verbose".equals(args[x])) continue;
            System.out.println("\n\n--------------Raw compiler options  --------------\n");
            String output = JDevJavaCompiler.prettifyCommandLine(Arrays.asList(args));
            for (String line : lines = output.split("\n")) {
                log.println(line);
            }
            log.println("\n");
            break;
        }
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        String toolsJar = null;
        String[] arguments = args;
        String encoding = null;
        String sourcesAsString = null;
        String packagesAsString = null;
        String sourcePathArgument = null;
        List<? extends Storage> sourcePathList = null;
        ArrayList<String> deployableExtensions = null;
        ArrayList deployables = null;
        String outputPathArgument = null;
        boolean elapsedTime = false;
        boolean checkUnusedJars = false;
        int index = 0;
        block35: while (index < arguments.length) {
            String[] argument;
            switch (argument = arguments[index]) {
                case "-toolsjar": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-toolsjar");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    toolsJar = arguments[n];
                    continue block35;
                }
                case "-sources": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-sources");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    sourcesAsString = arguments[n];
                    continue block35;
                }
                case "-p": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-p");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    packagesAsString = arguments[n];
                    continue block35;
                }
                case "-deploy": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-deploy");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    String deployableExtensionsAsString = arguments[n];
                    String[] extensions = deployableExtensionsAsString.split(",");
                    deployableExtensions = new ArrayList<String>();
                    deployables = new ArrayList();
                    for (String extension : extensions) {
                        deployableExtensions.add(extension);
                    }
                    continue block35;
                }
                case "-encoding": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-encoding");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    encoding = arguments[n];
                    options.add("-encoding");
                    options.add(encoding);
                    continue block35;
                }
                case "-sourcepath": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-sourcepath");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    sourcePathArgument = arguments[n];
                    options.add("-sourcepath");
                    options.add(sourcePathArgument);
                    continue block35;
                }
                case "-d": {
                    String msg2;
                    if (index == arguments.length - 1) {
                        msg2 = ResourceUtils.format("MISSING_ARGUMENT_FOR_OPTION", "Missing argument for option {0}", "-d");
                        log.error(null, 0L, 0L, 0, msg2);
                        return 1;
                    }
                    int n = ++index;
                    ++index;
                    outputPathArgument = arguments[n];
                    options.add("-d");
                    options.add(outputPathArgument);
                    continue block35;
                }
                case "-et": {
                    elapsedTime = true;
                    options.add(arguments[index++]);
                    continue block35;
                }
                case "-unusedjars": {
                    checkUnusedJars = true;
                    ++index;
                    continue block35;
                }
                case "-verbose": {
                    this.verbose = true;
                    ++index;
                    continue block35;
                }
            }
            if (!argument.isEmpty() && argument.charAt(0) == '@') {
                if ((arguments = JDevJavaCompiler.expandFile(arguments, index, log)) != null) continue;
                return 1;
            }
            options.add(arguments[index++]);
        }
        if (sourcesAsString != null) {
            String[] sourcesAsArray;
            for (String source : sourcesAsArray = sourcesAsString.split(",")) {
                FileStorage storage = new FileStorage(new File(source));
                sources.add(this.getJavaFileObject(null, (Storage)storage, encoding));
            }
        }
        if (sourcePathArgument != null) {
            try {
                sourcePathList = JDevJavaFileManager.parsePath("-sourcepath", sourcePathArgument, false, false, null);
            }
            catch (IllegalArgumentException iae) {
                log.error(null, 0L, 0L, 0, iae.getMessage());
                return 1;
            }
        } else {
            msg = ResourceUtils.format("MISSING_OPTION", "Missing option {0}", "-sourcepath");
            log.error(null, 0L, 0L, 0, msg);
            return 1;
        }
        if (outputPathArgument == null) {
            msg = ResourceUtils.format("MISSING_OPTION", "Missing option {0}", "-d");
            log.error(null, 0L, 0L, 0, msg);
            return 1;
        }
        if (packagesAsString != null) {
            String[] packages = packagesAsString.split(",");
            this.addSourcesFromSourcePaths(packages, sourcePathList, deployableExtensions, sources, deployables, encoding, outputPathArgument);
        }
        JDevJavaFileManager javaFileManager = new JDevJavaFileManager();
        javaFileManager.checkUnusedJars(checkUnusedJars);
        javaFileManager.setVerbose(this.verbose);
        javaFileManager.setLog(log);
        try {
            File toolsJarFile = toolsJar != null ? new File(toolsJar) : null;
            result = this.compileImpl(null, toolsJarFile, javaFileManager, sources, options, log);
        }
        finally {
            if (javaFileManager != null) {
                try {
                    javaFileManager.close();
                }
                catch (IOException toolsJarFile) {}
                javaFileManager = null;
                assert (JarStorage.getOpenJarCount() == 0) : "Some jars were not closed";
            }
        }
        if (result == 0 && deployables != null) {
            long currentTime = System.currentTimeMillis();
            HashMap<String, Storage> targetDirMap = new HashMap<String, Storage>();
            int deployCount = 0;
            for (String[] deployable : deployables) {
                boolean error = false;
                String errorCause = null;
                File sourceFile = new File(deployable[0]);
                Storage targetDirStorage = (Storage)targetDirMap.get(deployable[1]);
                if (targetDirStorage == null) {
                    File targetDir = new File(deployable[1]);
                    if (!targetDir.exists() && !targetDir.mkdirs()) {
                        error = true;
                        errorCause = ResourceUtils.format("FAILED_TO_CREATE_DIRECTORY", "Failed to create directory {0}", targetDir.getPath());
                    } else {
                        targetDirStorage = new DirectoryStorage(targetDir);
                        targetDirMap.put(deployable[1], targetDirStorage);
                    }
                }
                if (!error) {
                    File targetFile = new File(targetDirStorage.getPath(), sourceFile.getName());
                    if (targetFile.isDirectory()) {
                        error = true;
                        errorCause = ResourceUtils.format("DIRECTORY_EXISTS", "There is already a directory named {0}", targetFile.getPath());
                    } else if (!targetFile.exists() || sourceFile.lastModified() > targetFile.lastModified()) {
                        errorCause = JDevJavaCompiler.copyFile((Storage)new FileStorage(sourceFile), new FileStorage(targetFile));
                        if (errorCause != null) {
                            error = true;
                        } else {
                            ++deployCount;
                        }
                    }
                }
                if (!error) continue;
                String msg3 = ResourceUtils.format("CANNOT_COPY_RESOURCE", "Cannot copy resource {0} to {1}: {2}", deployable[0], deployable[1], errorCause);
                log.error(null, 0L, 0L, 0, msg3);
                result = 1;
                break;
            }
            String msg4 = deployCount == 1 ? ResourceUtils.getString("COPIED_ONE_RESOURCE", "Copied 1 resource") : ResourceUtils.format("COPIED_COUNT_RESOURCES", "Copied {0} resources", deployCount);
            System.out.println(msg4);
            if (elapsedTime) {
                System.out.println("Copy time: " + (System.currentTimeMillis() - currentTime) + " msec");
            }
        }
        StringBuilder errorWarningMsg = new StringBuilder();
        if (log.nerrors() == 1) {
            errorWarningMsg.append(ResourceUtils.getString("ONE_ERROR", "1 error"));
        } else {
            errorWarningMsg.append(ResourceUtils.format("NUMBER_OF_ERRORS", "{0} errors", log.nerrors()));
        }
        errorWarningMsg.append(", ");
        if (log.nwarnings() == 1) {
            errorWarningMsg.append(ResourceUtils.getString("ONE_WARNING", "1 warning"));
        } else {
            errorWarningMsg.append(ResourceUtils.format("NUMBER_OF_WARNINGS", "{0} warnings", log.nwarnings()));
        }
        System.out.println(errorWarningMsg.toString());
        return result;
    }

    public static String prettifyCommandLine(List<String> tokens) {
        boolean inPath = false;
        boolean inOption = false;
        StringBuilder buf = new StringBuilder();
        String[] pathPrefixes = new String[]{"-Xbootclasspath/p:", "-Xbootclasspath/a:", "-Xbootclasspath:", "-Djava.ext.dirs=", "-Djava.endorsed.dirs="};
        block0: for (String token : tokens) {
            if (token.startsWith("-")) {
                buf.append('\n');
                for (String pathPrefix : pathPrefixes) {
                    if (!token.startsWith(pathPrefix)) continue;
                    buf.append(token.substring(0, pathPrefix.length()));
                    JDevJavaCompiler.printPath(token.substring(pathPrefix.length()), buf);
                    continue block0;
                }
                buf.append(token);
                buf.append(' ');
                if (token.equals("-sourcepath") || token.equals("-classpath") || token.equals("-cp") || token.equals("-bootclasspath") || token.equals("-sysclasspath") || token.equals("-extdirs") || token.equals("-endorseddirs") || token.equals("-d")) {
                    inPath = true;
                    continue;
                }
                inOption = true;
                continue;
            }
            if (token.startsWith("@")) {
                buf.append('\n');
                buf.append(token);
                inOption = false;
                inPath = false;
                continue;
            }
            if (inPath) {
                JDevJavaCompiler.printPath(token, buf);
                continue;
            }
            if (inOption) {
                buf.append(token);
                buf.append(' ');
                inOption = false;
                continue;
            }
            buf.append('\n');
            buf.append(token);
        }
        buf.append('\n');
        return buf.toString();
    }

    public static void printPath(String token, StringBuilder buf) {
        buf.append('\n');
        StringBuilder tokenBuf = new StringBuilder(token);
        int index = tokenBuf.indexOf(File.pathSeparator);
        while (index >= 0) {
            tokenBuf.insert(index + 1, '\n');
            index = tokenBuf.indexOf(File.pathSeparator, index + 1);
        }
        buf.append((CharSequence)tokenBuf);
    }

    public static void main(String[] args) {
        int result;
        try {
            JDevJavaCompiler jdevJavaCompiler = new JDevJavaCompiler();
            result = jdevJavaCompiler.compile(args);
            ClassLoader classLoader = jdevJavaCompiler.getClass().getClassLoader();
            JDevJavaCompiler.clearLogManager(classLoader);
        }
        catch (Throwable t) {
            t.printStackTrace();
            result = 1;
        }
        System.exit(result);
    }

    private static void clearLogManager(ClassLoader classLoader) {
        try {
            LogManager logManager = LogManager.getLogManager();
            Enumeration<String> loggerNames = logManager.getLoggerNames();
            while (loggerNames.hasMoreElements()) {
                Handler[] handlers;
                Logger logger = logManager.getLogger(loggerNames.nextElement());
                if (logger == null) continue;
                JDevJavaCompiler.clearResourceBundle(logger, classLoader);
                for (Handler handler : handlers = logger.getHandlers()) {
                    if (handler.getClass().getClassLoader() != classLoader) continue;
                    handler.close();
                    logger.removeHandler(handler);
                }
            }
        }
        catch (Throwable throwable) {
            Assert.printStackTrace((Throwable)throwable);
        }
    }

    private static void clearResourceBundle(Logger logger, ClassLoader classLoader) {
        try {
            ResourceBundle resourceBundle;
            Field catalogField;
            try {
                catalogField = Logger.class.getDeclaredField("catalog");
            }
            catch (NoSuchFieldException nsfe) {
                return;
            }
            if (catalogField == null) {
                return;
            }
            catalogField.setAccessible(true);
            try {
                resourceBundle = (ResourceBundle)catalogField.get(logger);
            }
            catch (NullPointerException npe) {
                return;
            }
            catch (ExceptionInInitializerError eiie) {
                return;
            }
            if (resourceBundle != null && resourceBundle.getClass().getClassLoader() == classLoader) {
                catalogField.set(logger, null);
            }
        }
        catch (Throwable throwable) {
            Assert.printStackTrace((Throwable)throwable);
        }
    }

    private static Iterable<? extends JavaFileObject> checkDependencies(JavaDependencyProvider dependencyProvider, File cdiFile, Iterable<? extends JavaFileObject> sources, boolean rebuild, String encoding, String sourcePath) {
        if (cdiFile.exists()) {
            try {
                dependencyProvider.load(cdiFile);
            }
            catch (IOException e) {
                dependencyProvider.reinit();
            }
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();
        HashMap<File, JavaFileObject> sourceMap = new HashMap<File, JavaFileObject>();
        for (JavaFileObject javaFileObject : sources) {
            File file = new File(javaFileObject.toUri());
            sourceMap.put(file, javaFileObject);
            fileList.add(file);
            javaFileObjects.add(javaFileObject);
        }
        fileList = dependencyProvider.updateData(fileList, javaFileObjects, rebuild, sourcePath);
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        ArrayList<File> c = rebuild ? fileList : dependencyProvider.getDependants(fileList, true);
        for (Object e : c) {
            File file = (File)e;
            JavaFileObject source = (JavaFileObject)sourceMap.get(file);
            if (source == null) {
                source = new StorageJavaFileObject(null, (Storage)new FileStorage(file), encoding);
            }
            arrayList.add(source);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyFile(Storage sourceFile, FileStorage targetFile) {
        try {
            sourceFile.open();
            byte[] buffer = sourceFile.read();
            targetFile.write(buffer, 0, buffer.length);
            targetFile.close();
            if (System.getProperty("resetClassTimestampToSource") != null) {
                targetFile.setLastModified(sourceFile.modDate());
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            String string = ResourceUtils.format("EXCEPTION_DURING_FILE_COPY", "Exception during file copy: {0}", e.getMessage());
            return string;
        }
        finally {
            sourceFile.close();
            targetFile.close();
        }
    }

    private void addSourcesFromSourcePaths(String[] packages, List<? extends Storage> sourcePaths, List<String> deployableExtensions, List<JavaFileObject> sources, List<String[]> deployables, String encoding, String outputPath) {
        for (Storage storage : sourcePaths) {
            block1: for (String packageName : packages) {
                Storage packageStorage = storage;
                if (!packageName.equals(".")) {
                    int lastIndex;
                    packageName = packageName.replace('\\', '/');
                    int firstIndex = 0;
                    do {
                        if ((lastIndex = packageName.indexOf(47, firstIndex)) < 0) {
                            lastIndex = packageName.length();
                        }
                        if ((packageStorage = packageStorage.open(packageName.substring(firstIndex, lastIndex))) == null || !packageStorage.isDirectory()) continue block1;
                    } while ((firstIndex = lastIndex + 1) < packageName.length());
                }
                ArrayList files = packageStorage.listStorage();
                block3: for (int x = 0; x < files.size(); ++x) {
                    Storage file = (Storage)files.get(x);
                    if (file.isDirectory()) continue;
                    if (file.getName().endsWith(".java")) {
                        sources.add(this.getJavaFileObject(null, file, encoding));
                        continue;
                    }
                    if (deployableExtensions == null) continue;
                    for (String extension : deployableExtensions) {
                        if (!file.getName().endsWith(extension)) continue;
                        String sourceLocation = file.getPath();
                        String targetLocation = outputPath + '/' + packageName;
                        deployables.add(new String[]{sourceLocation, targetLocation});
                        continue block3;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] expandFile(String[] argv, int curIndex, JavaCompilerLog<? extends JavaFileObject> log) {
        FileInputStream f = null;
        String[] newArgv = null;
        try {
            int i;
            byte[] buf;
            int fileSize;
            String fileName = argv[curIndex].substring(1);
            if (!new File(fileName).exists()) {
                String msg = ResourceUtils.format("FILE_DOES_NOT_EXIST", "Error: file {0} does not exist", fileName);
                log.error(null, 0L, 0L, 0, msg);
                return newArgv;
            }
            try {
                f = new FileInputStream(fileName);
                fileSize = f.available();
                buf = new byte[fileSize];
                f.read(buf, 0, fileSize);
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
            boolean firstChar = false;
            boolean inString = false;
            int argCnt = 0;
            block5: for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 96) {
                    if (i + 1 < fileSize && buf[i + 1] == 10) {
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                    if (i + 2 < fileSize && buf[i + 1] == 13 && buf[i + 2] == 10) {
                        buf[i++] = 1;
                        buf[i++] = 1;
                        buf[i] = 1;
                        continue;
                    }
                }
                if (!inString && Character.isWhitespace((char)buf[i])) {
                    buf[i] = 0;
                    firstChar = false;
                    continue;
                }
                if (!firstChar) {
                    if (buf[i] == 35) {
                        while (i < fileSize) {
                            byte b = buf[i];
                            buf[i] = 0;
                            if (b == 10) continue block5;
                            ++i;
                        }
                        continue;
                    }
                    firstChar = true;
                    ++argCnt;
                }
                if (buf[i] != 34) continue;
                buf[i] = 0;
                inString = !inString;
            }
            newArgv = new String[argCnt + argv.length - 1];
            if (curIndex > 0) {
                System.arraycopy(argv, 0, newArgv, 0, curIndex);
            }
            if (curIndex + 1 < argv.length) {
                System.arraycopy(argv, curIndex + 1, newArgv, curIndex + argCnt, argv.length - (curIndex + 1));
            }
            if (argCnt == 0) {
                return newArgv;
            }
            for (i = 0; i < fileSize; ++i) {
                if (buf[i] == 0) continue;
                int len = 0;
                int j = i;
                while (j < fileSize && buf[j] != 0) {
                    if (buf[j++] == 1) continue;
                    ++len;
                }
                byte[] tmpbuf = new byte[len];
                len = 0;
                while (i < fileSize && buf[i] != 0) {
                    if (buf[i] != 1) {
                        tmpbuf[len++] = buf[i];
                    }
                    ++i;
                }
                newArgv[curIndex++] = new String(tmpbuf);
            }
        }
        catch (Throwable e) {
            String msg = ResourceUtils.format("ERROR_COLON", "Error: {0}", e.getMessage());
            log.error(null, 0L, 0L, 0, msg);
            newArgv = null;
        }
        return newArgv;
    }

    static CharBuffer getCharBuffer(ByteBuffer byteBuffer, String encoding) throws IllegalStateException, IOException {
        CharBuffer charBuffer;
        if (encoding != null) {
            Charset charSet = Charset.forName(encoding);
            CharsetDecoder decoder = charSet.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            charBuffer = CharBuffer.allocate((int)((float)byteBuffer.limit() * decoder.maxCharsPerByte()));
            decoder.decode(byteBuffer, charBuffer, true);
            charBuffer.limit(charBuffer.position());
        } else {
            charBuffer = CharBuffer.allocate(byteBuffer.limit());
            for (int x = 0; x < byteBuffer.limit(); ++x) {
                charBuffer.put((char)(0xFFFF & byteBuffer.get(x)));
            }
        }
        charBuffer.rewind();
        return charBuffer;
    }

    private static class NullLog
    implements JavaCompilerLog<JavaFileObject> {
        private int nErrors;
        private int nWarnings;
        private final Pattern javacOldErrorWarningPattern = Pattern.compile("^(.*):([0-9]+):(.*)$");

        private NullLog() {
        }

        @Override
        public void println(String line) {
            System.out.println(line);
        }

        @Override
        public void error(JavaFileObject source, long line, long col, int errNumber, String errMsg) {
            ++this.nErrors;
            this.emitDiagnostic("ERROR_COLON", "Error: {0}", source, line, col, errMsg, System.err);
        }

        @Override
        public void warning(JavaFileObject source, long line, long col, int warnNumber, String warnMsg) {
            ++this.nWarnings;
            this.emitDiagnostic("WARNING_COLON", "Warning: {0}", source, line, col, warnMsg, System.out);
        }

        private void emitDiagnostic(String prefix1, String prefix2, JavaFileObject source, long line, long col, String diagnosticMsg, PrintStream printStream) {
            String msg;
            Matcher matcher = this.javacOldErrorWarningPattern.matcher(diagnosticMsg);
            if (matcher.matches()) {
                msg = diagnosticMsg;
            } else {
                StringBuilder buf = new StringBuilder();
                if (source != null) {
                    buf.append(source.toUri().getPath());
                    if (line > 0L) {
                        buf.append('(');
                        buf.append(line);
                        if (col > 0L) {
                            buf.append(',');
                            buf.append(col);
                        }
                        buf.append(')');
                    }
                    buf.append(": ");
                }
                buf.append(diagnosticMsg);
                msg = buf.toString();
            }
            printStream.println(ResourceUtils.format(prefix1, prefix2, msg));
        }

        @Override
        public void clear(JavaFileObject source) {
        }

        @Override
        public int nerrors() {
            return this.nErrors;
        }

        @Override
        public int nwarnings() {
            return this.nWarnings;
        }
    }

    private static class LogWriter
    extends Writer {
        private StringBuffer buf = new StringBuffer();
        private JavaCompilerLog<? extends JavaFileObject> log;

        LogWriter(JavaCompilerLog<? extends JavaFileObject> log) {
            this.log = log;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.buf.append(cbuf, off, len);
            if (this.buf.length() > 512) {
                this.flushLines(false);
            }
        }

        private void flushLines(boolean flushAll) {
            String str = this.buf.toString();
            StringTokenizer tokenizer = new StringTokenizer(str, "\n\r", true);
            String lastToken = "";
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    this.log.println(lastToken);
                    lastToken = "";
                    continue;
                }
                if (token.equals("\r")) continue;
                lastToken = token;
            }
            if (flushAll) {
                if (lastToken.length() > 0) {
                    this.log.println(lastToken);
                }
                this.buf.setLength(0);
            } else {
                this.buf.replace(0, this.buf.length(), lastToken);
            }
        }

        @Override
        public void flush() {
            this.flushLines(true);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

