/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.IOException;
import java.io.InputStream;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;

class AnnotationProcessorClassLoader
extends ClassLoader {
    private JDevJavaFileManager fileManager;
    private StandardLocation path;
    private JavaCompilerLog log;

    AnnotationProcessorClassLoader(JDevJavaFileManager fileManager, StandardLocation path, JavaCompilerLog log) {
        super(fileManager.getJavacClassLoader());
        this.fileManager = fileManager;
        this.path = path;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findClassOnPath(String name) throws IOException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        JavaFileObject classFile = this.fileManager.getJavaFileForInput(this.path, name, JavaFileObject.Kind.CLASS);
        if (classFile != null) {
            try (InputStream inputStream = null;){
                inputStream = classFile.openInputStream();
                int available = inputStream.available();
                byte[] bytes = new byte[available];
                int read = inputStream.read(bytes);
                if (available != read) {
                    throw new IOException("Incomplete read");
                }
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> loadedClass = ClassLoader.getSystemClassLoader().loadClass(name);
            if (loadedClass != null) {
                if (resolve) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
        }
        catch (ClassNotFoundException loadedClass) {
            // empty catch block
        }
        try {
            Class found = this.findClassOnPath(name);
            if (found != null) {
                if (resolve) {
                    this.resolveClass(found);
                }
                return found;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }
}

