/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPoint;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class CRLDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLDistributionPoints;
    private Vector distPoint = new Vector();

    public CRLDistPointExtension() {
        super(TYPE);
    }

    public CRLDistPointExtension(CRLDistPoint crlDistPoint) {
        this(crlDistPoint, false);
    }

    public CRLDistPointExtension(CRLDistPoint crlDistPoint, boolean critical) {
        super(TYPE, critical);
        this.addCRLDistPoint(crlDistPoint);
    }

    public CRLDistPointExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addCRLDistPoint(CRLDistPoint crlDistPoint) {
        this.distPoint.addElement(crlDistPoint);
        this.setValue(this.toByteArray());
    }

    public Vector getCRLDistPoints() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPoint;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.distPoint));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            if (this.distPoint == null) {
                this.distPoint = new Vector();
            } else {
                this.distPoint.removeAllElements();
            }
            while (sis.hasMoreData()) {
                this.distPoint.addElement(new CRLDistPoint((InputStream)sis));
            }
            sis.terminate();
            if (this.distPoint.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("crlDistPointExtension { oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCRLDistPoints() != null) {
            s.append("CRLDistributionPoints = { ");
            boolean mid = false;
            int size = this.getCRLDistPoints().size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((CRLDistPoint)this.getCRLDistPoints().elementAt(i)).toString());
                mid = true;
            }
            s.append(" }");
        }
        s.append("] }");
        return s.toString();
    }
}

