/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class BasicConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_basicConstraints;
    private boolean ca = false;
    private BigInteger pathLen = null;

    public BasicConstraintsExtension() {
        super(TYPE);
    }

    public BasicConstraintsExtension(boolean ca) {
        this(ca, true);
    }

    public BasicConstraintsExtension(boolean ca, boolean critical) {
        super(TYPE, critical);
        this.ca = ca;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(BigInteger pathLen) {
        this(pathLen, true);
    }

    public BasicConstraintsExtension(BigInteger pathLen, boolean critical) {
        super(TYPE, critical);
        this.ca = true;
        this.pathLen = pathLen;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(InputStream is) throws IOException {
        super(is);
    }

    public boolean getCA() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.ca;
    }

    public BigInteger getPathLen() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.pathLen;
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        if (this.ca) {
            seq.addElement((ASN1Object)new ASN1Boolean(true));
        }
        if (this.pathLen != null) {
            seq.addElement((ASN1Object)new ASN1Integer(this.pathLen));
        }
        byte[] b = Utils.toBytes((Streamable)seq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                this.ca = ASN1Boolean.inputValue((InputStream)sis);
            }
            if (sis.hasMoreData()) {
                if (this.ca) {
                    this.pathLen = ASN1Integer.inputValue((InputStream)sis);
                } else {
                    throw new ASN1FormatException("Malformed extension contents");
                }
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "basicConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [ CA = " + this.getCA() + (this.getPathLen() != null ? ", pathLen = " + this.getPathLen() : "") + "]}";
    }
}

