/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class GeneralNames
implements ASN1Object,
Externalizable {
    private Vector gns = new Vector();
    private ASN1Sequence contents;

    public GeneralNames() {
    }

    public GeneralNames(Vector generalNames) {
        this.addGeneralNames(generalNames);
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    public GeneralNames(X500Name directoryName) {
        this(directoryName, null);
    }

    public GeneralNames(String rfc822Name) {
        this(null, rfc822Name);
    }

    public GeneralNames(X500Name directoryName, String rfc822Name) {
        if (directoryName != null) {
            this.addGeneralName(directoryName);
        }
        if (rfc822Name != null) {
            this.addGeneralName(rfc822Name);
        }
    }

    public GeneralNames(InputStream is) throws IOException {
        this.input(is);
    }

    public void addGeneralName(X500Name directoryName) {
        if (directoryName != null) {
            this.addGeneralName(new GeneralName(directoryName));
        }
    }

    public void addGeneralName(String rfc822Name) {
        if (rfc822Name != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, rfc822Name));
        }
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.gns.addElement(generalName);
            this.clearContents();
        }
    }

    public void addGeneralNames(Vector generalNames) {
        if (generalNames != null) {
            int j = generalNames.size();
            for (int i = 0; i < j; ++i) {
                this.gns.addElement(generalNames.elementAt(i));
            }
            this.clearContents();
        }
    }

    public boolean removeGeneralName(X500Name directoryName) {
        if (directoryName != null) {
            return this.removeGeneralName(new GeneralName(directoryName));
        }
        return false;
    }

    public boolean removeGeneralName(String rfc822Name) {
        if (rfc822Name != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, rfc822Name));
        }
        return false;
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean rv = false;
        if (generalName != null) {
            rv = this.gns.removeElement(generalName);
            if (rv) {
                // empty if block
            }
            this.clearContents();
        }
        return rv;
    }

    public GeneralName removeGeneralName(int index) {
        GeneralName rv = (GeneralName)this.gns.elementAt(index);
        this.gns.removeElementAt(index);
        this.clearContents();
        return rv;
    }

    public boolean removeGeneralNames(Vector generalNames) {
        boolean rv = false;
        if (generalNames != null && generalNames.size() != 0) {
            boolean res = false;
            int j = generalNames.size();
            for (int i = 0; i < j; ++i) {
                res = this.gns.removeElement(generalNames.elementAt(i));
                if (rv) continue;
                rv = res;
            }
        }
        if (rv) {
            this.clearContents();
        }
        return rv;
    }

    public GeneralName generalNameAt(int index) {
        return (GeneralName)this.gns.elementAt(index);
    }

    public int size() {
        return this.gns.size();
    }

    public boolean containsGeneralName(GeneralName gn) {
        if (gn == null || this.gns == null || this.gns.size() < 1) {
            return false;
        }
        return this.gns.contains(gn);
    }

    public String toString() {
        if (this.gns == null || this.gns.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer sb = new StringBuffer("GeneralNames: " + this.gns.size() + " Elements\n");
        int j = this.gns.size();
        for (int i = 0; i < j; ++i) {
            sb.append(i + ". " + (GeneralName)this.gns.elementAt(i) + "\n");
        }
        return sb.toString();
    }

    public Vector getGeneralNames() {
        return this.gns;
    }

    public Enumeration generalNames() {
        if (this.gns == null) {
            return new Vector().elements();
        }
        return this.gns.elements();
    }

    public Vector getRFC822Names() {
        if (this.gns == null || this.gns.size() < 1) {
            return null;
        }
        Vector<String> em = null;
        int j = this.gns.size();
        for (int i = 0; i < j; ++i) {
            GeneralName gn = (GeneralName)this.gns.elementAt(i);
            if (!gn.getType().equals(GeneralName.Type.RFC822_NAME)) continue;
            if (em == null) {
                em = new Vector<String>();
            }
            em.addElement(((ASN1String)gn.getValue()).getValue());
        }
        return em;
    }

    public void input(InputStream is) throws IOException {
        this.clearContents();
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.hasMoreData()) {
            this.gns = new Vector();
            while (seq.hasMoreData()) {
                this.gns.addElement(new GeneralName((InputStream)seq));
            }
        }
        seq.terminate();
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    public void output(OutputStream os) throws IOException {
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.gns);
        }
        return this.contents;
    }

    private void clearContents() {
        this.contents = null;
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

