/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.StringValue;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIteratorOptions;

public class OnsdTableRowIterator
extends AbstractOnsdIterator<FieldValue> {
    protected PrimaryKey primaryKey;
    protected MultiRowOptions rowOptions;
    protected TableIteratorOptions iteratorOptions;
    protected List<String> fields;
    protected Iterator<Row> rowIterator;

    public OnsdTableRowIterator(PrimaryKey primaryKey, MultiRowOptions multiRowOptions, TableIteratorOptions tableIteratorOptions) {
        this.primaryKey = primaryKey;
        this.rowOptions = multiRowOptions;
        this.iteratorOptions = tableIteratorOptions;
        this.fields = null;
        this.rowIterator = null;
    }

    public int getFieldCount() {
        List<String> list = this.getFields();
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public Class<?> getFieldClass(int n) {
        FieldDef fieldDef = this.getFieldMetadata(n);
        if (fieldDef != null) {
            FieldDef.Type type = fieldDef.getType();
            switch (type) {
                case BINARY: {
                    return BinaryValue.class;
                }
                case BOOLEAN: {
                    return BooleanValue.class;
                }
                case DOUBLE: {
                    return DoubleValue.class;
                }
                case ENUM: {
                    return EnumValue.class;
                }
                case FIXED_BINARY: {
                    return FixedBinaryValue.class;
                }
                case FLOAT: {
                    return FloatValue.class;
                }
                case INTEGER: {
                    return IntegerValue.class;
                }
                case LONG: {
                    return LongValue.class;
                }
                case STRING: {
                    return StringValue.class;
                }
                case MAP: {
                    return MapValue.class;
                }
                case RECORD: {
                    return RecordValue.class;
                }
                case ARRAY: {
                    return ArrayValue.class;
                }
            }
        }
        return Object.class;
    }

    public FieldDef getFieldMetadata(int n) {
        List<String> list = this.getFields();
        Table table = this.getTable();
        if (table != null && list != null) {
            return table.getField(list.get(n));
        }
        return null;
    }

    public String getFieldName(int n) {
        List<String> list = this.getFields();
        if (list != null) {
            return list.get(n);
        }
        return "" + n;
    }

    public boolean hasNext() {
        if (this.rowIterator == null) {
            this.rowIterator = this.getTableIterator();
        }
        if (this.rowIterator != null) {
            return this.rowIterator.hasNext();
        }
        return false;
    }

    public Iterable<FieldValue> next() {
        if (this.rowIterator == null) {
            this.rowIterator = this.getTableIterator();
        }
        if (this.rowIterator != null) {
            Row row = this.rowIterator.next();
            ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
            if (row != null && this.fields != null) {
                for (String string : this.fields) {
                    FieldValue fieldValue = row.get(string);
                    arrayList.add(fieldValue);
                }
                return arrayList;
            }
        }
        return null;
    }

    protected Table getTable() {
        Table table = null;
        if (this.primaryKey != null) {
            table = this.primaryKey.getTable();
        }
        return table;
    }

    private Iterator<Row> getTableIterator() {
        try {
            TableAPI tableAPI = this.getTableAPI();
            this.fields = this.getFields();
            return tableAPI.tableIterator(this.primaryKey, this.rowOptions, this.iteratorOptions);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<String> getFields() {
        try {
            if (this.fields == null) {
                this.fields = this.getTable().getFields();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.fields;
    }

    @Override
    public void close() throws IOException {
        this.rowIterator = null;
    }
}

