/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.kv.table.Index;
import oracle.kv.table.Table;

public class OnsdTableIndexIterator
extends AbstractOnsdIterator<Object> {
    protected Table table;
    protected List<List<Object>> properties;
    protected Iterator<List<Object>> propertyIter;

    public OnsdTableIndexIterator(Table table) {
        this.table = table;
        this.properties = null;
        this.propertyIter = null;
    }

    public Class<?> getFieldClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    public int getFieldCount() {
        return 2;
    }

    public Object getFieldMetadata(int n) {
        return null;
    }

    public String getFieldName(int n) {
        switch (n) {
            case 0: {
                return OnsdTableIndexIterator.getFieldLabel("TABLE_NAME_LABEL");
            }
            case 1: {
                return OnsdTableIndexIterator.getFieldLabel("DESCRIPTION_LABEL");
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.propertyIter == null) {
            this.propertyIter = this.getPropertyIterator();
        }
        if (this.propertyIter != null) {
            return this.propertyIter.hasNext();
        }
        return false;
    }

    public Iterable<Object> next() {
        return this.propertyIter.next();
    }

    private Iterator<List<Object>> getPropertyIterator() {
        try {
            this.properties = new ArrayList<List<Object>>();
            Map map = this.table.getIndexes();
            for (Index index : map.values()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(index.getName());
                arrayList.add(index.getDescription());
                this.properties.add(arrayList);
            }
            return this.properties.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.propertyIter = null;
    }
}

