/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.onsd.OnsdBrowserResources;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.kv.table.Table;

public class OnsdTableDetailsIterator
extends AbstractOnsdIterator<Object> {
    protected Table table;
    protected List<List<Object>> properties;
    protected Iterator<List<Object>> propertyIter;

    public OnsdTableDetailsIterator(Table table) {
        this.table = table;
        this.properties = null;
        this.propertyIter = null;
    }

    public Class<?> getFieldClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public int getFieldCount() {
        return 2;
    }

    public Object getFieldMetadata(int n) {
        return null;
    }

    public String getFieldName(int n) {
        switch (n) {
            case 0: {
                return OnsdTableDetailsIterator.getFieldLabel("PROPERTY_LABEL");
            }
            case 1: {
                return OnsdTableDetailsIterator.getFieldLabel("VALUE_LABEL");
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.propertyIter == null) {
            this.propertyIter = this.getPropertyIterator();
        }
        if (this.propertyIter != null) {
            return this.propertyIter.hasNext();
        }
        return false;
    }

    public Iterable<Object> next() {
        return this.propertyIter.next();
    }

    private Iterator<List<Object>> getPropertyIterator() {
        try {
            this.properties = new ArrayList<List<Object>>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object = this.table.getName();
            arrayList.add(OnsdBrowserResources.getString("NAME_LABEL"));
            arrayList.add(object != null ? object : "");
            this.properties.add(arrayList);
            arrayList = new ArrayList();
            object = this.table.getFullName();
            arrayList.add(OnsdBrowserResources.getString("FULL_NAME_LABEL"));
            arrayList.add(object != null ? object : "");
            this.properties.add(arrayList);
            arrayList = new ArrayList();
            object = this.table.getTableVersion();
            arrayList.add(OnsdBrowserResources.getString("TABLE_VERSION_LABEL"));
            arrayList.add(object != null ? object : "");
            this.properties.add(arrayList);
            arrayList = new ArrayList();
            object = this.table.getDescription();
            arrayList.add(OnsdBrowserResources.getString("DESCRIPTION_LABEL"));
            arrayList.add(object != null ? object : "");
            this.properties.add(arrayList);
            return this.properties.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.propertyIter = null;
    }
}

