/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.kv.table.Table;

public class OnsdTableChildrenIterator
extends AbstractOnsdIterator<Object> {
    protected Table table;
    protected List<List<Object>> properties;
    protected Iterator<List<Object>> propertyIter;

    public OnsdTableChildrenIterator(Table table) {
        this.table = table;
        this.properties = null;
    }

    public Class<?> getFieldClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    public int getFieldCount() {
        return 4;
    }

    public Object getFieldMetadata(int n) {
        return null;
    }

    public String getFieldName(int n) {
        switch (n) {
            case 0: {
                return OnsdTableChildrenIterator.getFieldLabel("TABLE_NAME_LABEL");
            }
            case 1: {
                return OnsdTableChildrenIterator.getFieldLabel("TABLE_FULL_NAME_LABEL");
            }
            case 2: {
                return OnsdTableChildrenIterator.getFieldLabel("VERSION_LABEL");
            }
            case 3: {
                return OnsdTableChildrenIterator.getFieldLabel("DESCRIPTION_LABEL");
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.propertyIter == null) {
            this.propertyIter = this.getPropertyIterator();
        }
        if (this.propertyIter != null) {
            return this.propertyIter.hasNext();
        }
        return false;
    }

    public Iterable<Object> next() {
        return this.propertyIter.next();
    }

    private Iterator<List<Object>> getPropertyIterator() {
        try {
            this.properties = new ArrayList<List<Object>>();
            Map map = this.table.getChildTables();
            for (Table table : map.values()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(table.getName());
                arrayList.add(table.getFullName());
                arrayList.add(table.getTableVersion());
                arrayList.add(table.getDescription());
                this.properties.add(arrayList);
            }
            return this.properties.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.propertyIter = null;
    }
}

