/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls.grid;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.IRowIterator;
import oracle.dbtools.raptor.controls.grid.IteratorTableModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdGridColumn;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;

public class OnsdIteratorTableModel
extends IteratorTableModel {
    protected String connName;
    protected transient ArrayList<GridColumn> columns = null;
    protected transient IRowIterator<Iterable> rowIterator = null;

    public OnsdIteratorTableModel() {
        this.setFetchSize(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
    }

    public void init(String string, IRowIterator iRowIterator) {
        this.connName = string;
        this.rowIterator = iRowIterator;
        this.columns = null;
        this.rowIterator = iRowIterator;
    }

    protected RaptorTask<List<RaptorGridRowModel>> createFetchTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, final int n) {
        return new RaptorTask<List<RaptorGridRowModel>>(string, bl, iRaptorTaskRunMode){

            protected List<RaptorGridRowModel> doWork() throws TaskException {
                try {
                    this.checkCanProceed();
                    OnsdIteratorTableModel.this.fetchNext(n, this.getRaptorTaskProgressUpdater());
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new TaskException((Throwable)executionException);
                }
                return OnsdIteratorTableModel.this.getModelList();
            }

            public boolean cancel() {
                return true;
            }
        };
    }

    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (this.rowIterator != null) {
            int n2 = this.getModelList().size();
            while (n > 0 && this.rowIterator.hasNext()) {
                Iterable iterable = this.rowIterator.next();
                ArrayList<RaptorGridCell> arrayList = new ArrayList<RaptorGridCell>();
                if (iterable != null) {
                    for (Object t : iterable) {
                        arrayList.add(new RaptorGridCell(t));
                    }
                }
                this.addRow(arrayList, n2);
                ++n2;
                --n;
            }
        }
        if (this.rowIterator == null || !this.rowIterator.hasNext()) {
            this.setAllRowsFetched(true);
        }
    }

    public int getColumnCount() {
        return this.getGridColumns().size();
    }

    public List<? extends GridColumn> getGridColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList();
            if (this.rowIterator != null) {
                int n = this.rowIterator.getFieldCount();
                for (int i = 0; i < n; ++i) {
                    String string = this.rowIterator.getFieldName(i);
                    Object object = this.rowIterator.getFieldMetadata(i);
                    OnsdGridColumn onsdGridColumn = new OnsdGridColumn(string, false);
                    onsdGridColumn.setMetaData(object);
                    this.columns.add(onsdGridColumn);
                }
            }
        }
        return this.columns;
    }

    public String getConnectionName() {
        return this.connName;
    }

    public String getModelUniqueName() {
        if (this.rowIterator != null) {
            return this.rowIterator.getIteratorUniqueName();
        }
        return null;
    }

    public boolean isFilterApplied() {
        return false;
    }

    public boolean isSortable() {
        return false;
    }

    protected int findTotalRows(boolean bl) {
        return -1;
    }

    public Class<?> getColumnClass(int n) {
        Class<Object> clazz = this.rowIterator != null ? this.rowIterator.getFieldClass(n) : null;
        return clazz != null ? clazz : Object.class;
    }

    public void closeModel() {
        super.closeModel();
        if (this.rowIterator instanceof Closeable) {
            try {
                ((Closeable)this.rowIterator).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return false;
    }

    public final boolean isCellEditable(int n, int n2) {
        return true;
    }

    public String getFilterClause() {
        if (this.rowIterator instanceof AbstractOnsdIterator) {
            return ((AbstractOnsdIterator)this.rowIterator).getFilterClause();
        }
        return null;
    }

    public void setFilterClause(String string) {
        if (this.rowIterator instanceof AbstractOnsdIterator) {
            ((AbstractOnsdIterator)this.rowIterator).setFilterClause(string);
        }
    }
}

