/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls.grid;

import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.grid.IRowIterator;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.onsd.Messages;
import oracle.dbtools.raptor.onsd.OnsdUtil;
import oracle.dbtools.raptor.onsd.controls.celleditor.TableCellEditorFactory;
import oracle.dbtools.raptor.onsd.controls.cellrenderer.TableCellRendererFactory;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdGridController;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdIteratorTableModel;
import oracle.dbtools.raptor.onsd.controls.grid.OnsdTableModelFactory;
import oracle.kv.table.FieldDef;

public class OnsdIteratorTable
extends RaptorGridTable {
    private static final Logger logger = Logger.getLogger(OnsdIteratorTable.class.getName());
    protected OnsdGridController controller;

    public OnsdIteratorTable() {
        TableCellRendererFactory tableCellRendererFactory = this.getTableCellRendererFactory();
        TableCellEditorFactory tableCellEditorFactory = this.getTableCellEditorFactory();
        OnsdUtil onsdUtil = OnsdUtil.getInstance();
        for (FieldDef.Type type : FieldDef.Type.values()) {
            Class<?> clazz = onsdUtil.getClassForFieldType(type);
            this.setDefaultRenderer(clazz, tableCellRendererFactory.getDefaultTableCellRenderer(clazz));
            this.setDefaultEditor(clazz, tableCellEditorFactory.getDefaultTableCellEditor(clazz, (JTable)((Object)this)));
        }
        this.setDefaultEditor(Integer.class, tableCellEditorFactory.getDefaultTableCellEditor(Integer.class, (JTable)((Object)this)));
        this.setDefaultEditor(String.class, tableCellEditorFactory.getDefaultTableCellEditor(String.class, (JTable)((Object)this)));
        this.setDefaultEditor(Boolean.class, tableCellEditorFactory.getDefaultTableCellEditor(Boolean.class, (JTable)((Object)this)));
        this.setDefaultEditor(Object.class, tableCellEditorFactory.getDefaultTableCellEditor(Object.class, (JTable)((Object)this)));
        this.controller = new OnsdGridController();
        this.controller.setGrid(this);
    }

    public OnsdGridController getController() {
        return this.controller;
    }

    protected void setController(OnsdGridController onsdGridController) {
        this.controller = onsdGridController;
    }

    protected TableCellRendererFactory getTableCellRendererFactory() {
        return TableCellRendererFactory.getInstance();
    }

    protected TableCellEditorFactory getTableCellEditorFactory() {
        return TableCellEditorFactory.getInstance();
    }

    public void open(RaptorGridTaskWrapper raptorGridTaskWrapper) throws ExecutionException {
        OnsdIteratorTableModel onsdIteratorTableModel = this.getGridModel();
        if (onsdIteratorTableModel != null) {
            onsdIteratorTableModel.open(raptorGridTaskWrapper);
        } else {
            logger.severe(Messages.getString("OnsdIteratorTable.0"));
        }
    }

    public OnsdIteratorTableModel getGridModel() {
        if (this.getModel() instanceof OnsdIteratorTableModel) {
            return (OnsdIteratorTableModel)((Object)this.getModel());
        }
        return null;
    }

    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        OnsdIteratorTableModel onsdIteratorTableModel = this.getGridModel();
        tableColumn.setCellRenderer(this.getDefaultRenderer(onsdIteratorTableModel.getColumnClass(n)));
        super.addColumn(tableColumn);
    }

    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return super.getDefaultRenderer(clazz);
    }

    public TableCellEditor getDefaultEditor(Class<?> clazz) {
        return super.getDefaultEditor(clazz);
    }

    public void setQuery(String string, IRowIterator iRowIterator) {
        OnsdIteratorTableModel onsdIteratorTableModel = OnsdTableModelFactory.getInstance().getOnsdIteratorTableModel(string, iRowIterator);
        onsdIteratorTableModel.setVerticalDisplay(this.isVerticalDisplay());
        this.setModel((TableModel)((Object)onsdIteratorTableModel));
    }
}

