/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.controls;

import java.awt.Component;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.onsd.connection.NSConnectionType;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.connection.ui.ConnectionEditor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.util.SwingUtils;

public class OnsdConnectionSelector
extends ConnectionPanelUI {
    private static final String LAST_CONN_KEY = "OnsdConnectionSelector.LAST_CONNECTION";
    private final NSConnectionType m_type;

    public OnsdConnectionSelector(NSConnectionType nSConnectionType) {
        super(false, false, null);
        this.m_type = nSConnectionType;
        this.resetConnections();
    }

    public String[] listConnections() {
        return NSConnections.getInstance(this.m_type).listConnections();
    }

    protected void checkConnection() {
        String string = this.getConnectionName();
        if (NSConnections.getInstance(this.m_type).getConnectionInfo(string) != null) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
    }

    protected String getSettingsKey() {
        return LAST_CONN_KEY;
    }

    protected String runConnectionDialog(String string) {
        ConnectionEditor connectionEditor = ConnectionEditor.getInstance();
        return string != null ? connectionEditor.editConnection(string, this.m_type) : connectionEditor.createConnection(this.m_type);
    }

    public static String getConnection(String string, String string2, String string3, NSConnectionType nSConnectionType) {
        OnsdConnectionSelector onsdConnectionSelector = new OnsdConnectionSelector(nSConnectionType){
            private JEWTDialog m_dlg;

            private JEWTDialog getParentDialog() {
                if (this.m_dlg == null) {
                    this.m_dlg = (JEWTDialog)SwingUtils.getAncestorDialog((Component)((Object)this));
                }
                return this.m_dlg;
            }

            public boolean setConnectionName(String string) {
                if (super.setConnectionName(string)) {
                    JEWTDialog jEWTDialog = this.getParentDialog();
                    if (jEWTDialog != null) {
                        jEWTDialog.setOKButtonEnabled(string != null);
                    }
                    return true;
                }
                return false;
            }
        };
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)onsdConnectionSelector), (Component)onsdConnectionSelector.getDefaultFocusComponent(), (String)string);
        jEWTDialog.setOKButtonEnabled(onsdConnectionSelector.getConnectionCount() > 0);
        onsdConnectionSelector.setConnectionPrompt(string2);
        String string4 = null;
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            string4 = onsdConnectionSelector.getConnectionName();
        }
        return string4;
    }
}

