/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProxySelector;
import oracle.dbtools.util.Logger;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.IdeProxySelector;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;

class UsageClient
implements Closeable {
    private CloseableHttpClient mHttpClient;

    static UsageClient createClient() {
        Object object;
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(30000).build();
        BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager();
        basicHttpClientConnectionManager.setSocketConfig(socketConfig);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)basicHttpClientConnectionManager);
        httpClientBuilder.setUserAgent("SQL Developer Usage Tracker");
        IdeProxySelector ideProxySelector = new IdeProxySelector(ProxySelector.getDefault());
        SystemDefaultRoutePlanner systemDefaultRoutePlanner = new SystemDefaultRoutePlanner((ProxySelector)ideProxySelector);
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)systemDefaultRoutePlanner);
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        if (proxyOptions.getUseProxy().booleanValue() && proxyOptions.getUseProxyAuthentication().booleanValue()) {
            object = proxyOptions.getProxyHost();
            Integer n = Integer.valueOf(proxyOptions.getProxyPort());
            String string = proxyOptions.getProxyUserName();
            char[] cArray = proxyOptions.getProxyPassword();
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope((String)object, n.intValue()), (Credentials)new UsernamePasswordCredentials(string, new String(cArray)));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        object = httpClientBuilder.build();
        return new UsageClient((CloseableHttpClient)object);
    }

    private UsageClient(CloseableHttpClient closeableHttpClient) {
        this.mHttpClient = closeableHttpClient;
    }

    public CloseableHttpResponse executeRequest(HttpUriRequest httpUriRequest) throws ClientProtocolException, IOException {
        return this.mHttpClient.execute(httpUriRequest);
    }

    public <T> T executeRequest(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws ClientProtocolException, IOException {
        return (T)this.mHttpClient.execute(httpUriRequest, responseHandler);
    }

    @Override
    public void close() {
        if (this.mHttpClient == null) {
            Logger.warn(UsageClient.class, (String)"Attempt to close already closed HttpClient");
            return;
        }
        try {
            this.mHttpClient.close();
        }
        catch (IOException iOException) {
            Logger.severe(UsageClient.class, (String)"Unexpected error attempting to close HttpClient", (Throwable)iOException);
        }
        this.mHttpClient = null;
    }
}

