/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.net.URL;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.connections.impexp.AutoImport;
import oracle.dbtools.util.Logger;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeArgs;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.CommandParser;

public class AutoCreateConnectionsAddin
implements Addin {
    private static final String CONNECTIONS_ARG = "-connections";
    private static final String CONNECTIONS_KEY_ARG = "-connections_key";
    private URL mSource;
    private String mKey;

    public void initialize() {
        this.parseCommandLine();
        if (this.mSource != null) {
            Ide.addIdeListener((IdeListener)new IdeAdapter(){

                public void mainWindowOpened(IdeEvent ideEvent) {
                    block3: {
                        try {
                            Logger.info(AutoCreateConnectionsAddin.class, (String)RaptorExtrasResources.format("AUTOIMP_START_MSG", URLFileSystem.getPlatformPathName((URL)AutoCreateConnectionsAddin.this.mSource)));
                            AutoImport autoImport = AutoImport.createImporter((URL)AutoCreateConnectionsAddin.this.mSource);
                            if (AutoCreateConnectionsAddin.this.mKey != null) {
                                autoImport.setKey(AutoCreateConnectionsAddin.this.mKey);
                            }
                            autoImport.doImport();
                            Logger.info(AutoCreateConnectionsAddin.class, (String)RaptorExtrasResources.getString("AUTOIMP_SUCCESS_MSG"));
                        }
                        catch (AutoImport.ImportException importException) {
                            Logger.severe(AutoCreateConnectionsAddin.class, (String)RaptorExtrasResources.getString("AUTOIMP_SUCCESS_MSG"));
                            Logger.severe(AutoCreateConnectionsAddin.class, (String)importException.getLocalizedMessage());
                            if (importException.getCause() == null) break block3;
                            Logger.severe(AutoCreateConnectionsAddin.class, (String)importException.getCause().getLocalizedMessage());
                        }
                    }
                }
            });
        }
    }

    private void parseCommandLine() {
        IdeArgs ideArgs = Ide.getIdeArgs();
        for (String string : ideArgs.getArgs()) {
            int n;
            if (string == null || (n = string.indexOf(61)) <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (CONNECTIONS_ARG.equals(string2)) {
                if (!ModelUtil.hasLength((String)string3)) continue;
                CommandParser.Converter converter = new CommandParser().getConverter(URL.class);
                try {
                    this.mSource = (URL)converter.convert(string3, URL.class);
                }
                catch (Exception exception) {
                    Logger.severe(AutoCreateConnectionsAddin.class, (Throwable)exception);
                }
                continue;
            }
            if (!CONNECTIONS_KEY_ARG.equals(string2) || !ModelUtil.hasLength((String)string3)) continue;
            this.mKey = string3;
        }
    }
}

