/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITCancellable;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITPushWizard;
import oracle.jdevimpl.vcs.git.wiz.GITWizard;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class GITRemoteWizard
extends GITWizard {
    protected static final String REPOS = "git.repository";
    protected static final String BRANCH = "git.branch";
    protected static final String SUMMARY = "git.summary";
    static final String REMOTE_DEFAULT_CONFIG = "git.remote-default-config";
    static final String DEFAULT_CONFIG = "git.default-remote";
    static final String REMOTE_NAME = "git.remote-name";
    static final String REMOTE_URI = "git.remote-uri";
    static final String REMOTE_BRANCHES = "git.remote-branches";
    static final String LOCAL_ROOT_URL = "git.local-url";
    static final String USE_REMOTE_BRANCHES = "git.use-branches";
    static final String REMOTE_USERNAME = "git.username";
    static final String REMOTE_PASSWORD = "git.password";
    static final String REMOTE_KEY_FILE = "git.keyfile";
    static final String REMOTE_PASSPHRASE = "git.passphrase";
    static final String REMOTE_TAGS = "git.tags";

    protected Namespace populate(Context context) throws Exception {
        Namespace ns = new Namespace();
        URL url = this.getURLFromGitWorkTree(context);
        ns.put(REMOTE_DEFAULT_CONFIG, this.getRemoteConfigs(url));
        URL root = null;
        if (url != null) {
            root = GITUtil.getRootContaining(url);
        }
        if (root == null) {
            throw new GITProcessException(Resource.get("GIT_NO_WORKING_TREE"), "");
        }
        ns.put(LOCAL_ROOT_URL, (Object)root);
        return ns;
    }

    protected boolean runOperation(GITCancellable cancel) throws VCSException {
        return true;
    }

    protected class GITRemoteCommitListener
    implements CommitListener {
        private WizardDialog dialog;
        private Context _context;
        private String _name;

        public GITRemoteCommitListener(String name, WizardDialog wd, Context context) {
            this.dialog = wd;
            this._context = context;
            this._name = name;
        }

        public void checkCommit(ApplyEvent applyevent) throws TraversalException {
        }

        public void commit(ApplyEvent event) throws TraversalException {
            RequestProcessor processor = new RequestProcessor(this._name, 1, true);
            RequestProcessor.Task task = processor.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GITCancellable cancel = new GITCancellable();
                    ProgressHandle handle = ProgressHandle.createHandle((String)GITRemoteCommitListener.this._name, (Cancellable)cancel);
                    try {
                        handle.start();
                        if (!GITRemoteWizard.this.runOperation(cancel)) {
                            // empty if block
                        }
                        return;
                    }
                    catch (Exception e) {
                        GITProfile.getQualifiedLogger(GITPushWizard.class.getName()).log(Level.WARNING, "Failed to push", e);
                        GITRemoteWizard.this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITRemoteCommitListener.this.dialog.dispose();
                }
            });
        }

        public void rollback(ApplyEvent applyevent) {
        }

        public void cancel(ApplyEvent applyevent) {
        }
    }
}

