/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITWizardSummary;

public abstract class GITRemoteSummaryPanel
extends GITWizardSummary {
    @Override
    protected void initRes() {
    }

    @Override
    protected DefaultTreeModel buildTree(TraversableContext tc) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        DefaultTreeModel model = new DefaultTreeModel(root);
        model.setRoot(root);
        DefaultMutableTreeNode node = this.newNode(Resource.get("WZ_SUMMARY_REMOTE"));
        String remote = (String)tc.get("git.remote-name");
        node.add(this.newNode(remote));
        root.add(node);
        node = this.newNode(Resource.get("WZ_SUMMARY_REPOS"));
        String remoteUrl = (String)tc.get("git.remote-uri");
        node.add(this.newNode(remoteUrl));
        root.add(node);
        String username = (String)tc.get("git.username");
        if (username != null && !username.isEmpty()) {
            node = this.newNode(Resource.get("WZ_SUMMARY_USER"));
            node.add(this.newNode(username));
            root.add(node);
        }
        node = this.newNode(Resource.get("WZ_SUMMARY_BRANCH"));
        Map branches = (Map)tc.get("git.use-branches");
        ArrayList sortBranches = new ArrayList();
        sortBranches.addAll(branches.keySet());
        Collections.sort(sortBranches);
        for (String branch : sortBranches) {
            node.add(this.newNode(branch + " -> " + (String)branches.get(branch)));
        }
        root.add(node);
        node = this.newNode(Resource.get("WZ_SUMMARY_LOCAL_REPOSITORY"));
        URL local = (URL)tc.get("git.local-url");
        node.add(this.newNode(URLFileSystem.getPlatformPathName((URL)local)));
        root.add(node);
        this.operationSummry(root, tc);
        return model;
    }

    protected void operationSummry(DefaultMutableTreeNode defaultMutableTreeNode, TraversableContext traversableContext) {
    }
}

