/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import oracle.javatools.ui.table.GenericTableAutoSizeModel;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.jdeveloper.vcs.vop.DisplayProperty;

class GITRemoteBranchTableModel
extends DefaultTableModel
implements GenericTableModel,
GenericTableAutoSizeModel {
    private String[] _fromBranch;
    private Boolean[] _include;
    private DisplayProperty[] _properties;

    GITRemoteBranchTableModel(DisplayProperty[] properties) {
        this._properties = properties;
    }

    @Override
    public int getColumnCount() {
        return this._properties.length;
    }

    @Override
    public String getColumnName(int col) {
        return this._properties[col].getName();
    }

    public Class getColumnClass(int col) {
        return this._properties[col].getType();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this._include[row] = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._properties[column].isEditable();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0 && row < this._include.length) {
            return this._include[row];
        }
        if (col == 1 && row < this._fromBranch.length) {
            return this._fromBranch[row];
        }
        return new Object();
    }

    @Override
    public int getRowCount() {
        if (this._fromBranch == null || this._fromBranch.length == 0) {
            return 0;
        }
        return this._fromBranch.length;
    }

    DisplayProperty getProperty(int column) {
        return this._properties[column];
    }

    void addData(Set<String> branches, String defBranch, Collection<String> includeBranches) {
        this._fromBranch = branches.toArray(new String[0]);
        this._include = new Boolean[branches.size()];
        for (int b = 0; b < this._include.length; ++b) {
            this._include[b] = (Boolean)this._properties[0].getPrototypeValue();
            this._include[b] = includeBranches.contains(this._fromBranch[b]);
            if (!this._fromBranch[b].equals(defBranch)) continue;
            this._include[b] = Boolean.TRUE;
        }
        if (this._fromBranch.length > 0) {
            this.fireTableRowsInserted(0, this._fromBranch.length - 1);
        }
    }

    Collection<String> getIncludeBranches() {
        ArrayList<String> branches = new ArrayList<String>();
        for (int b = 0; b < this._include.length; ++b) {
            if (!this._include[b].booleanValue()) continue;
            branches.add(this._fromBranch[b]);
        }
        return branches;
    }

    public int getColumnAlignment(int column) {
        return this._properties[column].getAlignment();
    }

    public boolean canHide(int column) {
        return false;
    }

    public int getColumnAutoSizeMaximum(int column) {
        return this._properties[column].getMaximumDefaultSize();
    }

    void removeAll() {
        int row = this._fromBranch.length;
        this._fromBranch = new String[0];
        this._include = new Boolean[0];
        if (row > 0) {
            this.fireTableRowsDeleted(0, row - 1);
        }
    }
}

