/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagHelper;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;

public class GITResetCustomizer
extends VCSOptionsCustomizerAdapter {
    private GITResetPanel _panel;
    private GITBranchTagHelper _helper = new GITBranchTagHelper();
    private GITBranchTagValidator _validator = new GITBranchTagValidator();
    public static final String USE_OPTION_RESET = "git-reset";

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITResetPanel();
        }
        return this._panel;
    }

    public void setOptions(Map<?, ?> map) {
        GITResetPanel panel = (GITResetPanel)this.getComponent();
        this._helper.setOptions(map, panel.getBranch());
        ResetOption option = (ResetOption)((Object)map.get(USE_OPTION_RESET));
        panel.setResetOption(option);
    }

    public Map<?, ?> getOptions() {
        GITResetPanel panel = (GITResetPanel)this.getComponent();
        Map<String, Object> options = this._helper.getOptions(panel.getBranch());
        ResetOption option = panel.getResetOption();
        options.put(USE_OPTION_RESET, (Object)option);
        return options;
    }

    public void validateOptions() throws VCSException {
        URL root;
        String tag;
        Map<?, ?> opts = this.getOptions();
        String branch = (String)opts.get("Git-use-branch");
        VCSException exception = this._validator.validateBranchAndTag(branch, tag = (String)opts.get("Git-use-tag"), root = (URL)opts.get("Git-local-root"), Resource.get("RESET_ERROR_TITLE"), GITUtil.getBranches(root));
        if (exception != null) {
            throw exception;
        }
    }

    private static class GITResetPanel
    extends JPanel {
        private GITBranchRevisionPanel _brrevPanel = new GITBranchRevisionPanel();
        private JRadioButton _rdMixed = new JRadioButton();
        private JRadioButton _rdSoft = new JRadioButton();
        private JRadioButton _rdHard = new JRadioButton();
        private JLabel _lblOptions = new JLabel();

        private GITResetPanel() {
            this.init();
            this.initLayout();
        }

        GITBranchRevisionPanel getBranch() {
            return this._brrevPanel;
        }

        private void init() {
            ButtonGroup group = new ButtonGroup();
            group.add(this._rdMixed);
            group.add(this._rdSoft);
            group.add(this._rdHard);
            this._lblOptions.setText(Resource.get("RESET_OPTIONS"));
            ResourceUtils.resButton((AbstractButton)this._rdMixed, (String)Resource.get("RESET_OPTION_MIXED"));
            ResourceUtils.resButton((AbstractButton)this._rdHard, (String)Resource.get("RESET_OPTION_HARD"));
            ResourceUtils.resButton((AbstractButton)this._rdSoft, (String)Resource.get("RESET_OPTION_SOFT"));
        }

        private void initLayout() {
            Insets ins = new Insets(2, 50, 0, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._brrevPanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._lblOptions, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this._rdMixed, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._rdHard, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
            this.add((Component)this._rdSoft, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        }

        private void setResetOption(ResetOption option) {
            if (option == ResetOption.MIXED) {
                this._rdMixed.setSelected(true);
            } else if (option == ResetOption.HARD) {
                this._rdHard.setSelected(true);
            } else if (option == ResetOption.SOFT) {
                this._rdSoft.setSelected(true);
            }
        }

        private ResetOption getResetOption() {
            if (this._rdMixed.isSelected()) {
                return ResetOption.MIXED;
            }
            if (this._rdHard.isSelected()) {
                return ResetOption.HARD;
            }
            if (this._rdSoft.isSelected()) {
                return ResetOption.SOFT;
            }
            return null;
        }
    }

    public static enum ResetOption {
        HARD,
        MIXED,
        SOFT;

    }
}

