/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;

public class GITCreateTagPanel
extends JPanel {
    private JLabel _lblName = new JLabel();
    private JTextField _fldName = new JTextField();
    private JLabel _lblMessage = new JLabel();
    private JTextArea _fldMessage = new JTextArea();
    private GITBranchRevisionPanel _panel = new GITBranchRevisionPanel();

    public GITCreateTagPanel() {
        this.init();
        this.initLayout();
    }

    public void setRoot(URL url) {
        this._panel.setRepositoryRoot(url);
    }

    public void setRevisionBranch(String branch) {
        this._panel.setSelectedBranch(branch);
    }

    public String getRevisionBranch() {
        return this._panel.getSelectedBranch();
    }

    public String getRevisionTag() {
        return this._panel.getSelectedTag();
    }

    public Component getDefaultComp() {
        return this._fldName;
    }

    private void initLayout() {
        Insets ins = new Insets(5, 0, 5, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this._lblMessage, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this._fldMessage), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.add((Component)this._panel, new GridBagConstraints(0, 3, 2, 2, 1.0, 0.0, 17, 2, new Insets(2, 0, 5, 0), 0, 0));
    }

    private void init() {
        ResourceUtils.resLabel((JLabel)this._lblName, (Component)this._fldName, (String)Resource.get("CREATE_TAG_NAME"));
        ResourceUtils.resLabel((JLabel)this._lblMessage, (Component)this._fldMessage, (String)Resource.get("CREATE_TAG_MESSAGE"));
    }

    public String getTagName() {
        return this._fldName.getText();
    }

    public String getRevision() {
        return this._panel.getSelectedRevision();
    }

    public void setRevision(String rev) {
        if (rev != null) {
            this._panel.setSelectedRevision(rev);
        }
    }

    public String getComment() {
        return this._fldMessage.getText();
    }

    public boolean forceUpdate() {
        return false;
    }
}

