/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideimpl.vcscore.nav.VersioningNavigatorManager;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.nav.GITBranchLocalNode;
import oracle.jdevimpl.vcs.git.nav.GITBranchRemoteNode;
import oracle.jdevimpl.vcs.git.nav.GITConnectionListNode;
import oracle.jdevimpl.vcs.git.nav.GITConnectionNode;
import oracle.jdevimpl.vcs.git.nav.GITNavigatorController;
import oracle.jdevimpl.vcs.git.nav.GITRemoteConfigNode;
import oracle.jdevimpl.vcs.git.nav.GITRemotesListNode;
import oracle.jdevimpl.vcs.git.nav.GITStashListNode;
import oracle.jdevimpl.vcs.git.nav.GITTagListNode;

public final class GITRepositoryNavigator {
    private static final GITRepositoryNavigator _instance = new GITRepositoryNavigator();
    private GITConnectionListNode _connectionListNode;
    private GITNavigatorController _controller;

    private GITRepositoryNavigator() {
    }

    public static final GITRepositoryNavigator getInstance() {
        return _instance;
    }

    public void createRepositoryConnection(GITConnectionInfo info) {
        GITConnectionNode node = new GITConnectionNode(info);
        if (((GITConnectionListNode)this.getRepositoriesNode()).containsChild((Element)node)) {
            return;
        }
        ((GITConnectionListNode)this.getRepositoriesNode()).add((Element)node, true);
        if (this.getRepositoriesNode().isDirty()) {
            this.getRepositoriesNode().markDirty(false);
        }
    }

    public void updateNavigator(URL url, boolean remote, Node type, String name) {
        this.updateNavigator(url, remote);
        this.selectInExplorer(type, name);
    }

    public void updateNavigator(URL url, boolean remote) {
        Iterator it = this.getRepositoriesNode().getChildren();
        while (it.hasNext()) {
            URL clurl;
            GITConnectionNode node = (GITConnectionNode)it.next();
            if (!node.isLoaded() || !(clurl = node.getURL()).getPath().equals(url.getPath())) continue;
            Iterator bIt = node.getChildren();
            while (bIt.hasNext()) {
                DefaultContainer bNode = (DefaultContainer)bIt.next();
                if (!bNode.isLoaded()) continue;
                if (bNode instanceof GITTagListNode || bNode instanceof GITRemotesListNode || bNode instanceof GITStashListNode) {
                    RevertNodeCommand.reload((Node)bNode, (boolean)false);
                    this.updateExplorer(bNode);
                    continue;
                }
                Iterator bcIt = bNode.getChildren();
                while (bcIt.hasNext()) {
                    Node conNode = (Node)bcIt.next();
                    if (conNode instanceof GITBranchLocalNode) {
                        RevertNodeCommand.reload((Node)conNode, (boolean)false);
                        this.updateExplorer((DefaultContainer)conNode);
                        continue;
                    }
                    if (!(conNode instanceof GITBranchRemoteNode) || !remote) continue;
                    RevertNodeCommand.reload((Node)conNode, (boolean)false);
                    this.updateExplorer((DefaultContainer)conNode);
                }
            }
        }
    }

    void activate() {
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
        this._controller = new GITNavigatorController();
        IdeAction[] actions = this.getIdeActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].addController((Controller)this._controller);
        }
    }

    synchronized Node getRepositoriesNode() {
        if (this._connectionListNode == null) {
            this._connectionListNode = new GITConnectionListNode();
        }
        return this._connectionListNode;
    }

    private IdeAction[] getIdeActions() {
        int[] actionIds = new int[]{20, 51};
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(10);
        for (int i = 0; i < actionIds.length; ++i) {
            IdeAction action = IdeAction.find((int)actionIds[i]);
            if (action == null) continue;
            actions.add(action);
        }
        return actions.toArray(new IdeAction[actions.size()]);
    }

    private void selectInExplorer(Node type, String name) {
        Iterator it = this.getRepositoriesNode().getChildren();
        while (it.hasNext()) {
            URL clurl;
            GITConnectionNode cnode = (GITConnectionNode)it.next();
            if (!cnode.isLoaded() || !(clurl = cnode.getURL()).getPath().equals(cnode.getURL().getPath())) continue;
            Iterator bIt = cnode.getChildren();
            while (bIt.hasNext()) {
                DefaultContainer bNode = (DefaultContainer)bIt.next();
                if (!bNode.isLoaded() || !(bNode instanceof GITRemotesListNode) || !(type instanceof GITRemoteConfigNode)) continue;
                Node nNode = this.getNodeNamed(bNode, name);
                this.selectExplorer(nNode);
            }
        }
    }

    private void selectExplorer(Node node) {
        NavigatorWindow window = VersioningNavigatorManager.getInstance().getNavigatorWindow();
        TreeExplorer explorer = window.getTreeExplorer();
        TNode tnode = explorer.searchTNodeBreadthFirst((Element)node, explorer.getRoot());
        if (tnode != null) {
            explorer.setSelected(tnode);
        }
    }

    private void updateExplorer(DefaultContainer container) {
        NavigatorWindow window = VersioningNavigatorManager.getInstance().getNavigatorWindow();
        TreeExplorer explorer = window.getTreeExplorer();
        TNode tnode = explorer.searchTNodeBreadthFirst((Element)container, explorer.getRoot());
        if (tnode != null) {
            explorer.expand(tnode, false);
        }
    }

    private Node getNodeNamed(DefaultContainer bNode, String name) {
        Iterator it = bNode.getChildren();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getShortLabel().equals(name)) continue;
            return node;
        }
        return null;
    }
}

