/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITRemoteFetchNode
extends Node
implements GITRemote {
    private String _uri;

    public GITRemoteFetchNode(String uri, URL url) {
        this._uri = uri;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(url));
    }

    public String getURI() {
        return this._uri;
    }

    public String getShortLabel() {
        return Resource.format("REMOTE_FETCH_TEXT", this._uri);
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("REMOTE_FETCH_ICON")));
    }

    public String getToolTipText() {
        return Resource.get("REMOTE_FETCH_TOOLTIP");
    }

    public String toString() {
        return "Fetch " + this._uri;
    }

    public String getRemoteUri() {
        return this._uri;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITRemoteFetchNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

