/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commitgraph;

import java.net.URL;
import oracle.ide.Context;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.historygraph.VersionHistoryGraphEditor;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCreateTag;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITCommitGraphCreateTag
extends GITOperationCreateTag {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.graphcreatetag";

    public GITCommitGraphCreateTag() {
        super(COMMAND_ID);
    }

    @Override
    protected URL getGitClientRoot(VCSProfile profile) throws Exception {
        if (this.getContext().getNode() != null) {
            return this.getContext().getNode().getURL();
        }
        return null;
    }

    @Override
    protected String getGitRevision() {
        GraphNode gNode = (GraphNode)this.getContext().getProperty("version-history-graph-node");
        return gNode.getRevId();
    }

    @Override
    protected String getCurrentBranch(URL url) throws GITProcessException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            String string = GITUtil.getBranch(client, this.getGitRevision());
            return string;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITCommitGraphCreateTag.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("FAILED_GET_BRANCH_NAME"), e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    @Override
    protected int doitImpl(VCSProfile profile) throws Exception {
        int value = super.doitImpl(profile);
        Context context = this.getContext();
        if (context.getView() instanceof VersionHistoryGraphEditor) {
            ((VersionHistoryGraphEditor)context.getView()).clearSelection();
        }
        return value;
    }
}

