/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.commitgraph;

import java.net.URL;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCreateBranch;
import oracle.jdevimpl.vcs.git.commitgraph.GITGraphCommandHelper;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;

public class GITCommitGraphCreateBranch
extends GITOperationCreateBranch {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.graphcreatebranch";

    public GITCommitGraphCreateBranch() {
        super(COMMAND_ID);
    }

    @Override
    protected URL getGitClientRoot(VCSProfile profile) throws Exception {
        if (this.getContext().getNode() != null) {
            return this.getContext().getNode().getURL();
        }
        return null;
    }

    @Override
    protected String getCurrentBranch(URL url) throws GITProcessException {
        GraphNode gNode = (GraphNode)this.getContext().getProperty("version-history-graph-node");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            String string = GITUtil.getBranch(client, gNode.getRevId());
            return string;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITCommitGraphCreateBranch.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.get("FAILED_GET_BRANCH_NAME"), e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    @Override
    protected String getRevision() {
        GraphNode gNode = (GraphNode)this.getContext().getProperty("version-history-graph-node");
        if (gNode != null) {
            return gNode.getRevId();
        }
        return null;
    }

    @Override
    protected int doitImpl(VCSProfile profile) throws Exception {
        int value = super.doitImpl(profile);
        GITGraphCommandHelper helper = new GITGraphCommandHelper();
        helper.updateCommitGraph(this.getContext(), value);
        return value;
    }
}

