/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITPropertiesPanel
extends PropertiesPanel {
    private URL _url;
    private GITPropertiesPanelUI _component;

    public GITPropertiesPanel(URL url) {
        this._url = url;
    }

    public Component getComponent() {
        if (this._component == null) {
            this._component = new GITPropertiesPanelUI();
        }
        return this._component;
    }

    public void stopWorkerThreads() {
    }

    private class GITPropertiesPanelUI
    extends JPanel {
        private StatusData _statusData;
        private JLabel _branchLabel;
        private JLabel _statusLabel;
        private JLabel _authorLabel;
        private JLabel _commitAuthorLabel;
        private JLabel _commitTimeLabel;
        private JLabel _revisionLabel;
        private JLabel _messageLabel;
        private JLabel _statusValueLabel;
        private JTextField _branchValue;
        private JTextField _authorValue;
        private JTextField _commitAuthorValue;
        private JTextField _commitTimeValue;
        private JTextField _revisionValue;
        private JTextArea _messageValue;

        GITPropertiesPanelUI() {
            super(new GridBagLayout());
            this.createComponents();
            this.resComponents();
            this.layoutComponents();
            this.initializeComponents();
            this.populatePropertyComponents();
        }

        private void createComponents() {
            this._branchLabel = new JLabel();
            this._statusLabel = new JLabel();
            this._authorLabel = new JLabel();
            this._commitAuthorLabel = new JLabel();
            this._commitTimeLabel = new JLabel();
            this._revisionLabel = new JLabel();
            this._messageLabel = new JLabel();
            this._statusValueLabel = new JLabel();
            this._branchValue = new JTextField();
            this._authorValue = new JTextField();
            this._commitAuthorValue = new JTextField();
            this._commitTimeValue = new JTextField();
            this._revisionValue = new JTextField();
            this._messageValue = new JTextArea();
        }

        private void resComponents() {
            ResourceUtils.resLabel((JLabel)this._branchLabel, (Component)this._branchValue, (String)Resource.get("PROPERTY_BRANCH"));
            ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusValueLabel, (String)Resource.get("PROPERTY_STATUS"));
            ResourceUtils.resLabel((JLabel)this._authorLabel, (Component)this._authorValue, (String)Resource.get("PROPERTY_AUTHOR"));
            ResourceUtils.resLabel((JLabel)this._commitAuthorLabel, (Component)this._commitAuthorValue, (String)Resource.get("PROPERTY_COMMIT_AUTHOR"));
            ResourceUtils.resLabel((JLabel)this._commitTimeLabel, (Component)this._commitTimeValue, (String)Resource.get("PROPERTY_COMMIT_TIME"));
            ResourceUtils.resLabel((JLabel)this._revisionLabel, (Component)this._revisionValue, (String)Resource.get("PROPERTY_REVISION"));
            ResourceUtils.resLabel((JLabel)this._messageLabel, (Component)this._messageValue, (String)Resource.get("PROPERTY_MESSAGE"));
        }

        private void initializeComponents() {
            this.initializePropertyComponents(this._branchLabel, this._branchValue);
            this.initializePropertyComponents(this._authorLabel, this._authorValue);
            this.initializePropertyComponents(this._commitAuthorLabel, this._commitAuthorValue);
            this.initializePropertyComponents(this._commitTimeLabel, this._commitTimeValue);
            this.initializePropertyComponents(this._revisionLabel, this._revisionValue);
            this.initializePropertyComponentsText(this._messageLabel, this._messageValue);
        }

        private void initializePropertyComponentsText(JLabel label, JTextArea field) {
            if (field != null) {
                field.setBorder(BorderFactory.createEmptyBorder());
                field.setEditable(false);
                field.setLineWrap(true);
                field.setWrapStyleWord(true);
                field.setRows(5);
            }
        }

        private void initializePropertyComponents(JLabel label, JComponent propertyComponent) {
            if (propertyComponent instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)propertyComponent;
                textComponent.setBorder(BorderFactory.createEmptyBorder());
                textComponent.setEditable(false);
            }
        }

        private void layoutComponents() {
            Insets labelInsets = new Insets(5, 0, 5, 5);
            Insets fieldInsets = new Insets(5, 5, 5, 0);
            this.add((Component)this._branchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._branchValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._statusLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._statusValueLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._authorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._authorValue, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._commitAuthorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._commitAuthorValue, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._commitTimeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._commitTimeValue, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._revisionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._revisionValue, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
            this.add((Component)this._messageLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, labelInsets, 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, fieldInsets, 0, 0));
            JScrollPane pane = new JScrollPane(this._messageValue);
            this.add((Component)pane, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 1, new Insets(3, 0, 3, 3), 0, 0));
        }

        private void populatePropertyComponents() {
            this._statusData = new StatusData();
            String busyText = Resource.get("PROPERTIES_BUSY");
            try {
                VCSStatus status = (VCSStatus)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getPolicyStatusCache().get(GITPropertiesPanel.this._url);
                this._statusData._status = status.getOverlay().getToolTipText();
                this._statusData._statusIcon = this.getStatusIcon(GITPropertiesPanel.this._url, status);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this._statusData._status = "";
                this._statusData._statusIcon = null;
            }
            this._statusData._author = busyText;
            this._statusData._commitAuthor = busyText;
            this._statusData._commitRevision = busyText;
            this._statusData._commitTime = busyText;
            this._statusData._message = busyText;
            this.setAsynchronousValueComponentsEnabled(false);
            this.updateAsynchronousValueComponents();
            new Thread((Runnable)new AsynchronousValueWorker(GITPropertiesPanel.this._url), "GIT Properties (Asynchronous)").start();
        }

        private Icon getStatusIcon(URL url, VCSStatus status) {
            Node node = NodeFactory.find((URL)url);
            if (node == null) {
                return null;
            }
            Icon icon = node.getIcon();
            Icon overlayIcon = null;
            IconOverlay overlay = status.getOverlay();
            if (overlay != null) {
                overlayIcon = overlay.getDisplayable().getIcon();
            }
            if (overlayIcon == null) {
                return icon;
            }
            if (icon == null) {
                return overlayIcon;
            }
            return new OverlayIcon(icon, overlayIcon);
        }

        private void setAsynchronousValueComponentsEnabled(final boolean enabled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITPropertiesPanelUI.this._setAsynchronousValueComponentsEnabled(enabled);
                }
            });
        }

        private void _setAsynchronousValueComponentsEnabled(boolean enabled) {
            this._authorValue.setEnabled(enabled);
            this._commitAuthorValue.setEnabled(enabled);
            this._commitTimeValue.setEnabled(enabled);
            this._revisionValue.setEnabled(enabled);
            this._messageValue.setEnabled(enabled);
        }

        private void updateAsynchronousValueComponents() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITPropertiesPanelUI.this._updateAsynchronousValueComponents();
                }
            });
        }

        private void _updateAsynchronousValueComponents() {
            if (this._statusData._branch != null) {
                this._branchValue.setText(this._statusData._branch);
            }
            if (this._statusData._status != null) {
                this._statusValueLabel.setText(this._statusData._status);
                this._statusValueLabel.getAccessibleContext().setAccessibleDescription(this._statusData._status);
            }
            if (this._statusData._statusIcon != null) {
                this._statusValueLabel.setIcon(this._statusData._statusIcon);
            }
            if (this._statusData._author != null) {
                this._authorValue.setText(this._statusData._author);
            }
            if (this._statusData._commitAuthor != null) {
                this._commitAuthorValue.setText(this._statusData._commitAuthor);
            }
            if (this._statusData._commitRevision != null) {
                this._revisionValue.setText(this._statusData._commitRevision);
            }
            if (this._statusData._commitTime != null) {
                this._commitTimeValue.setText(this._statusData._commitTime);
            }
            if (this._statusData._message != null) {
                this._messageValue.setText(this._statusData._message);
            }
        }

        private class StatusData {
            private String _branch;
            private String _status;
            private Icon _statusIcon;
            private String _author;
            private String _commitAuthor;
            private String _commitTime;
            private String _commitRevision;
            private String _message;

            private StatusData() {
            }
        }

        private class AsynchronousValueWorker
        implements Runnable {
            private final URL _url;

            AsynchronousValueWorker(URL url) {
                this._url = url;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GitClient client = null;
                try {
                    client = GITClientAdaptor.getClient(this._url);
                    GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
                    File[] file = new File[]{new File(this._url.getPath())};
                    SearchCriteria search = new SearchCriteria();
                    search.setFiles(file);
                    search.setLimit(1);
                    search.setFollowRenames(true);
                    search.setIncludeMerges(true);
                    GitRevisionInfo[] info = client.log(search, (ProgressMonitor)monitor);
                    if (monitor.getError() == null) {
                        GITPropertiesPanelUI.this._statusData._author = info.length > 0 ? info[0].getAuthor().getName() : "";
                        GITPropertiesPanelUI.this._statusData._commitAuthor = info.length > 0 ? info[0].getCommitter().getName() : "";
                        GITPropertiesPanelUI.this._statusData._commitRevision = info.length > 0 ? info[0].getRevision() : "";
                        GITPropertiesPanelUI.this._statusData._commitTime = info.length > 0 ? new Date(info[0].getCommitTime()).toString() : "";
                        GITPropertiesPanelUI.this._statusData._message = info.length > 0 ? info[0].getFullMessage() : "";
                    } else {
                        GITProfile.getQualifiedLogger(GITPropertiesPanel.class.getName()).log(Level.WARNING, monitor.getError());
                    }
                    monitor.setOperation("branches");
                    Map branches = client.getBranches(false, (ProgressMonitor)monitor);
                    if (monitor.getError() == null && !branches.isEmpty()) {
                        String activeBranch = this.getActiveBranch(branches);
                        GITPropertiesPanelUI.this._statusData._branch = activeBranch;
                    }
                }
                catch (GitException e) {
                    GITProfile.getQualifiedLogger(GITPropertiesPanel.class.getName()).log(Level.WARNING, e.getMessage());
                    Assert.printStackTrace((Throwable)e);
                }
                finally {
                    GITPropertiesPanelUI.this.updateAsynchronousValueComponents();
                    GITPropertiesPanelUI.this.setAsynchronousValueComponentsEnabled(true);
                    if (client != null) {
                        client.release();
                    }
                }
            }

            private String getActiveBranch(Map<String, GitBranch> branches) {
                for (String name : branches.keySet()) {
                    GitBranch branch = branches.get(name);
                    if (!branch.isActive()) continue;
                    return branch.getName();
                }
                return null;
            }
        }
    }
}

