/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITIgnore {
    public Collection<String> getIgnorePatterns(URL ignore) throws GITProcessException {
        if (!URLFileSystem.exists((URL)ignore)) {
            return Collections.emptyList();
        }
        ArrayList<String> patterns = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)ignore)));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                patterns.add(line);
            }
        }
        catch (IOException io) {
            throw new GITProcessException(Resource.get("ERROR_IGNORE_READ"), io);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return patterns;
    }

    public void addPattern(URL ignore, String pattern, Collection<String> existPatterns) throws GITProcessException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)ignore)));
            for (String pat : existPatterns) {
                if (pat.isEmpty()) continue;
                writer.write(pat);
                writer.newLine();
            }
            writer.write(pattern);
        }
        catch (IOException io) {
            throw new GITProcessException(Resource.get("ERROR_IGNORE_CAN_WRITE"), io);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void removePattern(URL ignore, String rmPattern, Collection<String> existPatterns) throws GITProcessException {
        existPatterns.remove(rmPattern);
        this.writePatterns(ignore, existPatterns);
    }

    public void writePatterns(URL ignore, Collection<String> existPatterns) throws GITProcessException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)ignore)));
            for (String pat : existPatterns) {
                writer.write(pat);
                writer.newLine();
            }
        }
        catch (IOException io) {
            throw new GITProcessException(Resource.get("ERROR_IGNORE_CAN_WRITE"), io);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

