/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.xmlComponent;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.base.inspector.editors.BooleanEditor;
import oracle.bali.xml.gui.base.xmlComponent.AbstractXmlPropertyEditorDecorator;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;

public class XmlCheckBoxEditor
extends AbstractXmlPropertyEditorDecorator<Boolean> {
    private boolean _xmlComponentFlag = false;
    private JToggleButton _jToggleButton;
    private boolean _showLabel = true;
    private boolean _renderAsRadioButton = false;

    public XmlCheckBoxEditor() {
        super((PropertyEditor)new BooleanEditor());
    }

    public Component getXmlComponent() {
        this.setXmlComponentFlag(true);
        boolean addItemListener = false;
        if (this._jToggleButton == null) {
            this._jToggleButton = this.getRenderAsRadioButton() ? new JRadioButton() : new JCheckBox();
            if (this.showLabel()) {
                String labelText = this.getXmlComponentWrapper().getXmlComponentModel().getShortDisplayName();
                this._jToggleButton.setText(StringUtils.stripMnemonic((String)labelText));
                this._jToggleButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)labelText));
            }
            if (this.getXmlComponentWrapper().addFocusTracker()) {
                addItemListener = true;
            }
        }
        this.updateXmlComponentFromPropertyValue();
        this.setXmlComponentFlag(false);
        if (addItemListener) {
            this._jToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (!XmlCheckBoxEditor.this.getXmlComponentFlag()) {
                        XmlCheckBoxEditor.this.handleItemStateChanged(itemEvent);
                    }
                }
            });
        }
        return this._jToggleButton;
    }

    public boolean showLabel() {
        return this._showLabel;
    }

    public XmlCheckBoxEditor setShowLabel(boolean showLabel) {
        this._showLabel = showLabel;
        return this;
    }

    public boolean getRenderAsRadioButton() {
        return this._renderAsRadioButton;
    }

    public XmlCheckBoxEditor setRenderAsRadioButton(boolean renderAsRadioButton) {
        this._renderAsRadioButton = renderAsRadioButton;
        return this;
    }

    public void updateXmlComponentFromPropertyValue() {
        if ("true".equals(this.getAsText())) {
            this._jToggleButton.setSelected(true);
        } else {
            this._jToggleButton.setSelected(false);
        }
    }

    public void updatePropertyValueFromXmlComponent() {
        this.setValue(this._jToggleButton.isSelected() ? "true" : "false");
    }

    public XmlComponentLayoutOption getXmlComponentLayoutOption() {
        XmlLayoutOption layoutOption = new XmlLayoutOption().setAddLabel(false).setGrowRow(false).setPushRow(false);
        layoutOption.getComponentConstraint().spanX().growX(0.0f);
        return layoutOption;
    }

    public void dispose() {
        this._jToggleButton = null;
    }

    public boolean getXmlComponentFlag() {
        return this._xmlComponentFlag;
    }

    public void setXmlComponentFlag(boolean xmlComponentFlag) {
        this._xmlComponentFlag = xmlComponentFlag;
    }
}

