/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.util.PointToModelFinder;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.NoNameTransactionTask;
import oracle.bali.xml.model.task.NonDomMutationTransactionTask;
import org.w3c.dom.Node;

public abstract class SelectionChangingMouseListener
extends MouseInputAdapter {
    private MouseEvent _deferredSetEvent;
    private Node _anchor;
    private final XmlGui _gui;
    private final Component _component;
    private final PointToModelFinder _finder;

    public SelectionChangingMouseListener(XmlGui gui, Component component, PointToModelFinder finder) {
        this._gui = gui;
        this._component = component;
        this._finder = finder;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this._component.isEnabled() && !e.isConsumed()) {
            this._component.requestFocus();
            this._handleSelectionAndCursor(e, false);
            this._handlePopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this._component.isEnabled() && e.getClickCount() == 2 && !e.isConsumed()) {
            this.handleDoubleClick(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            if (this._component.isEnabled()) {
                this._handlePopup(e);
            }
            if (e.getClickCount() == 2) {
                this.handleDoubleClick(e);
            }
            if (!e.isPopupTrigger() && this._deferredSetEvent != null) {
                this._handleSelectionAndCursor(this._deferredSetEvent, true);
            }
        }
        this._deferredSetEvent = null;
    }

    protected void showPopup(MouseEvent e) {
    }

    protected void handleDoubleClick(final MouseEvent e) {
        if (!this._component.isEnabled() || !SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        new NoNameTransactionTask(){

            protected void performTask(AbstractModel model) {
                Node viewNode = SelectionChangingMouseListener.this._finder.getNodeAt(SelectionChangingMouseListener.this._component, e.getX(), e.getY());
                Selection selection = model.getSelection();
                boolean clickedNodeIsSelected = selection.contains(viewNode);
                if (clickedNodeIsSelected) {
                    if (e.getID() == 500) {
                        Action a = SelectionChangingMouseListener.this.getGui().getAction("customizeNode");
                        if (a != null) {
                            ActionEvent ae = new ActionEvent(viewNode, 1001, "customizeNode", e.getWhen(), e.getModifiers());
                            a.actionPerformed(ae);
                            if (a.isEnabled()) {
                                e.consume();
                            }
                        }
                    } else {
                        e.consume();
                    }
                }
            }
        }.run((AbstractModel)this._getView());
    }

    protected void handleSetSelection(Selection selection, Node viewNode, MouseEvent e) {
        selection.set(viewNode);
        this.setCursorLocation(viewNode, e);
    }

    protected void handleAddToSelection(Selection selection, Node viewNode, MouseEvent e) {
        selection.add(viewNode);
        this.setCursorLocation(viewNode, e);
    }

    protected void handleExtendSelection(Selection selection, Node viewNode, Node anchorNode, MouseEvent e) {
        this.handleAddToSelection(selection, viewNode, e);
    }

    protected void handleRemoveFromSelection(Selection selection, Node viewNode, MouseEvent e) {
        selection.remove(viewNode);
        DomPosition oldCursor = selection.getCursorLocation();
        if (oldCursor != null && oldCursor.getTargetNode() == viewNode && oldCursor.isInside()) {
            selection.setCursorLocation(null);
        }
        if (this._anchor == viewNode) {
            if (selection.isEmpty()) {
                this.setAnchorNode(null);
            } else {
                this.setAnchorNode(selection.getLatestSelectedNode());
            }
        }
    }

    public void setAnchorNode(Node anchorNode) {
        if (this._anchor != anchorNode) {
            this._anchor = anchorNode;
        }
    }

    public Node getAnchorNode() {
        return this._anchor;
    }

    protected final void setCursorLocation(Node viewNode, MouseEvent e) {
        DomPosition cursorLocation = this._finder.getClosestPosition(this._component, viewNode, e.getX(), e.getY());
        this._getView().getSelection().setCursorLocation(cursorLocation);
    }

    protected final XmlGui getGui() {
        return this._gui;
    }

    protected final Component getComponent() {
        return this._component;
    }

    protected final Node getNodeAt(int x, int y) {
        return this._finder.getNodeAt(this._component, x, y);
    }

    protected final DomPosition getClosestPosition(Node nearNode, int x, int y) {
        return this._finder.getClosestPosition(this._component, nearNode, x, y);
    }

    private void _handleSelectionAndCursor(final MouseEvent event, final boolean handlingDeferred) {
        SwingXmlContext context = (SwingXmlContext)this.getGui().getGuiContext();
        context.guiReceivedEventHook(this.getGui(), event);
        new NonDomMutationTransactionTask(){

            protected void performTask(AbstractModel model) throws XmlCommitException {
                SelectionChangingMouseListener.this._doSelectionUpdatesInsideTask(event, handlingDeferred);
            }

            protected boolean requiresTask(AbstractModel model) {
                return model.getDocument() != null;
            }
        }.run((AbstractModel)this._getView());
    }

    private void _doSelectionUpdatesInsideTask(MouseEvent event, boolean handlingDeferred) {
        boolean setAnchor;
        boolean addToSelection;
        XmlView view = this._getView();
        Node viewNode = this._finder.getNodeAt(this._component, event.getX(), event.getY());
        Selection selection = view.getSelection();
        if (!(this._anchor == null || this._anchor.getOwnerDocument() == view.getDocument() && selection.contains(this._anchor))) {
            this.setAnchorNode(null);
        }
        boolean clickedNodeIsSelected = viewNode != null && selection.contains(viewNode);
        boolean noModifiers = !event.isShiftDown() && !event.isControlDown();
        boolean setSelection = noModifiers && viewNode != null;
        boolean bl = addToSelection = !noModifiers && viewNode != null && (event.isShiftDown() || !clickedNodeIsSelected);
        boolean extendSelection = addToSelection && event.isShiftDown() & !event.isControlDown();
        boolean removeFromSelection = !noModifiers && viewNode != null && !addToSelection;
        boolean bl2 = setAnchor = this._anchor == null || setSelection || viewNode != null && event.isControlDown() && !event.isShiftDown();
        if (setAnchor) {
            this.setAnchorNode(viewNode);
        }
        if (!handlingDeferred && clickedNodeIsSelected && (setSelection && selection.size() > 1 || removeFromSelection)) {
            this._deferredSetEvent = event;
            return;
        }
        if (removeFromSelection) {
            this.handleRemoveFromSelection(selection, viewNode, event);
        } else if (extendSelection) {
            this.handleExtendSelection(selection, viewNode, this._anchor, event);
        } else if (addToSelection) {
            this.handleAddToSelection(selection, viewNode, event);
        } else if (setSelection) {
            this.handleSetSelection(selection, viewNode, event);
        }
    }

    private void _handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
            e.consume();
        }
    }

    private XmlView _getView() {
        return this._gui.getView();
    }
}

