/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public class RecursiveDropTargetSetter
implements ContainerListener {
    private final DropTarget _target;

    public static void setDropTarget(DropTarget target, Container container) {
        RecursiveDropTargetSetter r = new RecursiveDropTargetSetter(target, container);
        r._addContainer(container);
    }

    private RecursiveDropTargetSetter(DropTarget target, Container initialContainer) {
        this._target = target;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this._addComponent(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this._removeComponent(e.getChild());
    }

    private void _addComponent(Component c) {
        c.setDropTarget(this._target);
        if (c instanceof Container) {
            this._addContainer((Container)c);
        }
    }

    private void _addContainer(Container c) {
        c.addContainerListener(this);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this._addComponent(c.getComponent(i));
        }
    }

    private void _removeComponent(Component c) {
        c.setDropTarget(null);
        if (c instanceof Container) {
            this._removeContainer((Container)c);
        }
    }

    private void _removeContainer(Container c) {
        c.removeContainerListener(this);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this._removeComponent(c.getComponent(i));
        }
    }
}

