/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.palette.BasePaletteGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.palette.SwingPaletteDragListener;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;

public class SwingPaletteGui
extends BasePaletteGui
implements ComponentXmlGui {
    private Listener _listener = new Listener();
    private JPanel _preferredPage;
    private Component _component;
    private static final String _XML_KEY = "oracle.bali.xml.gui.swing.SwingPaletteGui.XML_KEY";

    public SwingPaletteGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        if (this._component == null) {
            this._component = this._createPaletteComponent();
            this._recursiveSetEnabled(this._component, this.getView().getBaseModel().isDocumentValid());
        }
        return this._component;
    }

    public Component[] createPalettePages(Grammar g) {
        Map map = this.getPalettePages(g);
        if (map == null) {
            return null;
        }
        ArrayList<JPanel> panels = new ArrayList<JPanel>(map.size());
        Set keys = map.keySet();
        for (String pageName : keys) {
            JPanel panel = this._createPalettePage(pageName, (List)map.get(pageName));
            panels.add(panel);
        }
        return panels.toArray(new Component[0]);
    }

    private Component _createPaletteComponent() {
        Collection grammars = this.getGuiContext().getGrammarProvider().getGrammars();
        if (grammars.isEmpty()) {
            return new JLabel(this.getTranslatedString("PALETTE.NO_PALETTE_PAGES"));
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        final JPanel pagePanel = new JPanel();
        final Layout layout = new Layout();
        pagePanel.setLayout(layout);
        for (Grammar g : grammars) {
            Component[] pages = this.createPalettePages(g);
            int pageCount = pages == null ? 0 : pages.length;
            for (int j = 0; j < pageCount; ++j) {
                Component page = pages[j];
                pagePanel.add(page.getName(), new JScrollPane(page));
                model.addElement(page.getName());
            }
        }
        String preferredPageTitle = this.getTranslatedString("PALETTE.PREFERRED_PAGE_TITLE");
        this._preferredPage = this._createPalettePage(preferredPageTitle, Collections.EMPTY_LIST);
        pagePanel.add(preferredPageTitle, new JScrollPane(this._preferredPage));
        model.addElement(preferredPageTitle);
        final JPanel palettePanel = new JPanel(new BorderLayout(5, 5));
        palettePanel.add("Center", new JScrollPane(pagePanel));
        JComboBox box = new JComboBox(model);
        box.setSelectedIndex(-1);
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    layout.show((String)e.getItem());
                    pagePanel.revalidate();
                    palettePanel.revalidate();
                }
            }
        });
        palettePanel.add("North", box);
        DragListener dragListener = new DragListener((Component)palettePanel);
        if (box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return palettePanel;
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        if (event.isPropertyChanged()) {
            PropertyChange validityChange;
            PropertyChange cursorChange = event.getCursorLocationPropertyChange();
            if (cursorChange != null) {
                this._updateContextSensitivePages((DomPosition)cursorChange.getNewValue());
            }
            if (this.getView().requiresValidModel() && (validityChange = event.getDomDocumentValidPropertyChange()) != null && this._component != null) {
                this._recursiveSetEnabled(this._component, validityChange.getNewBooleanValue());
            }
        }
        super.handleModelChangeEvent(event);
    }

    private void _recursiveSetEnabled(Component c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Container) {
            Container parent = (Container)c;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                this._recursiveSetEnabled(parent.getComponent(i), enabled);
            }
        }
    }

    private void _updateContextSensitivePages(DomPosition newPosition) {
        if (this._preferredPage != null) {
            this._preferredPage.removeAll();
            if (newPosition != null) {
                Collection creatableKeys;
                XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
                Collection preferredXmlKeys = resolver.getCreatablePreferredXmlKeys(newPosition);
                if (preferredXmlKeys.isEmpty() && (creatableKeys = resolver.getCreateableChildrenXmlKeys(newPosition)).size() <= 10) {
                    preferredXmlKeys = creatableKeys;
                }
                this._addItemsToPage(this._preferredPage, preferredXmlKeys);
            }
            this._preferredPage.revalidate();
        }
    }

    private JPanel _createPalettePage(String pageName, List items) {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setName(pageName);
        this._addItemsToPage(panel, items);
        return panel;
    }

    private void _addItemsToPage(JPanel panel, Collection items) {
        XmlMetadataResolver resolver = this.getView().getXmlMetadataResolver();
        for (XmlKey paletteItemKey : items) {
            String name = resolver.getShortDisplayName(paletteItemKey);
            Icon icon = resolver.getSmallIcon(paletteItemKey);
            String desc = resolver.getShortDescription(paletteItemKey);
            JButton button = new JButton(name, icon){

                @Override
                public JToolTip createToolTip() {
                    return new MultiLineToolTip();
                }
            };
            button.setFocusable(false);
            button.setDefaultCapable(false);
            button.setHorizontalAlignment(10);
            button.setMargin(new Insets(0, 2, 0, 2));
            button.setToolTipText(desc);
            button.putClientProperty(_XML_KEY, paletteItemKey);
            button.addActionListener(this._listener);
            panel.add(button);
        }
    }

    private class Layout
    implements LayoutManager {
        private HashMap _children = new HashMap();
        private Component _currentChild = null;

        public void show(String name) {
            if (this._currentChild != null) {
                this._currentChild.setVisible(false);
            }
            this._currentChild = (Component)this._children.get(name);
            if (this._currentChild != null) {
                this._currentChild.setVisible(true);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this._children.put(name, comp);
            comp.setVisible(false);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            String name = comp.getName();
            if (this._children.get(name) == comp) {
                this._children.remove(name);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (this._currentChild == null) {
                return new Dimension(0, 0);
            }
            return this._currentChild.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            if (this._currentChild == null) {
                return new Dimension(0, 0);
            }
            return this._currentChild.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            if (this._currentChild != null) {
                Insets i = parent.getInsets();
                if (i == null) {
                    i = new Insets(0, 0, 0, 0);
                }
                Dimension d = parent.getSize();
                this._currentChild.setBounds(i.left, i.top, d.width - (i.left + i.right), d.height - (i.top + i.bottom));
            }
        }
    }

    private class DragListener
    extends SwingPaletteDragListener {
        DragListener(Component c) {
            super((XmlGui)SwingPaletteGui.this, c);
        }

        @Override
        protected boolean isDragPossible(MouseEvent e) {
            if (SwingPaletteGui.this.isUserEditable() && e.getComponent() instanceof JComponent) {
                JComponent c = (JComponent)e.getComponent();
                return c.getClientProperty(SwingPaletteGui._XML_KEY) != null;
            }
            return false;
        }

        @Override
        protected XmlKey getXmlKey(DragGestureEvent e) {
            if (e.getComponent() instanceof JComponent) {
                JComponent c = (JComponent)e.getComponent();
                return (XmlKey)c.getClientProperty(SwingPaletteGui._XML_KEY);
            }
            return null;
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JButton b = (JButton)event.getSource();
            XmlKey itemKey = (XmlKey)b.getClientProperty(SwingPaletteGui._XML_KEY);
            XmlView view = SwingPaletteGui.this.getGuiContext().getActiveGui().getView();
            if (view == null) {
                SwingPaletteGui.this.getGuiContext().showErrorMessage(SwingPaletteGui.this.getTranslatedString("PALETTE.NO_ACTIVE_VIEW_ERROR_MESSAGE"));
            } else {
                DomPosition pos = view.getSelection().getCursorLocation();
                if (pos == null) {
                    SwingPaletteGui.this.getGuiContext().showErrorMessage(SwingPaletteGui.this.getTranslatedString("PALETTE.NO_CURSOR_ERROR_MESSAGE"));
                } else if (view.getBaseModel().isDocumentValid()) {
                    try {
                        view.insertXmlKey(itemKey, pos);
                    }
                    catch (XmlCommitException e) {
                        SwingPaletteGui.this.getLogger().log(Level.SEVERE, "Couldn't insert because of validation error " + e.getMessage(), e);
                    }
                }
            }
        }
    }
}

