/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editorFactories;

import java.awt.Color;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.inspector.editor.PropertyValueApplier;

public class DateFieldEditor
extends DateEditor {
    private boolean _dirty;
    private PropertyValueApplier _propertyValueApplier;
    private final DateFormat _returnDateFormat;

    public DateFieldEditor(String datePattern, DateFormat displayDateFormat) {
        this.setDateFormat(displayDateFormat);
        this.setDate(null);
        Border b = BorderFactory.createLineBorder(Color.GRAY);
        this.setBorder(b);
        this._returnDateFormat = new SimpleDateFormat(datePattern);
    }

    public String getText() {
        Date date = this.getDate();
        return this._returnDateFormat.format(date);
    }

    public void setText(String t) {
        Date parsedDate = null;
        try {
            parsedDate = this._returnDateFormat.parse(t);
        }
        catch (ParseException e) {
            parsedDate = null;
        }
        if (parsedDate != null) {
            this.setDate(parsedDate);
        }
    }

    public void setPropertyValueApplier(PropertyValueApplier newpropertyValueApplier) {
        this._propertyValueApplier = newpropertyValueApplier;
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this._propertyValueApplier;
    }

    public final void setDirty(boolean newdirty) {
        this._dirty = newdirty;
    }

    public final boolean isDirty() {
        return this._dirty;
    }
}

