/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.xml.gui.swing.explorer.SwingListGui;
import oracle.bali.xml.model.XmlView;
import org.w3c.dom.Node;

class XmlListCellRenderer
implements ListCellRenderer {
    private final SwingListGui _gui;
    private final ListCellRenderer _delegate;
    private static final Color _HIGHLIGHT_COLOR = new Color(220, 220, 220);

    XmlListCellRenderer(SwingListGui gui, ListCellRenderer delegate) {
        this._gui = gui;
        this._delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Icon icon = null;
        String tooltip = null;
        String text = null;
        boolean highlight = false;
        if (value instanceof Node) {
            XmlView view = this._gui.getView();
            view.acquireReadLock();
            try {
                Node node = (Node)value;
                icon = view.getXmlMetadataResolver().getSmallIcon(node);
                text = view.getXmlMetadataResolver().getMediumDisplayName(node);
                tooltip = view.getXmlMetadataResolver().getLongDisplayName(node);
                highlight = this._gui.__isNodeHighlighted(node);
            }
            finally {
                view.releaseReadLock();
            }
        } else if (value != null) {
            text = value.toString();
        }
        Component component = this._delegate.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        if (tooltip != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(tooltip);
        }
        if (component instanceof JLabel) {
            ((JLabel)component).setIcon(icon);
        }
        if (highlight && !isSelected) {
            component.setBackground(_HIGHLIGHT_COLOR);
            component.setForeground(list.getForeground());
        }
        return component;
    }
}

