/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListHelper;
import oracle.bali.xml.gui.swing.explorer.XmlJTree;
import org.w3c.dom.Node;

class TreeHelper
extends SwingTreeListHelper<SwingExplorerGui, JTree> {
    TreeHelper(SwingExplorerGui gui) {
        super(gui);
    }

    @Override
    protected int getRowIfVisible(JTree tree, Node node) {
        TreePath path = ((SwingExplorerGui)this.getGui()).getTreeModel().getPathForDomElement(node);
        if (tree.isVisible(path)) {
            return tree.getRowForPath(path);
        }
        return -1;
    }

    @Override
    protected Rectangle getBoundsIfVisible(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        if (path == null || !tree.isVisible(path)) {
            return null;
        }
        return tree.getPathBounds(path);
    }

    @Override
    protected Node getNodeAt(JTree tree, int x, int y) {
        XmlTreeModel model = ((SwingExplorerGui)this.getGui()).getTreeModel();
        return model.pathToSourceDom(tree.getPathForLocation(x, y));
    }

    @Override
    protected boolean allowAfterPosition(JTree tree, int x, int y) {
        return !tree.isExpanded(tree.getPathForLocation(x, y));
    }

    @Override
    protected Node getNodeForRow(JTree tree, int row) {
        TreePath path = tree.getPathForRow(row);
        return ((SwingExplorerGui)this.getGui()).getTreeModel().pathToSourceDom(path);
    }

    @Override
    protected int getRowCount(JTree tree) {
        return tree.getRowCount();
    }

    @Override
    protected void regularProcessMouseEvent(MouseEvent event) {
        ((XmlJTree)event.getComponent()).__regularProcessMouseEvent(event);
    }

    @Override
    protected void regularProcessMouseMotionEvent(MouseEvent event) {
        ((XmlJTree)event.getComponent()).__regularProcessMouseMotionEvent(event);
    }

    @Override
    protected int getRowAt(JTree component, int x, int y) {
        return component.getRowForLocation(x, y);
    }

    @Override
    protected boolean invokeDefaultAction(InputEvent e, int clickedRow) {
        JTree tree = (JTree)e.getComponent();
        return ((SwingExplorerGui)this.getGui()).invokeDefaultAction(e, tree.getPathForRow(clickedRow));
    }

    @Override
    protected void showPopupMenu(MouseEvent e, int clickedRow) {
        JTree tree = (JTree)e.getComponent();
        ((SwingExplorerGui)this.getGui()).showPopupMenu(e, tree.getPathForRow(clickedRow));
    }

    @Override
    protected int getLeadSelectionRow(JTree component) {
        return component.getLeadSelectionRow();
    }
}

