/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Heading
extends JPanel {
    private static final int GRADIENT_LIGHT_BIAS = 40;
    private static final int GRADIENT_DARK_BIAS = 20;
    private static final int _VINSETS = 1;
    private static final int _HINSETS = 3;
    private String _label;
    private boolean _subheading;
    private boolean _horizontal = true;

    public Heading() {
        this((String)null);
    }

    public Heading(String label) {
        this.setOpaque(false);
        this.setLabel(label);
    }

    public void setSubHeading(boolean sub) {
        if (this._subheading != sub) {
            this._subheading = sub;
            Font f = this.getFont();
            if (sub && f != null && f.isBold()) {
                int style = f.getStyle() ^ 1;
                this.setFont(f.deriveFont(style));
            } else if (!sub && f != null && !f.isBold()) {
                int style = f.getStyle() | 1;
                this.setFont(f.deriveFont(style));
            }
        }
    }

    public boolean isSubHeading() {
        return this._subheading;
    }

    public void setLabel(String label) {
        this._label = label;
        this.revalidate();
        this.repaint();
    }

    public String getLabel() {
        return this._label;
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this._horizontal = horizontal;
    }

    @Override
    public Dimension getPreferredSize() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fm = this.getFontMetrics(f);
            Dimension dim = new Dimension(fm.stringWidth(this.getLabel()) + 6, fm.getHeight() + 2);
            if (!this._horizontal) {
                int temp = dim.width;
                dim.width = dim.height;
                dim.height = temp;
            }
            return dim;
        }
        return new Dimension(0, 0);
    }

    @Override
    public void addNotify() {
        Font f;
        super.addNotify();
        if (!this.isSubHeading() && !(f = this.getFont()).isBold()) {
            f = f.deriveFont(1);
            this.setFont(f);
        }
    }

    @Override
    public void paintComponent(Graphics original) {
        int bottom;
        Graphics2D g;
        if (this._horizontal) {
            g = (Graphics2D)original;
        } else {
            g = (Graphics2D)original.create();
            AffineTransform af = g.getTransform();
            Dimension preferedDim = this.getPreferredSize();
            af.concatenate(AffineTransform.getTranslateInstance(this.getWidth(), 0.0));
            af.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
            af.toString();
            g.setTransform(af);
        }
        Insets i = this.getInsets();
        int left = i.left;
        int top = i.top;
        int right = this.isHorizontal() ? this.getWidth() : this.getHeight() - (i.left + i.right);
        int n = bottom = this.isHorizontal() ? this.getHeight() : this.getWidth() - (i.top + i.bottom);
        if (g instanceof Graphics2D) {
            GradientPaint gradient = new GradientPaint(left, top, Heading.getActiveTitleGradientLightColor(), left, bottom, Heading.getActiveTitleGradientDarkColor());
            g.setPaint(gradient);
            g.fill(new Rectangle(left, top, right, bottom));
        } else {
            Color old = g.getColor();
            g.setColor(Color.white);
            g.fillRect(left, top, right, bottom);
            g.setColor(old);
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        float offset = metrics.getDescent() + metrics.getAscent() + metrics.getLeading();
        int y = top + 1;
        int stringHeight = metrics.getHeight();
        if (stringHeight < bottom) {
            y += (bottom - 1 - stringHeight) / 2;
        }
        y = this.isHorizontal() ? (y += metrics.getAscent()) : (y += metrics.getAscent());
        int x = left + 3;
        g.setColor(Color.black);
        g.drawString(this.getLabel(), x, y);
    }

    private static Color getActiveTitleColor() {
        return UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    private static Color getActiveTitleGradientLightColor() {
        Color titleColor = Heading.getActiveTitleColor();
        return Heading.getGradientLightColor(titleColor);
    }

    private static Color getActiveTitleGradientDarkColor() {
        Color titleColor = Heading.getActiveTitleColor();
        Color lightColor = Heading.getActiveTitleGradientLightColor();
        return Heading.getGradientDarkColor(titleColor, lightColor);
    }

    private static Color getGradientLightColor(Color baseColor) {
        int bias = 40;
        int r = baseColor.getRed();
        int g = baseColor.getGreen();
        int b = baseColor.getBlue();
        int min = Math.min(r, Math.min(g, b));
        int min2 = Math.min(min + 40, 255);
        if (r + 40 < 256) {
            min2 = r + 40;
            min = Math.max(min, r);
        }
        if (g + 40 < 256) {
            min2 = Math.max(min2, g + 40);
            min = Math.max(min, g);
        }
        if (b + 40 < 256) {
            min2 = Math.max(min2, b + 40);
            min = Math.max(min, b);
        }
        float factor = (float)min2 / (float)min / 255.0f;
        return new Color(Math.min((float)r * factor, 1.0f), Math.min((float)g * factor, 1.0f), Math.min((float)b * factor, 1.0f));
    }

    private static Color getGradientDarkColor(Color baseColor, Color lightColor) {
        float factor = 0.5f;
        int r = baseColor.getRed();
        int g = baseColor.getGreen();
        int b = baseColor.getBlue();
        int rNew = r - (int)(0.5f * (float)(lightColor.getRed() - r));
        int gNew = g - (int)(0.5f * (float)(lightColor.getGreen() - g));
        int bNew = b - (int)(0.5f * (float)(lightColor.getBlue() - b));
        return new Color(Math.max(rNew, 0), Math.max(gNew, 0), Math.max(bNew, 0));
    }
}

