/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.bali.xml.gui.swing.binding.DatabindingComponentWrapper;

public class TextFieldComponentWrapper
extends DatabindingComponentWrapper {
    public TextFieldComponentWrapper(JTextField field) {
        super(field);
        Listener listener = new Listener();
        field.getDocument().addDocumentListener(listener);
        field.addPropertyChangeListener(listener);
    }

    public JTextField getTextField() {
        return (JTextField)this.getWrappedComponent();
    }

    @Override
    protected final Object getValue() {
        return this.getTextField().getText();
    }

    @Override
    public final void setValue(Object value) {
        String text = value == null ? null : value.toString();
        this.getTextField().setText(text);
        this.valueChanged();
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextFieldComponentWrapper.this.valueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextFieldComponentWrapper.this.valueChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextFieldComponentWrapper.this.valueChanged();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("document".equals(e.getPropertyName())) {
                Document d2;
                Document d = (Document)e.getOldValue();
                if (d != null) {
                    d.removeDocumentListener(this);
                }
                if ((d2 = (Document)e.getNewValue()) != null) {
                    d2.addDocumentListener(this);
                }
            }
        }
    }
}

