/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.binding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;
import oracle.bali.xml.gui.base.inspector.editors.InspectorPropertyEditorSupport;
import oracle.bali.xml.gui.swing.binding.SwingDatabindingEditorGui;
import oracle.bali.xml.gui.swing.inspector.editorFactories.DataboundFieldEditorConfig;
import oracle.bali.xml.gui.swing.inspector.editorFactories.DataboundFieldEditorFactory;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import org.w3c.dom.Node;

public class DataboundPropertyEditor
extends InspectorPropertyEditorSupport
implements PropertyEditorFactory {
    private PropertyEditor _propertyEditor;
    private static final String _DESC_NBYE = "DATABINDING.NOBINDEXPRESSION";
    private static final String _DATA = "DATABINDING.DATA";
    private static final String _EXPRESSION = "DATABINDING.EXPRESSION";
    private static final String _NO_DATA = "DATABINDING.NODATA";
    private Component _expression;
    private Component _editor;
    private XmlContext _context;
    private XmlKey _nodeKey;
    private Node _parentNode;
    private XmlKey _parentKey;
    private Node _node;
    private Node _nearestAncestor;
    private Node _targetNode;
    private String _lastValue;
    private SwingDatabindingEditorGui _gui;
    private TableCellEditor _cellEditor;

    public DataboundPropertyEditor() {
        this._propertyEditor = PropertyEditorManager.findEditor(String.class);
    }

    protected DataboundPropertyEditor(PropertyEditor toProxy) {
        if (toProxy == null) {
            throw new IllegalArgumentException("propertyEditor is null!");
        }
        this._propertyEditor = toProxy;
    }

    public void clearContext() {
        this._setContext(null, null, null, null, null, null, null);
    }

    public void setContext(PropertyEditorContext context) {
        this._setContext(context.getXmlContext(), context.getKey(), context.getNode(), context.getOwnerNode(), context.getOwnerKey(), context.getNearestAncestor(), context.getTargetNode());
    }

    private void _setContext(XmlContext context, XmlKey key, Node node, Node ownerNode, XmlKey ownerKey, Node nearestAncestor, Node targetNode) {
        this._context = context;
        this._nodeKey = key;
        this._node = node;
        this._parentNode = ownerNode;
        this._nearestAncestor = nearestAncestor;
        this._targetNode = targetNode;
        this._parentKey = ownerKey;
        this._gui = null;
        if (this._context != null) {
            XmlGui gui = ((GuiXmlContext)context).getGui(XmlUsage.DATABINDING_PROPERTY_EDITOR);
            this._gui = (SwingDatabindingEditorGui)gui;
            this._cellEditor = null;
            XmlMetadataResolver resolver = context.getModel().getXmlMetadataResolver();
            if (!resolver.getSupportsDatabinding(key)) {
                throw new IllegalArgumentException(key + " doesn't support databinding");
            }
        }
    }

    public void setValue(Object o) {
        this._setValue(o);
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        if (this._editor == null) {
            this._createEditor();
        }
        if (this._editor != null) {
            Object o = this.getValue();
            String s = o == null ? "" : o.toString();
            this._setExpression(s);
        }
        return this._editor;
    }

    private void _setExpression(String expression) {
        if (this._gui != null) {
            this._gui.setExpression(this._expression, expression);
        }
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object value) {
        this.setValue(value);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        return DisplayValueRenderer.getTableCellRenderer();
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._cellEditor == null) {
            if (this._gui == null) {
                JTextField field = new JTextField();
                field.setLocale(editorLocale);
                this._cellEditor = new DefaultCellEditor(field);
            } else {
                this._cellEditor = this._gui.createInPlaceEditor(editorLocale, this._context, this._nodeKey, this._node, this._parentNode, this._parentKey, this._nearestAncestor, this._targetNode);
            }
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return false;
    }

    public Component getTearOffEditor() {
        return null;
    }

    public boolean hasAdvancedEditor() {
        return true;
    }

    public Component getAdvancedEditor() {
        return this.getCustomEditor();
    }

    public EditorComponentInfo getEditorComponentInfo() {
        if (DataboundPropertyEditor.getFieldEditorFactory() == null) {
            return null;
        }
        DataboundFieldEditorConfig dfec = DataboundFieldEditorConfig.createDataboundFieldEditorConfig(this._gui, this._context, this._nodeKey, this._node, this._parentNode);
        return EditorUtils.createEditorComponentInfo((String)MappedEditorFactoryInfo.COMPONENT_CONFIG_INFO, (Object)dfec);
    }

    private String _getTranslatedString(String key) {
        return this._context == null ? "Key not Found" : this._context.getModel().getTranslatedString(key);
    }

    private void _setValue(Object o) {
        if (this._expression != null) {
            String s = o == null ? "" : o.toString();
            this._setExpression(s);
        }
        this.getEditor().setValue(o);
    }

    void __setValue(Object o) {
        this.getEditor().setValue(o);
        this._lastValue = null;
    }

    private void _createEditor() {
        JTree tree;
        if (this._context == null || this._gui == null) {
            return;
        }
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        String desc = this._getTranslatedString(_DESC_NBYE);
        MultiLineLabel mll = new MultiLineLabel(WordWrapper.getTextWrapper(), desc);
        mll.setPreferredAspectRatio(0.0f);
        mll.setPreferredColumns(50);
        mainPanel.add("North", (Component)mll);
        Box panel = Box.createVerticalBox();
        mainPanel.add("Center", panel);
        Box databindingPanel = Box.createVerticalBox();
        panel.add(databindingPanel);
        String dataLabelText = this._getTranslatedString(_DATA);
        JLabel dataLabel = new JLabel(StringUtils.stripMnemonic((String)dataLabelText));
        dataLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)dataLabelText));
        databindingPanel.add(this._createWest(dataLabel));
        databindingPanel.add(Box.createVerticalStrut(2));
        JTree jTree = tree = this._gui == null ? new JTree() : this._gui.createJTree(this._context, this._nodeKey, this._node, this._parentNode);
        if (tree.getModel().getRoot() == null || tree.getModel().getChildCount(tree.getModel().getRoot()) == 0) {
            JList<Object> list = new JList<Object>(new Object[]{this._getTranslatedString(_NO_DATA)});
            dataLabel.setLabelFor(list);
            list.setVisibleRowCount(10);
            JScrollPane listScrollPane = new JScrollPane(list);
            list.setEnabled(false);
            listScrollPane.setEnabled(false);
            databindingPanel.add(listScrollPane);
        } else {
            dataLabel.setLabelFor(tree);
            tree.setVisibleRowCount(10);
            JScrollPane treeScrollPane = new JScrollPane(tree);
            JPanel treePanel = new JPanel(new BorderLayout(3, 3));
            treePanel.add("Center", treeScrollPane);
            DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
            treeSelectionModel.setSelectionMode(1);
            tree.setSelectionModel(treeSelectionModel);
            treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getPath();
                    DataboundPropertyEditor.this._convertPathToExpression(path);
                }
            });
            databindingPanel.add(treePanel);
        }
        databindingPanel.add(Box.createVerticalStrut(5));
        int columns = 35;
        String expressionLabelText = this._getTranslatedString(_EXPRESSION);
        JLabel expressionLabel = new JLabel(StringUtils.stripMnemonic((String)expressionLabelText));
        expressionLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)expressionLabelText));
        databindingPanel.add(this._createWest(expressionLabel));
        databindingPanel.add(Box.createVerticalStrut(2));
        Component expression = this._gui.createExpressionComponent(this, 35, this._context, this._nodeKey, this._node, this._parentNode, this._parentKey, this._nearestAncestor, this._targetNode);
        databindingPanel.add(expression);
        databindingPanel.add(Box.createVerticalStrut(5));
        expressionLabel.setLabelFor(expression);
        this._editor = mainPanel;
        this._expression = expression;
    }

    public void expressionChanged(String newExpression) {
        this.__setValue(newExpression);
    }

    public void expressionComponentLostFocus(String newExpression) {
    }

    private Component _createWest(Component c) {
        JPanel p = new JPanel(new BorderLayout());
        p.add("West", c);
        return p;
    }

    private void _convertPathToExpression(TreePath path) {
        if (path == null) {
            return;
        }
        String bindingString = this._gui == null ? null : this._gui.getBindingString(this._context, this._nodeKey, this._node, this._parentNode, path);
        this._setValue(bindingString);
    }

    public Object getValue() {
        return this.getEditor().getValue();
    }

    public boolean isPaintable() {
        return this.getEditor().isPaintable();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        this.getEditor().paintValue(gfx, box);
    }

    public String getJavaInitializationString() {
        return this.getEditor().getJavaInitializationString();
    }

    public String getAsText() {
        return this.getEditor().getAsText();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.getEditor().setAsText(text);
    }

    public String[] getTags() {
        return this.getEditor().getTags();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getEditor().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getEditor().removePropertyChangeListener(listener);
    }

    public PropertyEditor getEditor() {
        return this._propertyEditor;
    }

    public static DataboundFieldEditorFactory getFieldEditorFactory() {
        return DataboundFieldEditorFactorySingleton.instance;
    }

    private static class DataboundFieldEditorFactorySingleton {
        private static final DataboundFieldEditorFactory instance = new DataboundFieldEditorFactory();

        private DataboundFieldEditorFactorySingleton() {
        }
    }
}

