/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.xml.gui.base.BaseStatusBarGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;

public class SwingStatusBarGui
extends BaseStatusBarGui
implements ComponentXmlGui {
    private boolean _showNormalStatus = true;
    private boolean _initComponents = true;
    private JLabel _errorCell;
    private JLabel _feedbackCell;
    private JLabel _selectionCell;
    private JPanel _panel;
    private StatusBar _statusBar;
    private StatusBar _errorBar;

    public SwingStatusBarGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new JPanel(new BorderLayout());
            this._initComponents();
            this._createPanel(null);
            new SwingWorker<String, Void>(){
                private String _feedbackText;
                private String _selectionText;

                @Override
                public String doInBackground() {
                    this._feedbackText = SwingStatusBarGui.this.getFeedbackText(false);
                    this._selectionText = SwingStatusBarGui.this.getSelectionText(false);
                    return "done";
                }

                @Override
                public void done() {
                    SwingStatusBarGui.this._selectionCell.setText(this._selectionText);
                    SwingStatusBarGui.this._feedbackCell.setText(this._feedbackText);
                    SwingStatusBarGui.this._errorCell.setText(this._feedbackText);
                }
            }.execute();
        }
        return this._panel;
    }

    protected void updateSelectionText(boolean remapSelection) {
        this.getSelectionCell().setText(this.getSelectionText(remapSelection));
    }

    protected void updateFeedbackText(boolean remapSelection) {
        String txt = this.getFeedbackText(remapSelection);
        this.getFeedbackCell().setText(txt);
        this._errorCell.setText(txt);
    }

    protected void updateInsertionPositionText() {
        this.getFeedbackCell().setText(this.getInsertionPositionText());
    }

    protected JLabel getFeedbackCell() {
        this._initComponents();
        return this._feedbackCell;
    }

    protected JLabel getSelectionCell() {
        this._initComponents();
        return this._selectionCell;
    }

    private void _createPanel(Font font) {
        this._selectionCell.setMinimumSize(new Dimension(400, 10));
        this._selectionCell.setHorizontalAlignment(2);
        this._feedbackCell.setMinimumSize(new Dimension(400, 10));
        if (font != null) {
            this._feedbackCell.setFont(font);
            this._selectionCell.setFont(font);
        }
        this._statusBar.add((Component)this._feedbackCell);
        this._statusBar.add((Component)this._selectionCell);
        this._errorBar.add((Component)this._errorCell);
        this._showNormalStatus = this.getView().getBaseModel().isDocumentValid();
        this._restoreComponents();
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
        boolean isValid;
        PropertyChange validityChange;
        if (event.isPropertyChanged() && (validityChange = event.getDomDocumentValidPropertyChange()) != null && (isValid = validityChange.getNewBooleanValue()) != this._showNormalStatus) {
            this._showNormalStatus = isValid;
            this._restoreComponents();
        }
        super.handleModelChangeEvent(event);
    }

    private void _restoreComponents() {
        this.getComponent();
        this._panel.removeAll();
        if (this._showNormalStatus) {
            this._panel.add((Component)this._statusBar, "Center");
        } else {
            this._panel.add((Component)this._errorBar, "Center");
        }
        this._panel.revalidate();
    }

    private void _initComponents() {
        if (this._initComponents) {
            this._initComponents = false;
            this._errorCell = new JLabel();
            this._feedbackCell = new JLabel();
            this._selectionCell = new JLabel();
            this._statusBar = new StatusBar(2);
            this._errorBar = new StatusBar(1);
        }
    }
}

