/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.demo;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.bali.xml.gui.demo.VisualEditorUI;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.preference.PreferencePanel;

public class VisualEditor {
    public static final String FILE = "file";
    public static final String HTML_ROOT = "htmlRoot";
    public static final String LIB_PATH = "libPath";
    public static final String LOCALE = "locale";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private static final String _FILE_ARGUMENT = "-file=";
    private static final String _HTML_ROOT_ARGUMENT = "-htmlRoot=";
    private static final String _LIB_PATH_ARGUMENT = "-libPath=";
    private static final String _LOCALE_ARGUMENT = "-locale=";
    private static final String _WIDTH_ARGUMENT = "-width=";
    private static final String _HEIGHT_ARGUMENT = "-height=";
    private static final String _HELP_ARGUMENT1 = "-help";
    private static final String _HELP_ARGUMENT2 = "?";
    private static final String _METADATA_SCHEMA_LOCATION = "oracle/bali/xml/metadata/XmlMetadata.xsd";
    private File _file;
    private File _htmlRoot;
    private File _libPath;
    private Locale _locale;
    private int _width;
    private int _height;

    public static void main(String[] paramArray) {
        VisualEditor.finishMain(paramArray, VisualEditor.class);
    }

    public VisualEditor(Map params) {
        this._file = (File)params.get(FILE);
        this._htmlRoot = (File)params.get(HTML_ROOT);
        this._libPath = (File)params.get(LIB_PATH);
        this._locale = (Locale)params.get(LOCALE);
        this._width = ((Number)params.get(WIDTH)).intValue();
        this._height = ((Number)params.get(HEIGHT)).intValue();
    }

    public static Map parseParams(String[] params) {
        if (params == null || params.length == 0) {
            VisualEditor._printHelp();
        }
        File file = null;
        File htmlRoot = null;
        File libPath = null;
        Locale locale = Locale.getDefault();
        Integer width = new Integer(1024);
        Integer height = new Integer(768);
        for (int i = 0; i < params.length; ++i) {
            String curr = params[i];
            String paramValue = null;
            if (curr.startsWith(_FILE_ARGUMENT)) {
                paramValue = curr.substring(_FILE_ARGUMENT.length());
                file = VisualEditor._createRequiredParameterFile(FILE, paramValue);
                continue;
            }
            if (curr.startsWith(_HTML_ROOT_ARGUMENT)) {
                paramValue = curr.substring(_HTML_ROOT_ARGUMENT.length());
                if (paramValue.charAt(paramValue.length() - 1) != File.separatorChar) {
                    paramValue = paramValue + File.separatorChar;
                }
                htmlRoot = VisualEditor._createRequiredParameterFile(HTML_ROOT, paramValue);
                continue;
            }
            if (curr.startsWith(_LIB_PATH_ARGUMENT)) {
                paramValue = curr.substring(_LIB_PATH_ARGUMENT.length());
                if (paramValue.charAt(paramValue.length() - 1) != File.separatorChar) {
                    paramValue = paramValue + File.separatorChar;
                }
                libPath = VisualEditor._createRequiredParameterFile(LIB_PATH, paramValue);
                continue;
            }
            if (curr.startsWith(_LOCALE_ARGUMENT)) {
                paramValue = curr.substring(_LOCALE_ARGUMENT.length());
                locale = LocaleUtils.getLocaleForIANAString((String)paramValue);
                continue;
            }
            if (curr.startsWith(_WIDTH_ARGUMENT)) {
                paramValue = curr.substring(_WIDTH_ARGUMENT.length());
                try {
                    width = Integer.valueOf(paramValue);
                }
                catch (NumberFormatException e) {
                    System.err.println("Unable to convert value:" + paramValue + " for " + WIDTH + " parameter, to an integer");
                }
                continue;
            }
            if (curr.startsWith(_HEIGHT_ARGUMENT)) {
                paramValue = curr.substring(_HEIGHT_ARGUMENT.length());
                try {
                    height = Integer.valueOf(paramValue);
                }
                catch (NumberFormatException e) {
                    System.err.println("Unable to convert value:" + paramValue + " for " + HEIGHT + " parameter, to an integer");
                }
                continue;
            }
            if (curr.startsWith(_HELP_ARGUMENT1) || curr.startsWith(_HELP_ARGUMENT2)) {
                VisualEditor._printHelp();
                continue;
            }
            System.err.println("Unknown parameter " + curr);
        }
        HashMap<String, Serializable> paramDict = new HashMap<String, Serializable>(31);
        paramDict.put(FILE, file);
        paramDict.put(HTML_ROOT, htmlRoot);
        paramDict.put(LIB_PATH, libPath);
        paramDict.put(LOCALE, locale);
        paramDict.put(WIDTH, width);
        paramDict.put(HEIGHT, height);
        return paramDict;
    }

    public PreferencePanel createPreferencePanel() {
        return null;
    }

    protected static void finishMain(String[] paramArray, Class editorClass) {
        Map params = VisualEditor.parseParams(paramArray);
        try {
            Constructor constructor = editorClass.getConstructor(Map.class);
            VisualEditor instance = (VisualEditor)constructor.newInstance(params);
            instance._run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected XmlModel createXmlModel(DemoXmlContext context, MetadataProvider provider) {
        return new XmlModel(provider);
    }

    protected XmlViewFactory createViewFactory() {
        return new XmlViewFactory();
    }

    protected XmlGuiFactory[] createExtraGuiFactories() {
        return null;
    }

    protected String getApplicationName() {
        return null;
    }

    protected XmlUsage[] getAdditionalUsages() {
        return null;
    }

    protected final void createVisualEditorUI(File file, Locale locale, int width, int height) {
        VisualEditorUI ui = new VisualEditorUI(this, this.createViewFactory(), this.createExtraGuiFactories(), file, locale, width, height, this.getApplicationName(), this.getAdditionalUsages());
    }

    protected void setupMetadata() {
        URL schemaURL = ClassLoaderUtils.getResource((String)_METADATA_SCHEMA_LOCATION);
        if (schemaURL != null) {
            MetadataSchemaRegistry.getInstance().registerSchema(schemaURL, "*");
        }
    }

    protected File getLibPath() {
        return this._libPath;
    }

    protected void loadSchema(URL url) {
        SchemaGrammarProvider gp = DemoXmlContext.getSharedGrammarProvider();
        try {
            gp.addSchema(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean needsScrolling(XmlUsage usage) {
        return XmlUsage.EXPLORER.equals((Object)usage) || XmlUsage.XML_CODE_EXPLORER.equals((Object)usage) || XmlUsage.LAYOUT_EDITOR.equals((Object)usage);
    }

    private void _run() {
        this.setupMetadata();
        this.createVisualEditorUI(this._file, this._locale, this._width, this._height);
    }

    private static void _printHelp() {
        System.out.println("Usage:  VisualEditor [options]\n\n");
        System.out.println("where options include:\n");
        System.out.println("\t-help\tPrint out this message");
        System.out.println("\t-file=\t<path> to the file to edit (required)");
        System.out.println("\t-htmlRoot=\t<path> to the directory to use as the HTML root (required)");
        System.out.println("\t-libPath=\t<path> to the directory that contains your runtime libraries and schemas (required)");
        System.out.println("\t-locale=\t<locale> IANA locale (e.g. en-us)");
        System.out.println("\t-width=\twidth of window in pixels");
        System.out.println("\t-height=\theight of window in pixels");
        System.exit(0);
    }

    private static File _createRequiredParameterFile(String paramName, String paramValue) {
        File requiredFile = null;
        if (paramValue != null && paramValue.length() > 0) {
            try {
                requiredFile = new File(paramValue);
                if (!requiredFile.exists()) {
                    System.out.println("No file exists at location specified for: parameter " + paramName);
                    System.out.println(requiredFile.getCanonicalPath());
                }
            }
            catch (IOException e) {
                System.out.println("Exception occurred accessing file for parameter: " + paramName);
                e.printStackTrace();
                System.exit(1);
            }
        }
        return requiredFile;
    }

    private static void _checkForRequiredParameter(String paramName, Object paramValue) {
        if (paramValue == null) {
            System.out.println("The required parameter " + paramName + " was not provided");
            System.exit(1);
        }
    }
}

