/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.tooltip;

import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.AbstractXMLInsightProvider;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.InsightParser;
import oracle.bali.xml.editor.insight.tooltip.ValueTypeTooltipInsightData;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightData;
import oracle.bali.xml.model.XmlContext;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.TooltipInsightView;

public class XMLTooltipInsightProvider
extends AbstractXMLInsightProvider {
    private static final int FEEDBACK_MESSAGE_DELAY = 5000;
    private static final String RESOURCE_KEY_NO_INSIGHT = "XMLEDITOR.INSIGHT.NO_INSIGHT";
    private String _feedBackString = XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.NO_INSIGHT");

    public XMLTooltipInsightProvider(XmlContext xmlContext, DocumentScannerFactory docScannerFactory) {
        super(xmlContext, docScannerFactory);
    }

    public int getInsightType() {
        return 2;
    }

    public boolean isInsightTriggerChar(char typedChar) {
        return false;
    }

    public InsightData getInsightData(BasicEditorPane editorPane) {
        Object[] dataList;
        ValueTypeTooltipInsightData insightData = null;
        InsightParser parser = this.getInsightParser();
        InsightLocation insightLocation = parser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
        int type = this.getContextType(insightLocation);
        if (type == 5) {
            insightData = new ValueTypeTooltipInsightData(this, insightLocation);
        }
        if (insightData != null && (dataList = insightData.getData()).length == 0) {
            insightData = null;
        }
        if (insightData == null) {
            this.showFeedback(this._feedBackString, 5000);
        } else {
            this.hideFeedback();
        }
        return insightData;
    }

    public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
        if (lastData instanceof XMLTooltipInsightData) {
            XMLTooltipInsightData tooltipData = (XMLTooltipInsightData)lastData;
            InsightParser parser = this.getInsightParser();
            InsightLocation insightLocation = parser.determineInsightLocation(this.getTextBuffer(), this.getCaretPosition());
            int type = this.getContextType(insightLocation);
            if (type == 5) {
                tooltipData.updateData();
            } else {
                lastData = null;
            }
        }
        return lastData;
    }

    public InsightView getInsightView() {
        return new TooltipInsightView();
    }
}

