/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.xml.jdwp.XSLJDWPEventValue;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLAttributeSet;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLElement;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFallback;
import oracle.xml.xslt.XSLForEach;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLMiscElements;
import oracle.xml.xslt.XSLNumber;
import oracle.xml.xslt.XSLResultElement;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTDebuggerTraceEvent;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLText;
import oracle.xml.xslt.XSLValueOf;
import oracle.xml.xslt.XSLVariable;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class XSLNode
implements XSLConstants,
NSResolver,
Locator {
    private String defaultcollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private boolean preserveSpace = false;
    private URL XBaseURL;
    protected URL baseURL;
    protected int nParams = 0;
    protected FastVector paramList;
    int nVars = 0;
    private HashMap<NSName, XSLVariable> varHash;
    XSLStylesheet xss;
    public FastVector children;
    protected HashMap prefixHash;
    protected HashMap attrHash;
    protected int elementType = 3;
    String prefix;
    String localName;
    String namespace = "http://www.w3.org/1999/XSL/Transform";
    XSLNode parent;
    private int line;
    private int col;
    private String sysid;
    private boolean flushIncreamentalOutputFlag = false;
    private int codeIndexBegin;
    private int codeIndexEnd;
    protected XSLJDWPEventValue jdwpEventValue;
    private int endingline;
    protected String concatedAttrs = "";
    private int errId;
    private String[] errParams;
    private int errType;
    private XSLNode origNode;
    private boolean reportError;
    XSLAttributeSet[] attrsets;
    int numattrsets = 0;
    protected FastVector exclResPrefixes;
    int xssImportPriority;
    int version;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;

    public XSLNode() throws XSLException {
    }

    public XSLNode(XSLStylesheet xSLStylesheet) throws XSLException {
        this();
        this.xss = xSLStylesheet;
        this.jdwpEventValue = new XSLJDWPEventValue(xSLStylesheet);
    }

    boolean includedInOSBDebugCallStack() {
        return false;
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getURI() {
        return this.namespace;
    }

    public String getQualifiedName() {
        if (this.prefix != "") {
            return this.prefix + ":" + this.localName;
        }
        return this.localName;
    }

    void setPrefix(String string) {
        this.prefix = string;
    }

    void setLocalName(String string) {
        this.localName = string;
    }

    void setURI(String string) {
        this.namespace = string;
    }

    public HashMap getPrefixHash() {
        return this.prefixHash;
    }

    public void setPrefixHash(HashMap hashMap) {
        this.prefixHash = hashMap;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        if (string == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string == "xmlns") {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.prefixHash != null) {
            return (String)this.prefixHash.get(string);
        }
        return null;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "" || this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "" || this.namespace != "http://www.w3.org/1999/XSL/Transform" && string == "http://www.w3.org/1999/XSL/Transform" || this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "http://www.oracle.com/XSL/Transform/java") {
            if (this.attrHash == null) {
                this.attrHash = new HashMap(20);
            }
            this.attrHash.put(string3, string4);
        }
        if (string == "http://www.w3.org/XML/1998/namespace" && string3 == "space") {
            if (string4.equals("preserve")) {
                this.preserveSpace = true;
            } else if (string4.equals("default")) {
                this.preserveSpace = false;
            }
        }
        if (string == "http://www.w3.org/XML/1998/namespace" && string3 == "base") {
            String string5 = this.xss.getSystemId();
            try {
                URL uRL = new URL(string5);
                this.XBaseURL = new URL(uRL, string4);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XSLException(malformedURLException.getMessage());
            }
        }
        if (this.version >= 20) {
            this.processStandardAttrs(string, string3, string4);
        }
    }

    private void processStandardAttrs(String string, String string2, String string3) {
        if (string2 == "default-collation" && this.isInXSLNamespace(string)) {
            this.defaultcollation = string3;
        }
    }

    private boolean isInXSLNamespace(String string) {
        if (this.namespace == "" && string == "http://www.w3.org/1999/XSL/Transform") {
            return true;
        }
        return this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "";
    }

    protected void setDefaultCollation(XSLTContext xSLTContext) {
        if (this.version == 10) {
            return;
        }
        xSLTContext.setDefaultCollation(this.defaultcollation);
    }

    URL getXBaseURL() {
        return this.XBaseURL;
    }

    protected void setBaseURL(URL uRL) {
        this.baseURL = uRL;
    }

    protected URL getBaseURL() {
        return this.baseURL;
    }

    protected void setContextBaseURL(XSLTContext xSLTContext) {
        if (this.baseURL != null) {
            xSLTContext.setBaseURL(this.baseURL);
        }
    }

    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "" || this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "" || this.namespace != "http://www.w3.org/1999/XSL/Transform" && string == "http://www.w3.org/1999/XSL/Transform" || this.namespace == "http://www.w3.org/1999/XSL/Transform" && string == "http://www.oracle.com/XSL/Transform/java") {
            if (this.attrHash == null) {
                return null;
            }
            return (String)this.attrHash.get(string2);
        }
        return null;
    }

    public void addNamespace(String string, String string2) throws XSLException {
        if (this.prefixHash == null) {
            this.prefixHash = new HashMap(20);
        } else if (this.parent != null && this.prefixHash == this.parent.prefixHash) {
            this.prefixHash = (HashMap)this.parent.prefixHash.clone();
        }
        this.prefixHash.put(string, string2);
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        if (this.reportError) {
            xMLError.setLocator(this);
            xMLError.error(this.errId, this.errType, this.errParams);
            this.clearError();
        }
    }

    public void startContent() throws XSLException, XQException {
        if (this.namespace == "http://www.w3.org/1999/XSL/Transform" && this.localName == "stylesheet") {
            String string = this.getAttribute("", "exclude-result-prefixes");
            if (string != null) {
                this.addResultPrefixes(string);
            }
            if ((string = this.getAttribute("", "extension-element-prefixes")) != null) {
                this.xss.addExtensionNamespace(this, string);
            }
        }
    }

    void endContent() throws XSLException, XQException {
        if (this.nVars != 0) {
            this.xss.popVariable(this.nVars);
        }
    }

    public void finalizeXSLNode() throws XSLException, XQException {
        if (this.children != null) {
            int n;
            int n2 = this.children.size();
            XSLNode[] xSLNodeArray = new XSLNode[n2];
            for (n = 0; n < n2; ++n) {
                xSLNodeArray[n] = (XSLNode)this.children.elementAt(n);
            }
            for (n = 0; n < n2; ++n) {
                xSLNodeArray[n].finalizeXSLNode();
            }
        }
    }

    public void processChildren(XSLTContext xSLTContext) throws XSLException, XQException {
        XMLError xMLError = xSLTContext.getError();
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                XSLNode xSLNode = (XSLNode)this.children.elementAt(i);
                if (xSLTContext.getIsExtElemErr() && this instanceof XSLResultElement && !(xSLNode instanceof XSLFallback)) continue;
                xMLError.setLocator(xSLNode);
                xSLNode.processAction(xSLTContext);
            }
        }
        if (this.nVars != 0) {
            xSLTContext.popVariable(this.nVars);
            if (xSLTContext.getOSBDebugNotInBuiltinMode(this)) {
                xSLTContext.popOSBDebugVar(this.nVars);
            }
        }
        xMLError.setLocator(this);
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        if (this.children == null) {
            this.children = new FastVector();
        }
        this.children.addElement(xSLNode);
        xSLNode.preserveSpace = this.preserveSpace;
        xSLNode.parent = this;
        if (this.prefixHash != null) {
            xSLNode.prefixHash = this.prefixHash;
        }
        xSLNode.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
    }

    public void appendText(char[] cArray, int n, int n2) throws XSLException {
        if (!this.preserveSpace && XMLUtil.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        XSLText xSLText = new XSLText(this.xss);
        xSLText.appendText(cArray, n, n2);
        this.appendChild(xSLText);
    }

    protected void addResultPrefixes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (this.exclResPrefixes == null) {
            this.exclResPrefixes = new FastVector(n);
        }
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("#all")) {
                this.exclResPrefixes.setSize(0);
                this.exclResPrefixes.addElement(string2);
                return;
            }
            string3 = this.resolveNamespacePrefix(string2);
            if (string3 == null || string3 == "") continue;
            this.exclResPrefixes.addElement(string3);
        }
    }

    protected void processAttrSets(XSLTContext xSLTContext) throws XSLException, XQException {
        if (this.attrsets == null) {
            String string = this.namespace == "http://www.w3.org/1999/XSL/Transform" ? this.getAttribute("", "use-attribute-sets") : this.getAttribute("http://www.w3.org/1999/XSL/Transform", "use-attribute-sets");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                this.numattrsets = stringTokenizer.countTokens();
                this.attrsets = new XSLAttributeSet[this.numattrsets];
                for (int i = 0; i < this.numattrsets; ++i) {
                    NSName nSName = this.resolveQname(stringTokenizer.nextToken());
                    this.attrsets[i] = this.xss.getAttributeSet(nSName);
                }
            } else {
                this.numattrsets = 0;
                this.attrsets = new XSLAttributeSet[1];
            }
        }
        for (int i = 0; i < this.numattrsets; ++i) {
            if (this.attrsets[i] == null) continue;
            if (xSLTContext.isInAttrSet(this.attrsets[i])) {
                this.xss.err.error2(1123, 0, this.attrsets[i].getName().getQualifiedName(), "xsl:attribute-set");
                throw new XSLException(this.xss.err, 0);
            }
            xSLTContext.pushAttrSet(this.attrsets[i]);
            this.attrsets[i].processAction(xSLTContext);
            xSLTContext.popAttrSet();
        }
    }

    protected XSLTemplate getCurrentTemplate() {
        XSLNode xSLNode = this;
        while (xSLNode.localName != "template" || xSLNode.namespace != "http://www.w3.org/1999/XSL/Transform") {
            xSLNode = xSLNode.parent;
        }
        return (XSLTemplate)xSLNode;
    }

    public XSLExprBase getParentCtxExpr() {
        if (this.parent != null) {
            return this.parent.getContextExpr();
        }
        return null;
    }

    XSLExprBase getContextExpr() {
        if (this.parent != null) {
            return this.parent.getContextExpr();
        }
        return null;
    }

    public boolean getDebugMode() {
        try {
            String string = XMLUtil.getProperty("oracle.xml.parser.debugmode", "false");
            if (string.equals("true")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setDebugInfo(int n, int n2, String string) {
        this.line = n;
        this.col = n2;
        this.sysid = string;
    }

    String getLocInfo() {
        String string = "";
        if (this.sysid != null) {
            int n = this.sysid.lastIndexOf(47);
            string = this.sysid.substring(n + 1);
        }
        return "<" + string + ">:" + this.line;
    }

    @Override
    public int getLineNumber() {
        return this.line;
    }

    @Override
    public int getColumnNumber() {
        return this.col;
    }

    void setEndingLineNumber(int n) {
        this.endingline = n;
    }

    int getEndingLineNumber() {
        return this.endingline;
    }

    void setCodeIndexBegin(int n) {
        this.codeIndexBegin = n;
    }

    int getCodeIndexBegin() {
        return this.codeIndexBegin;
    }

    void setCodeIndexEnd(int n) {
        this.codeIndexEnd = n;
    }

    int getCodeIndexEnd() {
        return this.codeIndexEnd;
    }

    @Override
    public String getSystemId() {
        return this.sysid;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    public void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    public int getXSLTVersion() {
        return this.version;
    }

    public boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    public boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    boolean isTopLevel() {
        return this.parent != null && this.parent.namespace == "http://www.w3.org/1999/XSL/Transform" && (this.parent.localName == "stylesheet" || this.parent.localName == "transform");
    }

    public NSName resolveQname(String string) throws XSLException {
        NSNameImpl nSNameImpl = XPathSequence.resolveQname(string, this);
        if (nSNameImpl.getNamespace() == null) {
            nSNameImpl.setNamespace("");
            this.xss.err.error1(1008, 1, nSNameImpl.getPrefix());
        }
        return nSNameImpl;
    }

    HashMap<NSName, XSLVariable> getVarHash() {
        return this.varHash;
    }

    boolean checkDuplicate(XSLVariable xSLVariable) {
        NSName nSName = xSLVariable.getName();
        if (this.varHash == null) {
            this.varHash = new HashMap(20);
        }
        if (nSName != null && !this.varHash.containsKey(nSName)) {
            if (!xSLVariable.isTopLevel() && xSLVariable.localName != "with-param") {
                ++this.nVars;
            }
            this.varHash.put(nSName, xSLVariable);
            return false;
        }
        return true;
    }

    void setErrorId(int n, int n2, int n3) {
        this.errId = n;
        this.errType = n2;
        this.errParams = new String[n3];
        this.reportError = true;
    }

    void addErrorParam(int n, String string) {
        this.errParams[n] = string;
    }

    void clearError() {
        this.reportError = false;
    }

    XSLNode replaceWithErrorNode() throws XSLException {
        FastVector fastVector = this.parent.children;
        int n = fastVector.indexOf(this);
        if (n != -1) {
            XSLNode xSLNode = new XSLNode(this.xss);
            xSLNode.origNode = this;
            fastVector.setElementAt(xSLNode, n);
        }
        return null;
    }

    void printXSLNode(PrintWriter printWriter, int n) {
        this.printIndent(printWriter, n);
        String string = this.resolveNamespace(this.namespace) + this.localName;
        printWriter.print("<" + string);
        if (this.prefixHash != null) {
            for (String string2 : this.prefixHash.keySet()) {
                String string3 = (String)this.prefixHash.get(string2);
                string2 = string2.equals("#default") ? "xmlns" : "xmlns:" + string2;
                printWriter.print(" " + string2 + "=\"" + string3 + "\"");
            }
        }
        this.printAttributes(printWriter);
        printWriter.println(">");
        this.printChildren(printWriter, n + 1);
        this.printIndent(printWriter, n);
        printWriter.println("</" + string + ">");
    }

    void printChildren(PrintWriter printWriter, int n) {
        if (this.children != null) {
            int n2 = this.children.size();
            for (int i = 0; i < n2; ++i) {
                ((XSLNode)this.children.elementAt(i)).printXSLNode(printWriter, n);
            }
        }
    }

    void printIndent(PrintWriter printWriter, int n) {
        while (n > 0) {
            printWriter.print("   ");
            --n;
        }
    }

    void printAttributes(PrintWriter printWriter) {
        if (this.attrHash != null) {
            for (String string : this.attrHash.keySet()) {
                printWriter.print(" " + string + "=\"" + this.attrHash.get(string) + "\"");
            }
        }
    }

    String resolveNamespace(String string) {
        if (string == null) {
            return "";
        }
        String string22 = null;
        if (this.prefixHash != null) {
            for (String string22 : this.prefixHash.keySet()) {
                if (!string.equals((String)this.prefixHash.get(string22))) continue;
                if (string22.equals("#default")) {
                    return "";
                }
                return string22 + ":";
            }
            string22 = null;
        }
        if (this.parent != null) {
            string22 = this.parent.resolveNamespace(string);
        }
        if (string22 == null) {
            return "";
        }
        return string22;
    }

    void copyNamespaces(XMLElement xMLElement, XSLEventHandler xSLEventHandler) throws XSLException {
        Object object;
        Cloneable cloneable;
        String string = xMLElement.resolveNamespacePrefix("#default");
        if (string != null) {
            cloneable = (XMLElement)xMLElement.getParentNode();
            object = cloneable != null ? ((XMLElement)cloneable).resolveNamespacePrefix("#default") : null;
            if (!string.equals("") || !string.equals(object)) {
                xSLEventHandler.namespaceAttr("", string);
            }
        }
        if ((cloneable = xMLElement.getAllNamespaceAttrs()) != null) {
            object = ((Hashtable)cloneable).keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                String string3 = (String)((Hashtable)cloneable).get(string2);
                xSLEventHandler.namespaceAttr(string2, string3);
            }
        }
    }

    static XSLNode createUpdateVar(XSLStylesheet xSLStylesheet, NSName nSName, XSLExprBase xSLExprBase) throws XSLException {
        UpdateVar updateVar = new UpdateVar(xSLStylesheet);
        updateVar.varName = nSName;
        updateVar.expr = xSLExprBase;
        return updateVar;
    }

    static EndElement createEndElement(XSLStylesheet xSLStylesheet) throws XSLException {
        return new EndElement(xSLStylesheet);
    }

    protected FastVector getParamList() {
        return this.paramList;
    }

    private int getPreSiblingNum(XSLNode xSLNode) {
        XSLNode xSLNode2;
        if (xSLNode.parent == null) {
            return 0;
        }
        FastVector fastVector = xSLNode.parent.children;
        int n = 0;
        if (xSLNode.parent.nParams > 0 && xSLNode instanceof XSLVariable) {
            FastVector fastVector2 = xSLNode.parent.getParamList();
            for (int i = 0; i < xSLNode.parent.nParams; ++i) {
                if (!fastVector2.elementAt(i).equals(xSLNode)) continue;
                return i;
            }
        }
        if (xSLNode.parent.nParams > 0) {
            n += xSLNode.parent.nParams;
        }
        if (fastVector == null || fastVector.size() == 1) {
            return n;
        }
        for (int i = 0; i < fastVector.size() && !(xSLNode2 = (XSLNode)fastVector.elementAt(i)).equals(xSLNode); ++i) {
            if (xSLNode2 instanceof EndElement || xSLNode.parent != xSLNode2.parent || xSLNode2.localName.equals("stylesheet") || xSLNode2.localName.equals("transform") && xSLNode2.namespace != null && xSLNode2.namespace.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            ++n;
        }
        return n;
    }

    protected int[] getPath4OSBDebugger() {
        int[] nArray;
        int n = 10;
        int[] nArray2 = new int[n];
        XSLNode xSLNode = this;
        int n2 = 0;
        while (xSLNode != null && !(xSLNode instanceof XSLStylesheet)) {
            if (xSLNode instanceof EndElement) {
                xSLNode = xSLNode.parent;
                continue;
            }
            nArray2[n2] = this.getPreSiblingNum(xSLNode);
            xSLNode = xSLNode.parent;
            if (++n2 != n) continue;
            nArray = new int[n * 2];
            System.arraycopy(nArray2, 0, nArray, 0, n);
            n *= 2;
        }
        if (n2 == 0) {
            nArray = new int[1];
            return nArray;
        }
        nArray = new int[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        while (n3 >= 0) {
            nArray[n4] = nArray2[n3];
            --n3;
            ++n4;
        }
        return nArray;
    }

    void setFlushIncreamentalOutputFlag(boolean bl) {
        this.flushIncreamentalOutputFlag = bl;
    }

    boolean getFlushIncreamentalOutputFlag() {
        return this.flushIncreamentalOutputFlag;
    }

    private XSLTDebuggerTraceEvent generateXSLTDebuggerTraceEventData(XSLTContext xSLTContext, XSLNode xSLNode, String string) {
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = new XSLTDebuggerTraceEvent(xSLNode, xSLTContext, string);
        return xSLTDebuggerTraceEvent;
    }

    private boolean isOSBAttrsAdded(XSLNode xSLNode) {
        return xSLNode instanceof XSLForEach || xSLNode instanceof XSLFunction || xSLNode instanceof XSLStylesheet || xSLNode instanceof XSLTemplate || xSLNode instanceof XSLValueOf || xSLNode instanceof XSLVariable;
    }

    protected void fireOSBDebuggerTraceEventBeforeExe(XSLTContext xSLTContext, XSLNode xSLNode, String string) throws XSLException {
        if (!xSLTContext.getOSBDebugMode()) {
            return;
        }
        if (xSLNode.getBaseURL() == null) {
            return;
        }
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = this.generateXSLTDebuggerTraceEventData(xSLTContext, xSLNode, string);
        XMLContentHandler xMLContentHandler = xSLTContext.getOSBDebugContentHandler();
        if (xSLTContext.getOsbDebugAttrStk().size() > 0 && this.isOSBAttrsAdded(this)) {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, -1, xSLTContext.getOsbDebugAttrStk().peek(), xMLContentHandler);
        } else {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, -1, new HashMap<String, Object>(1), xMLContentHandler);
        }
    }

    protected void fireOSBDebuggerTraceEventAfterExe(XSLTContext xSLTContext, XSLNode xSLNode, String string) throws XSLException {
        if (!xSLTContext.getOSBDebugMode()) {
            return;
        }
        if (xSLNode.getBaseURL() == null && !(xSLNode instanceof EndElement)) {
            return;
        }
        XSLTDebuggerTraceEvent xSLTDebuggerTraceEvent = this.generateXSLTDebuggerTraceEventData(xSLTContext, xSLNode, string);
        XMLContentHandler xMLContentHandler = xSLTContext.getOSBDebugContentHandler();
        if (xSLTContext.getIsFiredByOSBDebuggerEndElement()) {
            xSLTDebuggerTraceEvent.setLineNumber(xSLTContext.getOSBDebugLineNumber());
            xSLTDebuggerTraceEvent.setColumnNumber(xSLTContext.getOSBDebugColNumber());
            xSLTDebuggerTraceEvent.setBaseURL(xSLTContext.getOSBDebugBaseURL());
        }
        if (xSLTContext.getOsbDebugAttrStk().size() > 0 && this.isOSBAttrsAdded(this)) {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, 1, xSLTContext.getOsbDebugAttrStk().peek(), xMLContentHandler);
        } else {
            xSLTContext.getOSBDebugListener().trace(xSLTDebuggerTraceEvent, 1, new HashMap<String, Object>(1), xMLContentHandler);
        }
    }

    protected void addJDWPDataBefore(XSLTContext xSLTContext, XSLStylesheet xSLStylesheet, XSLNode xSLNode, String string, String string2, byte by) {
        this.xss = xSLStylesheet;
        this.jdwpEventValue = new XSLJDWPEventValue(xSLStylesheet);
        this.addJDWPDataBefore(xSLTContext, xSLNode, string, string2, by);
    }

    protected void addJDWPDataBefore(XSLTContext xSLTContext, XSLNode xSLNode, String string, String string2, byte by) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setXSLTContext(xSLTContext);
        this.jdwpEventValue.setInstructionName(string);
        this.jdwpEventValue.setLineNumber(xSLNode.getLineNumber());
        this.jdwpEventValue.setCodeIndexBegin(xSLNode.getCodeIndexBegin());
        String string3 = xSLNode.getSystemId();
        this.jdwpEventValue.setBaseURL(string3);
        this.jdwpEventValue.setName(string2);
        this.jdwpEventValue.setEventKind(by);
        if (xSLNode instanceof XSLResultElement || xSLNode instanceof XSLElement) {
            xSLTContext.pushCurrentElementIName(string);
            xSLTContext.pushCurrentElementNode(xSLNode);
        }
        if (this.concatedAttrs != null && this.concatedAttrs.length() > 0) {
            this.jdwpEventValue.setConcatedAttrs(this.concatedAttrs);
        }
        this.jdwpEventValue.add();
    }

    protected void addJDWPDataAfter(XSLNode xSLNode, String string, String string2, byte by, ContentHandler contentHandler) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setInstructionName(string);
        this.jdwpEventValue.setLineNumber(xSLNode.getEndingLineNumber());
        this.jdwpEventValue.setCodeIndexEnd(xSLNode.getCodeIndexEnd());
        String string3 = xSLNode.getSystemId();
        this.jdwpEventValue.setBaseURL(string3);
        this.jdwpEventValue.setName(string2);
        this.jdwpEventValue.setEventKind(by);
        this.jdwpEventValue.add();
        if (contentHandler == null) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void addJDWPDataAfter(XSLNode xSLNode, byte by, ContentHandler contentHandler) {
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        this.jdwpEventValue.setLineNumber(xSLNode.getEndingLineNumber());
        this.jdwpEventValue.setCodeIndexEnd(xSLNode.getCodeIndexEnd());
        this.jdwpEventValue.setEventKind(by);
        this.jdwpEventValue.add();
        if (contentHandler == null) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flushPartialOutputByReportingStartElement(XSLTContext xSLTContext) throws XSLException {
        if (!(this instanceof XSLResultElement) && !(this instanceof XSLElement)) {
            return;
        }
        XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
        if (xSLEventHandler.getQNameStack() != null && !xSLEventHandler.getQNameStack().empty()) {
            xSLEventHandler.reportStartElement();
            xSLEventHandler.resetCurrentState();
        }
    }

    protected void flushPartialOutput(XSLEventHandler xSLEventHandler, ContentHandler contentHandler) {
        try {
            xSLEventHandler.reportStartElement();
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
        xSLEventHandler.resetCurrentState();
        if (!this.xss.getXSLDebugProp().debug()) {
            return;
        }
        try {
            ((XSLSAXPrintDriver)contentHandler).flushDebugStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean isXSLMessageChildren() {
        XSLNode xSLNode = this.parent;
        while (xSLNode != null) {
            if (xSLNode instanceof XSLMiscElements && xSLNode.localName == "message") {
                return true;
            }
            xSLNode = xSLNode.parent;
        }
        return false;
    }

    protected boolean hasAttributeInsChild() {
        if (this.children == null) {
            return false;
        }
        int n = this.children.size();
        if (n == 0) {
            return false;
        }
        if (this.children.elementAt(0) instanceof XSLValueOf || this.children.elementAt(0) instanceof XSLText || this.children.elementAt(0) instanceof XSLNumber || this.children.elementAt(0) instanceof XSLElement || this.children.elementAt(0) instanceof XSLResultElement) {
            return false;
        }
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            if (!(this.children.elementAt(i) instanceof XSLValueOf) && !(this.children.elementAt(i) instanceof XSLText) && !(this.children.elementAt(i) instanceof XSLNumber) && !(this.children.elementAt(i) instanceof XSLElement) && !(this.children.elementAt(i) instanceof XSLResultElement) && !(this.children.elementAt(i) instanceof XSLVariable) && !(this.children.elementAt(i) instanceof XSLMiscElements) && !(this.children.elementAt(i) instanceof XSLFallback) && !(this.children.elementAt(i) instanceof XSLForEach)) continue;
            --n2;
        }
        return n2 != 0;
    }

    static class EndElement
    extends XSLNode {
        private String qname;

        EndElement(XSLStylesheet xSLStylesheet) throws XSLException {
            super(xSLStylesheet);
            this.elementType = 7;
        }

        void setQName(String string, String string2) {
            this.qname = string;
            if (string2 != null && string2.length() > 0) {
                this.qname = string2 + ":" + this.qname;
            }
        }

        @Override
        boolean includedInOSBDebugCallStack() {
            return true;
        }

        @Override
        public void processAction(XSLTContext xSLTContext) throws XSLException {
            XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
            if (this.nVars != 0) {
                xSLTContext.popVariable(this.nVars);
                if (xSLTContext.getOSBDebugNotInBuiltinMode(this)) {
                    xSLTContext.popOSBDebugVar(this.nVars);
                }
            }
            xSLEventHandler.endElement();
            if (xSLTContext.getOSBDebugMode()) {
                xSLTContext.setIsFiredByOSBDebuggerEndElement(true);
                this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, this.qname);
                xSLTContext.resetIsFiredByOSBDebuggerEndElement();
                xSLTContext.resetOSBDebugBaseURL();
                xSLTContext.resetOSBDebugLineNumber();
                xSLTContext.resetOSBDebugColNumber();
            }
            if (xSLTContext.isInDebugMode()) {
                this.addJDWPDataAfter(xSLTContext.popCurrentElementNode(), xSLTContext.popCurrentElementIName(), "", (byte)-1, xSLTContext.getJDWPContentHandler());
            }
        }
    }

    static class UpdateVar
    extends XSLNode {
        XSLExprBase expr;
        NSName varName;

        UpdateVar(XSLStylesheet xSLStylesheet) throws XSLException {
            super(xSLStylesheet);
            this.elementType = 7;
        }

        @Override
        public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
            OXMLSequence oXMLSequence = xSLTContext.getVariable(this.varName, -2);
            this.expr.evaluate(xSLTContext);
            oXMLSequence.reset();
            XPathSequence.concatSequence(oXMLSequence, xSLTContext.popExprValue());
        }
    }

    class AttrValueTmpl {
        String purestringresult;
        XSLExprBase purexprresult;
        FastVector mixedresult;
        String source;
        boolean isAVT = false;

        boolean isAttrValueTmpl() {
            return this.isAVT;
        }

        AttrValueTmpl(String string, XSLNode xSLNode2) throws XSLException, XQException {
            Object object;
            int n;
            if (string == null) {
                return;
            }
            if (string.length() == 0) {
                this.purestringresult = string;
                return;
            }
            this.source = string;
            char[] cArray = string.toCharArray();
            String string2 = "";
            XSLExprBase xSLExprBase = null;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            for (n = 0; n < string.length(); ++n) {
                if (cArray[n] == '\'' && bl2) {
                    bl = !bl;
                    continue;
                }
                if (!bl && cArray[n] == '{') {
                    if (n + 1 < string.length() && cArray[n + 1] == '{') {
                        ++n4;
                        ++n;
                        continue;
                    }
                    if (n + 1 < string.length()) {
                        bl2 = true;
                        n2 = n;
                        if (n2 <= n3) continue;
                        string2 = n3 == 0 ? string.substring(n3, n2) : string.substring(n3 + 1, n2);
                        if (this.mixedresult == null) {
                            this.mixedresult = new FastVector();
                        }
                        string2 = this.escapeCurlyBraces(string2, n4, n5);
                        this.mixedresult.addElement(string2.toCharArray());
                        n5 = 0;
                        n4 = 0;
                        continue;
                    }
                    throw new XPathException(1027);
                }
                if (bl || cArray[n] != '}') continue;
                if (n + 1 < string.length() && cArray[n + 1] == '}') {
                    ++n5;
                    ++n;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    n3 = n;
                    string2 = string.substring(n2 + 1, n3 - n5 * 2);
                    object = new XSLParseString(string2.toCharArray(), 0, xSLNode2, xSLNode2.xss);
                    ((XSLParseString)object).setCompatibilityFlags(xSLNode2.getXSLTVersion(), xSLNode2.isBackwardCompatibilityMode(), xSLNode2.isForwardCompatibilityMode());
                    xSLExprBase = XSLExpr.parse((XSLParseString)object);
                    if (((XSLParseString)object).getPrevPosition() < ((XSLParseString)object).getCurrentPosition()) {
                        xSLNode2.xss.err.error2(1070, 1, string2.substring(((XSLParseString)object).getPrevPosition(), ((XSLParseString)object).getCurrentPosition()), string2);
                    }
                    if (this.mixedresult == null) {
                        this.mixedresult = new FastVector();
                    }
                    this.mixedresult.addElement(xSLExprBase);
                    if (n5 <= 0) continue;
                    string2 = string.substring(n3 - n5, n3);
                    this.mixedresult.addElement(string2.toCharArray());
                    continue;
                }
                throw new XPathException(1032);
            }
            if (bl2) {
                throw new XPathException(1027);
            }
            if (string.length() > n3 + 1 && this.mixedresult != null) {
                string2 = string.substring(n3 + 1, string.length());
                this.mixedresult.addElement(string2.toCharArray());
            }
            if (this.mixedresult == null) {
                this.purestringresult = this.source;
                this.purestringresult = this.escapeCurlyBraces(this.purestringresult, n4, n5);
                return;
            }
            n = this.mixedresult.size();
            if (n == 1) {
                object = this.mixedresult.elementAt(0);
                if (object instanceof String) {
                    this.purestringresult = (String)object;
                } else {
                    this.purexprresult = (XSLExprBase)object;
                    this.isAVT = true;
                }
                this.mixedresult = null;
            } else {
                this.isAVT = true;
            }
        }

        private String escapeCurlyBraces(String string, int n, int n2) {
            if (n > 0) {
                string = string.replaceAll("\\{{2}", "{");
            }
            if (n2 > 0) {
                string = string.replaceAll("\\}{2}", "}");
            }
            return string;
        }

        String getValue(XSLTContext xSLTContext) throws XSLException, XQException {
            if (this.purestringresult != null) {
                return this.purestringresult;
            }
            if (this.purexprresult != null) {
                try {
                    this.purexprresult.evaluate(xSLTContext);
                }
                catch (Exception exception) {
                    throw new XSLException(exception.getMessage());
                }
                return XPathSequence.getStringValue(xSLTContext.popExprValue());
            }
            int n = this.mixedresult.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                Object object;
                Object object2 = this.mixedresult.elementAt(i);
                if (object2 instanceof XSLExprBase) {
                    XSLExprBase xSLExprBase = (XSLExprBase)object2;
                    xSLExprBase.evaluate(xSLTContext);
                    OXMLSequence oXMLSequence = xSLTContext.popExprValue();
                    object = XPathSequence.getStringValue(oXMLSequence);
                    n3 = ((String)object).length();
                    while (n3 + n2 > xSLTContext.getResultArraySize()) {
                        char[] cArray = xSLTContext.getResultArray();
                        int n4 = xSLTContext.getResultArraySize() * 2;
                        xSLTContext.initResultArray(n4);
                        System.arraycopy(cArray, 0, xSLTContext.getResultArray(), 0, n2);
                    }
                    ((String)object).getChars(0, n3, xSLTContext.getResultArray(), n2);
                    n2 += n3;
                    continue;
                }
                char[] cArray = (char[])object2;
                int n5 = cArray.length;
                while (n5 + n2 > xSLTContext.getResultArraySize()) {
                    object = xSLTContext.getResultArray();
                    n3 = xSLTContext.getResultArraySize() * 2;
                    xSLTContext.initResultArray(n3);
                    System.arraycopy(object, 0, xSLTContext.getResultArray(), 0, n2);
                }
                System.arraycopy(cArray, 0, xSLTContext.getResultArray(), n2, n5);
                n2 += n5;
            }
            String string = new String(xSLTContext.getResultArray(), 0, n2);
            return string;
        }

        String getAVTInputString() {
            return this.source;
        }
    }
}

