/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.xpath.IntersectExceptExpr;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class XSLNodeSetExpr
extends XSLExprBase {
    private FastVector exprVector = new FastVector();

    XSLNodeSetExpr() throws XSLException {
        super.setExprType(0x2200000);
    }

    FastVector getExprVector() {
        return this.exprVector;
    }

    void setExprVector(FastVector fastVector) {
        this.exprVector = fastVector;
    }

    static XSLNodeSetExpr union(PathExpr[] pathExprArray) throws XSLException {
        int n = pathExprArray.length;
        int n2 = 0;
        XSLNodeSetExpr xSLNodeSetExpr = new XSLNodeSetExpr();
        xSLNodeSetExpr.setCompatibilityFlags(pathExprArray[0].getXSLTVersion(), pathExprArray[0].isBackwardCompatibilityMode(), pathExprArray[0].isForwardCompatibilityMode());
        while (n2 < n) {
            PathExpr pathExpr = pathExprArray[n2++];
            xSLNodeSetExpr.exprVector.addElement(pathExpr);
        }
        return xSLNodeSetExpr;
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        XSLExprBase xSLExprBase = IntersectExceptExpr.parse(xSLParseString);
        if (xSLParseString.peekToken() == 102) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsWithBooleanParam(121, 0, true, false);
            }
            XSLNodeSetExpr xSLNodeSetExpr = new XSLNodeSetExpr();
            xSLNodeSetExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            xSLNodeSetExpr.exprVector.addElement(xSLExprBase);
            if (!xSLExprBase.mayBeExprType(0x200000)) {
                throw new XPathException(1038);
            }
            while (xSLParseString.peekToken(102)) {
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithBooleanParam(121, 0, true, false);
                }
                if (!(xSLExprBase = IntersectExceptExpr.parse(xSLParseString)).mayBeExprType(0x200000)) {
                    throw new XPathException(1038);
                }
                xSLNodeSetExpr.exprVector.addElement(xSLExprBase);
                if (xSLNodeSetExpr.priority < xSLExprBase.priority) {
                    xSLNodeSetExpr.priority = xSLExprBase.priority;
                }
                if (xPathCompileEvents == null) continue;
                xPathCompileEvents.reportEventsWithBooleanParam(121, 1, true, false);
            }
            xSLExprBase = xSLNodeSetExpr;
            if (xSLParseString.isCachingExpr() && !xSLNodeSetExpr.canCacheExpr()) {
                xSLNodeSetExpr.cacheSubExpr();
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsWithBooleanParam(121, 1, true, false);
            }
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.exprVector.setElementAt(xSLExprBase.createCachedExpr(), i);
        }
    }

    @Override
    boolean canCacheExpr() {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRelIndependent() {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            if (xSLExprBase.isRelIndependent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
        StringBuffer stringBuffer = new StringBuffer(xSLExprBase.getNormalizedExpr());
        int n = this.exprVector.size();
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            stringBuffer.append(102);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        if (this.flag >= 0) {
            return this.flag;
        }
        this.flag = 0;
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            this.flag |= xSLExprBase.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n = this.exprVector.size();
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(0);
        xSLExprBase.evaluate(xPathRuntimeContext);
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
        if (!xSLExprBase.isExprType(0x200000) && !xPathSequence.isNodeSequence()) {
            throw new XPathException(1038);
        }
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            xSLExprBase.evaluate(xPathRuntimeContext);
            XPathSequence xPathSequence2 = (XPathSequence)xPathRuntimeContext.popExprValue();
            if (!xSLExprBase.isExprType(0x200000) && !xPathSequence2.isNodeSequence()) {
                throw new XPathException(1038);
            }
            XPathSequence.mergeSequence(xPathSequence, xPathSequence2);
        }
    }

    @Override
    public XSLExprBase matchPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        XSLExprBase xSLExprBase = null;
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase2 = (XSLExprBase)this.exprVector.elementAt(i);
            if (!(xSLExprBase2.getPriority() > f) || xSLExprBase2.matchPattern(xMLNode, f, xSLTContext) == null) continue;
            xSLExprBase = xSLExprBase2;
            f = xSLExprBase2.getPriority();
        }
        return xSLExprBase;
    }

    @Override
    public int matchPattern(XSLExprBase xSLExprBase, float f) throws XSLException {
        int n = -1;
        int n2 = this.exprVector.size();
        if (xSLExprBase instanceof XSLNodeSetExpr) {
            XSLNodeSetExpr xSLNodeSetExpr = (XSLNodeSetExpr)xSLExprBase;
            int n3 = xSLNodeSetExpr.exprVector.size();
            n = 0;
            for (int i = 0; i < n3; ++i) {
                n += this.matchPattern((XSLExprBase)xSLNodeSetExpr.exprVector.elementAt(i), f);
            }
            if (n == n3) {
                return 1;
            }
            if (n == -1 * n3) {
                return -1;
            }
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            XSLExprBase xSLExprBase2 = (XSLExprBase)this.exprVector.elementAt(i);
            if (!(xSLExprBase2.getPriority() > f)) continue;
            int n4 = xSLExprBase2.matchPattern(xSLExprBase, f);
            if (n == 0) {
                return 0;
            }
            if (n4 <= 0) continue;
            n = n4;
            f = xSLExprBase2.getPriority();
        }
        return n;
    }

    @Override
    public void setPriority(float f) throws XSLException {
        int n = this.exprVector.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i);
            xSLExprBase.setPriority(f);
        }
        this.priority = f;
    }
}

