/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.xml.fdom.FDOMInfosetReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLCompatible;
import oracle.xml.util.XMLError;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XMLUtil
implements XMLConstants {
    private static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final int[] chartype = new int[256];
    private static final int caseDiff = 32;
    private static final int XMLUTIL_XMLNAMECHAR = 32;
    private static final int XMLUTIL_XMLNAMESTARTCHAR = 64;
    private static final boolean oldBehavior = XMLCompatible.useBuggyBehavior(11902993);
    static Hashtable encodingMap;
    static Hashtable encodingMap116;

    public static String[] stringTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static boolean reportDocEvents(Object object, String[] stringArray) {
        if (!(object instanceof ContentHandler) && !(object instanceof XSLEventHandler)) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length == 1 && stringArray[0].equals("#all")) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz;
            try {
                clazz = Class.forName(stringArray[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (object.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = XMLUtil.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
        return uRL;
    }

    public static String getJavaEncoding(String string) {
        String string2;
        String string3 = XMLUtil.getProperty("java.version", "1.1");
        if (string3.startsWith("1.1") && (string2 = (String)encodingMap116.get(string)) != null) {
            return string2;
        }
        return (String)encodingMap.get(string);
    }

    public static String encodeURL(String string) {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "ISO8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u001f' && c < '~') {
                stringBuffer.append(c);
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                char c2 = Character.forDigit(byArray[j] >> 4 & 0xF, 16);
                if (Character.isLowerCase(c2)) {
                    c2 = (char)(c2 - 32);
                }
                stringBuffer.append(c2);
                c2 = Character.forDigit(byArray[j] & 0xF, 16);
                if (Character.isLowerCase(c2)) {
                    c2 = (char)(c2 - 32);
                }
                stringBuffer.append(c2);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    public static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (XMLUtil.isWhiteSpaceChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 1) != 0;
        }
        return Character.isWhitespace(c);
    }

    public static boolean isNameChar(char c) {
        boolean bl;
        if (c < '\u0100') {
            bl = (chartype[c] & 0xE) != 0;
        } else if (c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' || c >= '\u0e47' && c <= '\u0e4e') {
            bl = true;
        } else if (c == '\u02ff' || c == '\u0346' || c == '\u0362' || c == '\u0487' || c == '\u05a2' || c == '\u05ba' || c == '\u05be' || c == '\u05c0' || c == '\u05c3' || c == '\u0653' || c == '\u06b8' || c == '\u06b9' || c == '\u06e9' || c == '\u06ee' || c == '\u0904' || c == '\u093b' || c == '\u094e' || c == '\u0955' || c == '\u0964' || c == '\u0984' || c == '\u09c5' || c == '\u09c9' || c == '\u09ce' || c == '\u09d8' || c == '\u09e4' || c == '\u0a03' || c == '\u0a3d' || c == '\u0a46' || c == '\u0a49' || c == '\u0a4e' || c == '\u0a80' || c == '\u0a84' || c == '\u0abb' || c == '\u0ac6' || c == '\u0aca' || c == '\u0ace' || c == '\u0b04' || c == '\u0b3b' || c == '\u0b44' || c == '\u0b4a' || c == '\u0b4e' || c == '\u0b58' || c == '\u0b84' || c == '\u0bc3' || c == '\u0bc9' || c == '\u0bd6' || c == '\u0c0d' || c == '\u0c45' || c == '\u0c49' || c == '\u0c54' || c == '\u0c81' || c == '\u0c84' || c == '\u0cc5' || c == '\u0cc9' || c == '\u0cd4' || c == '\u0cd7' || c == '\u0d04' || c == '\u0d45' || c == '\u0d49' || c == '\u0d4e' || c == '\u0d58' || c == '\u0e3f' || c == '\u0e3b' || c == '\u0e4f' || c == '\u0eba' || c == '\u0ebe' || c == '\u0ece' || c == '\u0f1a' || c == '\u0f36' || c == '\u0f38' || c == '\u0f3b' || c == '\u0f3a' || c == '\u0f70' || c == '\u0f85' || c == '\u0f8c' || c == '\u0f96' || c == '\u0f98' || c == '\u0fb0' || c == '\u0fb8' || c == '\u0fba' || c == '\u20dd' || c == '\u20e2' || c == '\u3030' || c == '\u309b' || c == '\u066a' || c == '\u06fa' || c == '\u0970' || c == '\u09f2' || c == '\u0af0' || c == '\u0b70' || c == '\u0c65' || c == '\u0ce5' || c == '\u0cf0' || c == '\u0d70' || c == '\u0e5a' || c == '\u0eda' || c == '\u0f2a' || c == '\u02d2' || c == '\u03fe' || c == '\u065f' || c == '\u0e5c' || c == '\u0c04') {
            bl = false;
        } else {
            bl = Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
            bl = true;
        }
        return bl;
    }

    public static boolean isNmtokenChar(char c) {
        if (c == ':') {
            return true;
        }
        return XMLUtil.isNameChar(c);
    }

    public static boolean isFirstNameChar(char c) {
        boolean bl = c < '\u0100' ? (chartype[c] & 0x14) != 0 : (c >= '\u2180' && c <= '\u2182' || c == '\u3007' || c >= '\u3021' && c <= '\u3029' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' ? true : (c == '\u1101' || c == '\u1104' || c == '\u1108' || c == '\u110a' || c == '\u110d' || c == '\u113b' || c == '\u1141' || c == '\u114d' || c == '\u114f' || c == '\u1151' || c == '\u1156' || c == '\u1162' || c == '\u1164' || c == '\u1166' || c == '\u116b' || c == '\u116f' || c == '\u1174' || c == '\u119f' || c == '\u11ac' || c == '\u11b6' || c == '\u11b9' || c == '\u11bb' || c == '\u11c3' || c == '\u11f1' || c == '\u0132' || c == '\u0133' || c == '\u013f' || c == '\u0140' || c == '\u0149' || c == '\u017f' || c == '\u01c4' || c == '\u01cc' || c == '\u01f1' || c == '\u01f3' || c == '\u0e46' || c == '\u113f' || c == '\u01f6' || c == '\u01f9' || c == '\u0230' || c == '\u03d7' || c == '\u03dd' || c == '\u03e1' || c == '\u040d' || c == '\u0450' || c == '\u045d' || c == '\u04ec' || c == '\u04ed' || c == '\u06b8' || c == '\u06bf' || c == '\u06cf' || c == '\u0e2f' || c == '\u0eaf' || c == '\u0f6a' || c == '\u4cff' || c == '\u212f' || c == '\u0587' ? false : Character.isLetter(c) || c == '_'));
        return bl;
    }

    private static boolean isLetter(char c) {
        return (c <= '\uf900' || c >= '\ufffe') && Character.isLetter(c) || c == '\u3007' || c >= '\u2180' && c <= '\u2182' || c >= '\u3021' && c <= '\u3029';
    }

    private static boolean isLetterOrDigit(char c) {
        return (c <= '\uf900' || c >= '\ufffe') && Character.isLetterOrDigit(c) || c == '\u3007' || c >= '\u2180' && c <= '\u2182' || c >= '\u3021' && c <= '\u3029';
    }

    private static boolean isNameStartChar(int n) {
        if (n <= 255) {
            return (chartype[n] & 0x40) != 0;
        }
        return 248 <= n && n <= 767 || 880 <= n && n <= 893 || 895 <= n && n <= 8191 || 8204 <= n && n <= 8205 || 8304 <= n && n <= 8591 || 11264 <= n && n <= 12271 || 12289 <= n && n <= 55295 || 63744 <= n && n <= 64975 || 65008 <= n && n <= 65533 || 65536 <= n && n <= 983039;
    }

    public static boolean isNameChar(int n) {
        if (n <= 255) {
            return (chartype[n] & 0x20) != 0;
        }
        return XMLUtil.isNameStartChar(n) || 768 <= n && n <= 879 || 8255 <= n && n <= 8256;
    }

    public static void validateName(String string) throws DOMException {
        int n;
        if (oldBehavior) {
            char c = string.charAt(0);
            if (!XMLUtil.isLetter(c) && c != '_' && c != ':') {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, 1));
            }
            int n2 = string.length();
            for (int i = 1; i < n2; ++i) {
                char c2 = string.charAt(i);
                if (XMLUtil.isLetterOrDigit(c2) || c2 == '_' || c2 == ':' || c2 == '-' || c2 == '.') continue;
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(i, i + 1));
            }
            return;
        }
        int n3 = Character.codePointAt(string, 0);
        int n4 = Character.charCount(n3);
        if (!XMLUtil.isNameStartChar(n3)) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, n4));
        }
        int n5 = string.length();
        for (int i = n4; i < n5; i += n) {
            int n6 = Character.codePointAt(string, i);
            n = Character.charCount(n6);
            if (XMLUtil.isNameChar(n6)) continue;
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(i, i + n));
        }
    }

    public static void validateQualifiedName(String string, String string2) throws DOMException {
        int n;
        if (oldBehavior) {
            int n2 = string2.length();
            if (n2 == 0) {
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, "");
            }
            if (string2.equals("xmlns") && !string.equals("http://www.w3.org/2000/xmlns/")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
            }
            char c = string2.charAt(0);
            if (!XMLUtil.isLetter(c) && c != '_') {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(0, 1));
            }
            char c2 = c;
            String string3 = "";
            boolean bl = false;
            for (int i = 1; i < n2; ++i) {
                c2 = string2.charAt(i);
                if (c2 != ':') continue;
                if (!bl) {
                    bl = true;
                    string3 = string2.substring(0, i);
                    continue;
                }
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            if (c2 == ':') {
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            if (bl) {
                if (string == null || string.equals("")) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string3.equals("xml") && (string == null || !string.equals("http://www.w3.org/XML/1998/namespace"))) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string3.equals("xmlns") && (string == null || !string.equals("http://www.w3.org/2000/xmlns/"))) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string3.equals("xmlns")) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
            } else if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string2.equals("xmlns")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
            }
            return;
        }
        if (string2 == null) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        int n3 = string2.length();
        if (n3 == 0) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        if (string2.equals("xmlns") && !string.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
        int n4 = Character.codePointAt(string2, 0);
        int n5 = Character.charCount(n4);
        if (!XMLUtil.isNameStartChar(n4) || n4 == 58) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(0, n5));
        }
        int n6 = -1;
        String string4 = "";
        boolean bl = false;
        for (int i = n5; i < n3; i += n) {
            n6 = Character.codePointAt(string2, i);
            n = Character.charCount(n6);
            if (!XMLUtil.isNameChar(n6)) {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(i, i + n));
            }
            if (n6 != 58) continue;
            if (!bl) {
                bl = true;
                string4 = string2.substring(0, i);
                continue;
            }
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (n6 == 58) {
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (bl) {
            if (string == null || string.equals("")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string4.equals("xml") && (string == null || !string.equals("http://www.w3.org/XML/1998/namespace"))) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string4.equals("xmlns") && (string == null || !string.equals("http://www.w3.org/2000/xmlns/"))) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string4.equals("xmlns")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
        } else if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string2.equals("xmlns")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
    }

    public static void validateQualifiedNameOld(String string, String string2) throws DOMException {
        int n = string2.length();
        if (n == 0) {
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, "");
        }
        if (string2.equals("xmlns") && !string.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
        char c = string2.charAt(0);
        if (!XMLUtil.isLetter(c) && c != '_') {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(0, 1));
        }
        char c2 = c;
        String string3 = "";
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            c2 = string2.charAt(i);
            if (c2 != ':') continue;
            if (!bl) {
                bl = true;
                string3 = string2.substring(0, i);
                continue;
            }
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (c2 == ':') {
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (bl) {
            if (string == null) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
            }
            if (string3.equals("xml") && (string == null || !string.equals("http://www.w3.org/XML/1998/namespace"))) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
            }
            if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string3.equals("xmlns")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
            }
        } else if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string2.equals("xmlns")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
    }

    public static void validateQualifiedNameTemp(String string, String string2) throws DOMException {
        int n;
        if (oldBehavior) {
            int n2 = string2.length();
            if (n2 == 0) {
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, "");
            }
            if (string2.equals("xmlns") && !string.equals("http://www.w3.org/2000/xmlns/")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
            }
            char c = string2.charAt(0);
            if (!XMLUtil.isLetter(c) && c != '_') {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(0, 1));
            }
            char c2 = c;
            String string3 = "";
            boolean bl = false;
            for (int i = 1; i < n2; ++i) {
                c2 = string2.charAt(i);
                if (c2 != ':') continue;
                if (!bl) {
                    bl = true;
                    string3 = string2.substring(0, i);
                    continue;
                }
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            if (c2 == ':') {
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            if (bl) {
                if (string == null || string.equals("")) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string3.equals("xml") && (string == null || !string.equals("http://www.w3.org/XML/1998/namespace"))) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string3.equals("xmlns") && (string == null || !string.equals("http://www.w3.org/2000/xmlns/"))) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
                if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string3.equals("xmlns")) {
                    throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string3);
                }
            } else if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string2.equals("xmlns")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
            }
            return;
        }
        if (string2 == null) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        int n3 = string2.length();
        if (n3 == 0) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        if (string2.equals("xmlns") && !string.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
        int n4 = Character.codePointAt(string2, 0);
        int n5 = Character.charCount(n4);
        if (!XMLUtil.isNameStartChar(n4) || n4 == 58) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(0, n5));
        }
        int n6 = -1;
        String string4 = "";
        boolean bl = false;
        for (int i = n5; i < n3; i += n) {
            n6 = Character.codePointAt(string2, i);
            n = Character.charCount(n6);
            if (!XMLUtil.isNameChar(n6)) {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string2.substring(i, i + n));
            }
            if (n6 != 58) continue;
            if (!bl) {
                bl = true;
                string4 = string2.substring(0, i);
                continue;
            }
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (n6 == 58) {
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (bl) {
            if (string == null) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string4.equals("xml") && (string == null || !string.equals("http://www.w3.org/XML/1998/namespace"))) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string4.equals("xmlns") && (string == null || !string.equals("http://www.w3.org/2000/xmlns/"))) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
            if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string4.equals("xmlns")) {
                throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string4);
            }
        } else if (string != null && string.equals("http://www.w3.org/2000/xmlns/") && !string2.equals("xmlns")) {
            throw new XMLDOMException(14, 21016, XMLDocument.defErr, string, string2);
        }
    }

    public static void validateQualifiedName(String string) throws DOMException {
        int n;
        if (oldBehavior) {
            int n2 = string.length();
            char c = string.charAt(0);
            if (!XMLUtil.isLetter(c) && c != '_') {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, 1));
            }
            char c2 = c;
            boolean bl = false;
            for (int i = 1; i < n2; ++i) {
                c2 = string.charAt(i);
                if (c2 != ':') continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            if (c2 == ':') {
                throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
            }
            return;
        }
        if (string == null) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        int n3 = string.length();
        if (n3 == 0) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, "");
        }
        int n4 = Character.codePointAt(string, 0);
        int n5 = Character.charCount(n4);
        if (!XMLUtil.isNameStartChar(n4) || n4 == 58) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, n5));
        }
        int n6 = -1;
        boolean bl = false;
        for (int i = n5; i < n3; i += n) {
            n6 = Character.codePointAt(string, i);
            n = Character.charCount(n6);
            if (!XMLUtil.isNameChar(n6)) {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(i, i + n));
            }
            if (n6 != 58) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
        if (n6 == 58) {
            throw new XMLDOMException(14, 21007, XMLDocument.defErr, ":");
        }
    }

    public static void validatePrefix(String string) throws DOMException {
        int n;
        if (oldBehavior) {
            char c = string.charAt(0);
            if (!XMLUtil.isLetter(c) && c != '_') {
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, 1));
            }
            int n2 = string.length();
            for (int i = 1; i < n2; ++i) {
                char c2 = string.charAt(i);
                if (XMLUtil.isLetterOrDigit(c2) || c2 == '_' || c2 == '-' || c2 == '.') continue;
                throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(i, i + 1));
            }
            return;
        }
        int n3 = Character.codePointAt(string, 0);
        int n4 = Character.charCount(n3);
        if (!XMLUtil.isNameStartChar(n3) || n3 == 58) {
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(0, n4));
        }
        int n5 = string.length();
        for (int i = n4; i < n5; i += n) {
            int n6 = Character.codePointAt(string, i);
            n = Character.charCount(n6);
            if (XMLUtil.isNameChar(n6) && n6 != 58) continue;
            throw new XMLDOMException(5, 21007, XMLDocument.defErr, string.substring(i, i + n));
        }
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n).intern();
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return string.substring(n + 1, string.length()).intern();
    }

    public static String getRawPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getRawLocalName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public static String nodeTypeToString(int n) {
        switch (n) {
            case 1: {
                return "element";
            }
            case 11: {
                return "document fragment";
            }
            case 3: {
                return "text";
            }
            case 4: {
                return "cdata section";
            }
            case 8: {
                return "comment";
            }
            case 7: {
                return "processing instruction";
            }
            case 2: {
                return "attribute";
            }
            case 5: {
                return "entity reference";
            }
            case 6: {
                return "entity";
            }
            case 13: {
                return "element declaration";
            }
            case 14: {
                return "attribute declaration";
            }
            case 10: {
                return "dtd";
            }
            case 9: {
                return "document";
            }
        }
        return "";
    }

    public static char[] mappingChars(char c, HashMap hashMap) {
        String string = (String)hashMap.get(new Character(c));
        if (string != null) {
            return string.toCharArray();
        }
        char[] cArray = new char[]{c};
        return cArray;
    }

    public static boolean isAbsoluteURI(String string) {
        int n = string.length();
        if (n > 0 && !Character.isLetter(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return true;
            }
            if (c == '/' || c == '#') {
                return false;
            }
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') continue;
            return false;
        }
        return false;
    }

    public static String appendRelativeURI(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        if (n + 1 < string.length() && string.charAt(n + 1) != '/') {
            return null;
        }
        int n2 = -1;
        boolean bl = true;
        if (string2.startsWith("//")) {
            n2 = string.indexOf("//");
            string3 = n2 > 0 ? string.substring(0, n2) : string;
            bl = false;
        } else if (string2.startsWith("/")) {
            n2 = string.indexOf("//");
            string3 = n2 > 0 ? ((n2 = string.indexOf(47, n2 + 2)) > 0 ? string.substring(0, n2) : string) : string;
            bl = false;
        } else {
            n2 = string.lastIndexOf(47);
            string3 = string.substring(0, n2 + 1);
        }
        string3 = string3 + string2;
        n2 = string2.indexOf(47);
        if (!(bl && n2 >= 0 || string2.equals(".") || string2.equals(".."))) {
            return string3;
        }
        int n3 = string2.indexOf(63);
        if (n3 > 0 && n2 > n3) {
            return string3;
        }
        n3 = string2.indexOf(35);
        if (n3 > 0 && n2 > n3) {
            return string3;
        }
        char[] cArray = string3.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        n2 = 0;
        FastVector fastVector = new FastVector();
        while (n2 < cArray.length) {
            if (n2 - 1 >= 0 && cArray[n2 - 1] != '.' && (n2 + 1 < cArray.length && cArray[n2] == '.' && cArray[n2 + 1] == '/' || n2 + 1 == cArray.length && cArray[n2] == '.')) {
                n2 += 2;
                continue;
            }
            if (n2 + 2 < cArray.length && cArray[n2] == '.' && cArray[n2 + 1] == '.' && cArray[n2 + 2] == '/' || n2 + 2 == cArray.length && cArray[n2] == '.' && cArray[n2 + 1] == '.') {
                if (fastVector.size() > 0) {
                    stringBuffer.delete((Integer)fastVector.popElement() + 1, n2);
                    n2 += 3;
                    continue;
                }
            } else if (n2 - 2 >= 0 && cArray[n2 - 1] == '/' && cArray[n2 - 2] != '/' && cArray[n2] != '/') {
                fastVector.addElement(new Integer(n2 - 1));
            }
            stringBuffer.append(cArray[n2++]);
        }
        return stringBuffer.toString();
    }

    public static boolean checkYesNo(String string, XMLError xMLError) throws XSLException {
        if (string.intern() == "yes") {
            return true;
        }
        if (string.intern() == "no") {
            return false;
        }
        xMLError.error2(1069, 1, "yes", "no");
        throw new XSLException(xMLError, 0);
    }

    public static byte[] parseBase64Binary(String string) {
        char c = ' ';
        char c2 = ' ';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            c2 = c;
            c = string.charAt(i);
            if (c2 == '\r' && c == '\n') {
                ++i;
                continue;
            }
            if (c == '\t' || c == ' ') continue;
            stringBuffer.append(c);
        }
        String string2 = stringBuffer.toString();
        if (string2.length() % 4 != 0) {
            return null;
        }
        int n2 = string2.length() / 4 * 3;
        if (string2.endsWith("==")) {
            n2 -= 2;
        } else if (string2.endsWith("=")) {
            --n2;
        }
        byte[] byArray = new byte[n2];
        for (int i = string2.length() / 4 - 1; i >= 0; --i) {
            int n3 = (base64Chars.indexOf(string2.charAt(i * 4)) & 0x3F) << 18 | (base64Chars.indexOf(string2.charAt(i * 4 + 1)) & 0x3F) << 12 | (base64Chars.indexOf(string2.charAt(i * 4 + 2)) & 0x3F) << 6 | base64Chars.indexOf(string2.charAt(i * 4 + 3)) & 0x3F;
            byArray[i * 3] = (byte)(n3 >> 16 & 0xFF);
            if (string2.charAt(i * 4 + 2) == '=') continue;
            byArray[i * 3 + 1] = (byte)(n3 >> 8 & 0xFF);
            if (string2.charAt(i * 4 + 3) == '=') continue;
            byArray[i * 3 + 2] = (byte)(n3 & 0xFF);
        }
        return byArray;
    }

    public static String printBase64Binary(byte[] byArray) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (n = 0; n < byArray.length - byArray.length % 3; n += 3) {
            by = (byte)(byArray[n] >> 2 & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n + 1] & 0xF) << 2) + (byArray[n + 2] >> 6 & 3));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(byArray[n + 2] & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
        }
        if (byArray.length % 3 != 0) {
            if (byArray.length % 3 == 2) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n + 1] & 0xF) << 2);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("=");
            } else if (byArray.length % 3 == 1) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n] & 3) << 4);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("==");
            }
        }
        return stringBuffer.toString();
    }

    private static final boolean isOracleProperty(String string) {
        if (string.startsWith("oracle.xml.")) {
            return true;
        }
        return string.startsWith("oracle.xdkjava.");
    }

    public static final String getProperty(final String string) {
        if (!XMLUtil.isOracleProperty(string)) {
            String string2 = System.getProperty(string);
            return string2;
        }
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string2 = System.getProperty(string);
                    return string2;
                }
            });
            String string3 = (String)t;
            return string3;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public static final String getProperty(final String string, final String string2) {
        if (!XMLUtil.isOracleProperty(string)) {
            String string3 = System.getProperty(string, string2);
            return string3;
        }
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string3 = System.getProperty(string, string2);
                    return string3;
                }
            });
            String string4 = (String)t;
            return string4;
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
    }

    public static int compareDocOrder(Node node, Node node2) {
        short s = node.compareDocumentPosition(node2);
        if ((s & 4) == 4 || (s & 0x10) == 16) {
            return -1;
        }
        if ((s & 2) == 2 || (s & 8) == 8) {
            return 1;
        }
        return 0;
    }

    public static XMLDocument getXMLDocumentFromDoc(Node node) {
        FDOMInfosetReader fDOMInfosetReader = new FDOMInfosetReader(node);
        XMLDOMImplementation xMLDOMImplementation = new XMLDOMImplementation();
        xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.SCALABLE_DOM", true);
        XMLDocument xMLDocument = (XMLDocument)xMLDOMImplementation.createDocument(fDOMInfosetReader);
        return xMLDocument;
    }

    public static XMLNode getXMLNodeFromNode(Node node) {
        if (node.getNodeType() == 9) {
            return XMLUtil.getXMLDocumentFromDoc(node);
        }
        FDOMInfosetReader fDOMInfosetReader = new FDOMInfosetReader(node.getOwnerDocument());
        XMLDOMImplementation xMLDOMImplementation = new XMLDOMImplementation();
        xMLDOMImplementation.setAttribute("oracle.xml.parser.XMLDocument.SCALABLE_DOM", true);
        XMLDocument xMLDocument = (XMLDocument)xMLDOMImplementation.createDocument(fDOMInfosetReader);
        XMLNode xMLNode = xMLDocument.getXMLNodeFromNode(node);
        return xMLNode;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            XMLUtil.chartype[i] = 0;
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                XMLUtil.chartype[i] = 1;
            }
            if (Character.isLetter(c)) {
                int n = i;
                chartype[n] = chartype[n] | 4;
            }
            if (Character.isDigit(c)) {
                int n = i;
                chartype[n] = chartype[n] | 2;
            }
            if (oldBehavior) continue;
            if (c == ':' || c == '_' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '\u00c0' <= c && c <= '\u00d6' || '\u00d8' <= c && c <= '\u00f6' || '\u00f8' <= c && c <= '\u00ff') {
                int n = i;
                chartype[n] = chartype[n] | 0x40;
                int n2 = i;
                chartype[n2] = chartype[n2] | 0x20;
            }
            if (c != '-' && c != '.' && c != '\u00b7' && ('0' > c || c > '9')) continue;
            int n = i;
            chartype[n] = chartype[n] | 0x20;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        encodingMap = new Hashtable(600);
        encodingMap116 = new Hashtable(600);
        encodingMap.put("ASCII", "ASCII");
        encodingMap.put("US-ASCII", "ASCII");
        encodingMap.put("ANSI_X3.4-1986", "ASCII");
        encodingMap.put("US", "ASCII");
        encodingMap.put("CP367", "ASCII");
        encodingMap.put("CSASCII", "ASCII");
        encodingMap.put("IBM367", "ASCII");
        encodingMap.put("ISO-IR-6", "ASCII");
        encodingMap.put("ISO_646.IRV:1991", "ASCII");
        encodingMap.put("ISO646-US", "ASCII");
        encodingMap.put("ANSI_X3.4-1968", "ASCII");
        encodingMap.put("ISO-8859-1", "ISO8859_1");
        encodingMap.put("ISO_8859-1", "ISO8859_1");
        encodingMap.put("ISO_8859-1:1987", "ISO8859_1");
        encodingMap.put("ISO-IR-100", "ISO8859_1");
        encodingMap.put("LATIN1", "ISO8859_1");
        encodingMap.put("L1", "ISO8859_1");
        encodingMap.put("IBM819", "ISO8859_1");
        encodingMap.put("CP819", "ISO8859_1");
        encodingMap.put("CSISOLATIN1", "ISO8859_1");
        encodingMap.put("ISO-8859-2", "ISO8859_2");
        encodingMap.put("ISO_8859-2", "ISO8859_2");
        encodingMap.put("ISO_8859-2:1987", "ISO8859_2");
        encodingMap.put("ISO8859-2", "ISO8859_2");
        encodingMap.put("ISO-IR-101", "ISO8859_2");
        encodingMap.put("LATIN2", "ISO8859_2");
        encodingMap.put("L2", "ISO8859_2");
        encodingMap.put("CSISOLATIN2", "ISO8859_2");
        encodingMap.put("ISO-8859-3", "ISO8859_3");
        encodingMap.put("ISO_8859-3", "ISO8859_3");
        encodingMap.put("ISO_8859-3:1988", "ISO8859_3");
        encodingMap.put("ISO-IR-109", "ISO8859_3");
        encodingMap.put("LATIN3", "ISO8859_3");
        encodingMap.put("L3", "ISO8859_3");
        encodingMap.put("CSISOLATIN3", "ISO8859_3");
        encodingMap.put("ISO-8859-4", "ISO8859_4");
        encodingMap.put("ISO_8859-4", "ISO8859_4");
        encodingMap.put("ISO_8859-4:1988", "ISO8859_4");
        encodingMap.put("ISO-IR-110", "ISO8859_4");
        encodingMap.put("LATIN4", "ISO8859_4");
        encodingMap.put("L4", "ISO8859_4");
        encodingMap.put("CSISOLATIN4", "ISO8859_4");
        encodingMap.put("ISO-8859-5", "ISO8859_5");
        encodingMap.put("ISO_8859-5", "ISO8859_5");
        encodingMap.put("ISO_8859-5:1988", "ISO8859_5");
        encodingMap.put("ISO-IR-144", "ISO8859_5");
        encodingMap.put("CYRILLIC", "ISO8859_5");
        encodingMap.put("CSISOLATINCYRILLIC", "ISO8859_5");
        encodingMap.put("ISO-8859-6", "ISO8859_6");
        encodingMap.put("ISO_8859-6", "ISO8859_6");
        encodingMap.put("ISO_8859-6:1987", "ISO8859_6");
        encodingMap.put("ISO-IR-127", "ISO8859_6");
        encodingMap.put("ECMA-114", "ISO8859_6");
        encodingMap.put("ARABIC", "ISO8859_6");
        encodingMap.put("ASMO-708", "ISO8859_6");
        encodingMap.put("CSISOLATINARABIC", "ISO8859_6");
        encodingMap.put("ISO-8859-7", "ISO8859_7");
        encodingMap.put("ISO_8859-7", "ISO8859_7");
        encodingMap.put("ISO_8859-7:1987", "ISO8859_7");
        encodingMap.put("ISO-IR-126", "ISO8859_7");
        encodingMap.put("ECMA-118", "ISO8859_7");
        encodingMap.put("ELOT_928", "ISO8859_7");
        encodingMap.put("GREEK", "ISO8859_7");
        encodingMap.put("GREEK8", "ISO8859_7");
        encodingMap.put("CSISOLATINGREEK", "ISO8859_7");
        encodingMap.put("ISO-8859-8", "ISO8859_8");
        encodingMap.put("ISO_8859-8", "ISO8859_8");
        encodingMap.put("ISO_8859-8:1988", "ISO8859_8");
        encodingMap.put("ISO-IR-138", "ISO8859_8");
        encodingMap.put("HEBREW", "ISO8859_8");
        encodingMap.put("VISUAL", "ISO8859_8");
        encodingMap.put("ISO-8859-8 VISUAL", "ISO8859_8");
        encodingMap.put("CSISOLATINHEBREW", "ISO8859_8");
        encodingMap.put("ISO-8859-9", "ISO8859_9");
        encodingMap.put("ISO_8859-9", "ISO8859_9");
        encodingMap.put("ISO_8859-9:1989", "ISO8859_9");
        encodingMap.put("ISO-IR-148", "ISO8859_9");
        encodingMap.put("LATIN5", "ISO8859_9");
        encodingMap.put("L5", "ISO8859_9");
        encodingMap.put("CSISOLATIN5", "ISO8859_9");
        encodingMap.put("BIG5", "Big5");
        encodingMap.put("CSBIG5", "Big5");
        encodingMap.put("X-X-BIG5", "Big5");
        encodingMap.put("EBCDIC", "Cp037");
        encodingMap.put("EBCDIC-CP-US", "Cp037");
        encodingMap.put("EBCDIC-CP-CA", "Cp037");
        encodingMap.put("EBCDIC-CP-NL", "Cp037");
        encodingMap.put("EBCDIC-CP-WT", "Cp037");
        encodingMap.put("IBM037", "Cp037");
        encodingMap.put("CP037", "Cp037");
        encodingMap.put("CSIBM037", "Cp037");
        encodingMap.put("IBM273", "Cp273");
        encodingMap.put("CP273", "Cp273");
        encodingMap.put("CSIBM273", "Cp273");
        encodingMap.put("EBCDIC-CP-DK", "Cp277");
        encodingMap.put("EBCDIC-CP-NO", "Cp277");
        encodingMap.put("IBM277", "Cp277");
        encodingMap.put("CSIBM277", "Cp277");
        encodingMap.put("EBCDIC-CP-FI", "Cp278");
        encodingMap.put("EBCDIC-CP-SE", "Cp278");
        encodingMap.put("IBM278", "Cp278");
        encodingMap.put("CP278", "Cp278");
        encodingMap.put("CSIBM278", "Cp278");
        encodingMap.put("EBCDIC-CP-IT", "Cp280");
        encodingMap.put("IBM280", "Cp280");
        encodingMap.put("CP280", "Cp280");
        encodingMap.put("CSIBM280", "Cp280");
        encodingMap.put("EBCDIC-CP-ES", "Cp284");
        encodingMap.put("IBM284", "Cp284");
        encodingMap.put("CP284", "Cp284");
        encodingMap.put("CSIBM284", "Cp284");
        encodingMap.put("EBCDIC-CP-GB", "Cp285");
        encodingMap.put("IBM285", "Cp285");
        encodingMap.put("CP285", "Cp285");
        encodingMap.put("CSIBM285", "Cp285");
        encodingMap.put("EBCDIC-CP-FR", "Cp297");
        encodingMap.put("IBM297", "Cp297");
        encodingMap.put("CP297", "Cp297");
        encodingMap.put("CSIBM297", "Cp297");
        encodingMap.put("EBCDIC-CP-AR1", "Cp420");
        encodingMap.put("IBM420", "Cp420");
        encodingMap.put("CP420", "Cp420");
        encodingMap.put("CSIBM420", "Cp420");
        encodingMap.put("EBCDIC-CP-HE", "Cp424");
        encodingMap.put("IBM424", "Cp424");
        encodingMap.put("CP424", "Cp424");
        encodingMap.put("CSIBM424", "Cp424");
        encodingMap.put("IBM437", "Cp437");
        encodingMap.put("CP437", "Cp437");
        encodingMap.put("437", "Cp437");
        encodingMap.put("CSPC8CODEPAGE437", "Cp437");
        encodingMap.put("EBCDIC-CP-BE", "Cp500");
        encodingMap.put("EBCDIC-CP-CH", "Cp500");
        encodingMap.put("IBM500", "Cp500");
        encodingMap.put("CP500", "Cp500");
        encodingMap.put("CSIBM500", "Cp500");
        encodingMap.put("IBM775", "Cp775");
        encodingMap.put("CP775", "Cp775");
        encodingMap.put("CSPC775BALTIC", "Cp775");
        encodingMap.put("IBM850", "Cp850");
        encodingMap.put("CP850", "Cp850");
        encodingMap.put("850", "Cp850");
        encodingMap.put("CSPC850MULTILINGUAL", "Cp850");
        encodingMap.put("IBM852", "Cp852");
        encodingMap.put("852", "Cp852");
        encodingMap.put("CP852", "Cp852");
        encodingMap.put("CSPCP852", "Cp852");
        encodingMap.put("IBM855", "Cp855");
        encodingMap.put("CP855", "Cp855");
        encodingMap.put("855", "Cp855");
        encodingMap.put("CSIBM855", "Cp855");
        encodingMap.put("IBM857", "Cp857");
        encodingMap.put("CP857", "Cp857");
        encodingMap.put("857", "Cp857");
        encodingMap.put("CSIBM857", "Cp857");
        encodingMap.put("IBM860", "Cp860");
        encodingMap.put("CP860", "Cp860");
        encodingMap.put("860", "Cp860");
        encodingMap.put("CSIBM860", "Cp860");
        encodingMap.put("IBM861", "Cp861");
        encodingMap.put("CP861", "Cp861");
        encodingMap.put("861", "Cp861");
        encodingMap.put("CSIBM861", "Cp861");
        encodingMap.put("CP-IS", "Cp861");
        encodingMap.put("IBM862", "Cp862");
        encodingMap.put("CP862", "Cp862");
        encodingMap.put("862", "Cp862");
        encodingMap.put("CSPC862LATINHEBREW", "Cp862");
        encodingMap.put("IBM863", "Cp863");
        encodingMap.put("CP863", "Cp863");
        encodingMap.put("863", "Cp863");
        encodingMap.put("CSIBM863", "Cp863");
        encodingMap.put("IBM864", "Cp864");
        encodingMap.put("CP864", "Cp864");
        encodingMap.put("CSIBM864", "Cp864");
        encodingMap.put("IBM865", "Cp865");
        encodingMap.put("CP865", "Cp865");
        encodingMap.put("865", "Cp865");
        encodingMap.put("CSIBM865", "Cp865");
        encodingMap.put("IBM866", "Cp866");
        encodingMap.put("866", "Cp866");
        encodingMap.put("CP866", "Cp866");
        encodingMap.put("CSIBM866", "Cp866");
        encodingMap.put("IBM868", "Cp868");
        encodingMap.put("CP868", "Cp868");
        encodingMap.put("CP-AR", "Cp868");
        encodingMap.put("CSIBM868", "Cp868");
        encodingMap.put("IBM869", "Cp869");
        encodingMap.put("CP869", "Cp869");
        encodingMap.put("869", "Cp869");
        encodingMap.put("CP-GR", "Cp869");
        encodingMap.put("CSIBM869", "Cp869");
        encodingMap.put("EBCDIC-CP-ROECE", "Cp870");
        encodingMap.put("EBCDIC-CP-YU", "Cp870");
        encodingMap.put("IBM870", "Cp870");
        encodingMap.put("CP870", "Cp870");
        encodingMap.put("CSIBM870", "Cp870");
        encodingMap.put("EBCDIC-CP-IS", "Cp871");
        encodingMap.put("IBM871", "Cp871");
        encodingMap.put("CP871", "Cp871");
        encodingMap.put("CSIBM871", "Cp871");
        encodingMap.put("EBCDIC-CP-AR2", "Cp918");
        encodingMap.put("IBM918", "Cp918");
        encodingMap.put("CP918", "Cp918");
        encodingMap.put("CSIBM918", "Cp918");
        encodingMap.put("IBM1026", "Cp1026");
        encodingMap.put("CP1026", "Cp1026");
        encodingMap.put("CSIBM1026", "Cp1026");
        encodingMap.put("WINDOWS-1250", "Cp1250");
        encodingMap.put("X-CP1250", "Cp1250");
        encodingMap.put("WINDOWS-1251", "Cp1251");
        encodingMap.put("X-CP1251", "Cp1251");
        encodingMap.put("CP1047", "Cp1047");
        encodingMap.put("IBM1047", "Cp1047");
        encodingMap.put("CP1047", "Cp1047");
        encodingMap.put("IBM1047", "Cp1047");
        encodingMap.put("WINDOWS-1252", "Cp1252");
        encodingMap.put("WINDOWS-1253", "Cp1253");
        encodingMap.put("WINDOWS-1254", "Cp1254");
        encodingMap.put("WINDOWS-1255", "Cp1255");
        encodingMap.put("LOGICAL", "Cp1255");
        encodingMap.put("WINDOWS-1256", "Cp1256");
        encodingMap.put("WINDOWS-1257", "Cp1257");
        encodingMap.put("WINDOWS-1258", "Cp1258");
        encodingMap.put("GB2312", "EUC_CN");
        encodingMap.put("CHINESE", "EUC_CN");
        encodingMap.put("CSGB2312", "EUC_CN");
        encodingMap.put("CSISO58GB231280", "EUC_CN");
        encodingMap.put("GB_2312-80", "EUC_CN");
        encodingMap.put("ISO-IR-58", "EUC_CN");
        encodingMap.put("EUC-CN", "EUC_CN");
        encodingMap.put("EUC-JP", "EUC_JP");
        encodingMap.put("CSEUCPKDFMTJAPANESE", "EUC_JP");
        encodingMap.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC_JP");
        encodingMap.put("X-EUC", "EUC_JP");
        encodingMap.put("X-EUC-JP", "EUC_JP");
        encodingMap.put("KS_C_5601-1987", "EUC_KR");
        encodingMap.put("EUC-KR", "EUC_KR");
        encodingMap.put("KOREAN", "EUC_KR");
        encodingMap.put("KS_C_5601", "EUC_KR");
        encodingMap.put("CSKSC56011987", "EUC_KR");
        encodingMap.put("CSEUC-KR", "EUC_KR");
        encodingMap.put("EUC-TW", "EUC_TW");
        encodingMap.put("GBK", "GBK");
        encodingMap.put("ISO-2022-CN", "ISO2022CN");
        encodingMap.put("CSISO2022CN", "ISO2022CN");
        encodingMap.put("ISO-2022-KR", "ISO2022KR");
        encodingMap.put("CSISO2022KR", "ISO2022KR");
        encodingMap.put("ISO-2022-JP", "ISO2022JP");
        encodingMap.put("CSISO2022JP", "ISO2022JP");
        encodingMap.put("KOI8-R", "KOI8_R");
        encodingMap.put("CSKOI8-R", "KOI8_R");
        encodingMap.put("KOI", "KOI8_R");
        encodingMap.put("WINDOWS-874", "MS874");
        encodingMap.put("TIS-620", "TIS620");
        encodingMap.put("SHIFT_JIS", "MS932");
        encodingMap.put("MS_KANJI", "MS932");
        encodingMap.put("X-MS-CP932", "MS932");
        encodingMap.put("X-SJIS", "MS932");
        encodingMap.put("CSSHIFTJIS", "MS932");
        encodingMap.put("CSWINDOWS31J", "MS932");
        encodingMap.put("WINDOWS-949", "MS949");
        encodingMap.put("WINDOWS-950", "MS950");
        encodingMap.put("UTF-8", "UTF8");
        encodingMap.put("UNICODE-1-1-UTF-8", "UTF8");
        encodingMap.put("UNICODE-2-0-UTF-8", "UTF8");
        encodingMap.put("X-UNICODE-2-0-UTF-8", "UTF8");
        encodingMap.put("JUTF8", "UTF8");
        encodingMap.put("IBM00858", "Cp858");
        encodingMap.put("CCSID00858", "Cp858");
        encodingMap.put("CP00858", "Cp858");
        encodingMap.put("PC-MULTILINGUAL-850+EURO", "Cp858");
        encodingMap.put("IBM00924", "Cp924");
        encodingMap.put("CCSID00924", "Cp924");
        encodingMap.put("CP00924", "Cp924");
        encodingMap.put("EBCDIC-LATIN9--EURO", "Cp924");
        encodingMap.put("IBM01140", "Cp1140");
        encodingMap.put("CCSID01140", "Cp1140");
        encodingMap.put("CP01140", "Cp1140");
        encodingMap.put("EBCDIC-US-37+EURO", "Cp1140");
        encodingMap.put("IBM01141", "Cp1141");
        encodingMap.put("CCSID01141", "Cp1141");
        encodingMap.put("CP01141", "Cp1141");
        encodingMap.put("EBCDIC-DE-273+EURO", "Cp1141");
        encodingMap.put("IBM01142", "Cp1142");
        encodingMap.put("CCSID01142", "Cp1142");
        encodingMap.put("CP01142", "Cp1142");
        encodingMap.put("EBCDIC-DK-277+EURO", "Cp1142");
        encodingMap.put("EBCDIC-NO-277+EURO", "Cp1142");
        encodingMap.put("IBM01143", "Cp1143");
        encodingMap.put("CCSID01143", "Cp1143");
        encodingMap.put("CP01143", "Cp1143");
        encodingMap.put("EBCDIC-FI-278+EURO", "Cp1143");
        encodingMap.put("EBCDIC-SE-278+EURO", "Cp1143");
        encodingMap.put("IBM01144", "Cp1144");
        encodingMap.put("CCSID01144", "Cp1144");
        encodingMap.put("CP01144", "Cp1144");
        encodingMap.put("EBCDIC-IT-280+EURO", "Cp1144");
        encodingMap.put("IBM01145", "Cp1145");
        encodingMap.put("CCSID01145", "Cp1145");
        encodingMap.put("CP01145", "Cp1145");
        encodingMap.put("EBCDIC-ES-284+EURO", "Cp1145");
        encodingMap.put("IBM01146", "Cp1146");
        encodingMap.put("CCSID01146", "Cp1146");
        encodingMap.put("CP01146", "Cp1146");
        encodingMap.put("EBCDIC-GB-285+EURO", "Cp1146");
        encodingMap.put("IBM01147", "Cp1147");
        encodingMap.put("CCSID01147", "Cp1147");
        encodingMap.put("CP01147", "Cp1147");
        encodingMap.put("EBCDIC-FR-297+EURO", "Cp1147");
        encodingMap.put("IBM01148", "Cp1148");
        encodingMap.put("CP01148", "Cp1148");
        encodingMap.put("CCSID01148", "Cp1148");
        encodingMap.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
        encodingMap.put("IBM01149", "Cp1149");
        encodingMap.put("CCSID01149", "Cp1149");
        encodingMap.put("CP01149", "Cp1149");
        encodingMap.put("EBCDIC-IS-871+EURO", "Cp1149");
        encodingMap116.put("ISO-8859-1", "8859_1");
        encodingMap116.put("ISO_8859-1", "8859_1");
        encodingMap116.put("ISO_8859-1:1987", "8859_1");
        encodingMap116.put("ISO-ir-100", "8859_1");
        encodingMap116.put("LATIN1", "8859_1");
        encodingMap116.put("L1", "8859_1");
        encodingMap116.put("IBM819", "8859_1");
        encodingMap116.put("CP819", "8859_1");
        encodingMap116.put("CSISOLATIN1", "8859_1");
        encodingMap116.put("ISO-8859-2", "8859_2");
        encodingMap116.put("ISO_8859-2", "8859_2");
        encodingMap116.put("ISO_8859-2:1987", "8859_2");
        encodingMap116.put("8859-2", "8859_2");
        encodingMap116.put("ISO-IR-101", "8859_2");
        encodingMap116.put("LATIN2", "8859_2");
        encodingMap116.put("L2", "8859_2");
        encodingMap116.put("CSISOLATIN2", "8859_2");
        encodingMap116.put("ISO-8859-3", "8859_3");
        encodingMap116.put("ISO_8859-3", "8859_3");
        encodingMap116.put("ISO_8859-3:1988", "8859_3");
        encodingMap116.put("ISO-IR-109", "8859_3");
        encodingMap116.put("LATIN3", "8859_3");
        encodingMap116.put("L3", "8859_3");
        encodingMap116.put("CSISOLATIN3", "8859_3");
        encodingMap116.put("ISO-8859-4", "8859_4");
        encodingMap116.put("ISO_8859-4", "8859_4");
        encodingMap116.put("ISO_8859-4:1988", "8859_4");
        encodingMap116.put("ISO-IR-110", "8859_4");
        encodingMap116.put("LATIN4", "8859_4");
        encodingMap116.put("L4", "8859_4");
        encodingMap116.put("CSISOLATIN4", "8859_4");
        encodingMap116.put("ISO-8859-5", "8859_5");
        encodingMap116.put("ISO_8859-5", "8859_5");
        encodingMap116.put("ISO_8859-5:1988", "8859_5");
        encodingMap116.put("ISO-IR-144", "8859_5");
        encodingMap116.put("CYRILLIC", "8859_5");
        encodingMap116.put("CSISOLATINCYRILLIC", "8859_5");
        encodingMap116.put("ISO-8859-6", "8859_6");
        encodingMap116.put("ISO_8859-6", "8859_6");
        encodingMap116.put("ISO_8859-6:1987", "8859_6");
        encodingMap116.put("ISO-IR-127", "8859_6");
        encodingMap116.put("ECMA-114", "8859_6");
        encodingMap116.put("ARABIC", "8859_6");
        encodingMap116.put("ASMO-708", "8859_6");
        encodingMap116.put("CSISOLATINARABIC", "8859_6");
        encodingMap116.put("ISO-8859-7", "8859_7");
        encodingMap116.put("ISO_8859-7", "8859_7");
        encodingMap116.put("ISO_8859-7:1987", "8859_7");
        encodingMap116.put("ISO-IR-126", "8859_7");
        encodingMap116.put("ECMA-118", "8859_7");
        encodingMap116.put("ELOT_928", "8859_7");
        encodingMap116.put("GREEK", "8859_7");
        encodingMap116.put("GREEK8", "8859_7");
        encodingMap116.put("CSISOLATINGREEK", "8859_7");
        encodingMap116.put("ISO-8859-8", "8859_8");
        encodingMap116.put("ISO_8859-8", "8859_8");
        encodingMap116.put("ISO_8859-8:1988", "8859_8");
        encodingMap116.put("ISO-IR-138", "8859_8");
        encodingMap116.put("HEBREW", "8859_8");
        encodingMap116.put("VISUAL", "8859_8");
        encodingMap116.put("ISO-8859-8 VISUAL", "8859_8");
        encodingMap116.put("CSISOLATINHEBREW", "8859_8");
        encodingMap116.put("ISO-8859-9", "8859_9");
        encodingMap116.put("ISO_8859-9", "8859_9");
        encodingMap116.put("ISO_8859-9:1989", "8859_9");
        encodingMap116.put("ISO-IR-148", "8859_9");
        encodingMap116.put("LATIN5", "8859_9");
        encodingMap116.put("L5", "8859_9");
        encodingMap116.put("CSISOLATIN5", "8859_9");
        encodingMap116.put("SHIFT_JIS", "SJIS");
        encodingMap116.put("MS_KANJI", "SJIS");
        encodingMap116.put("X-MS-CP932", "SJIS");
        encodingMap116.put("X-SJIS", "SJIS");
        encodingMap116.put("CSSHIFTJIS", "SJIS");
        encodingMap116.put("CSWINDOWS31J", "SJIS");
        encodingMap116.put("ISO-2022-JP", "JIS");
        encodingMap116.put("EUC-JP", "EUCJIS");
        encodingMap116.put("EUC-KR", "KSC5601");
    }
}

