/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print.ide;

import java.awt.Color;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.docking.Dockable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;

class Provider {
    Provider() {
    }

    protected final PrintProvider[] createProviders(Context context) {
        View view = context.getView();
        Node node = context.getNode();
        String name = null;
        if (view != null) {
            if (view instanceof Dockable) {
                name = ((Dockable)view).getTitleName();
            }
            if (name == null) {
                name = view.getTabName();
            }
        }
        if ((name == null || name.length() == 0) && node != null) {
            name = node.getShortLabel();
        }
        return PrintProvider.Factory.getFactory().createProviders(this.getEditor(view), view.getGUI(), name, this.getSelection(context));
    }

    protected final PrintProvider[] createProviders(Pageable pageable) {
        return PrintProvider.Factory.getFactory().createProviders(pageable);
    }

    protected final PrintProvider[] createProviders(Printable printable) {
        return PrintProvider.Factory.getFactory().createProviders(printable);
    }

    protected final Object[][] getSelection(Context context) {
        Element[] elements = context.getSelection();
        Object[][] selection = new Object[elements.length][2];
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            selection[i][0] = element instanceof Printable || element instanceof Pageable ? element : (element instanceof TextNode ? (Object)this.getText((TextNode)element) : element);
            selection[i][1] = element.getShortLabel();
        }
        return selection;
    }

    protected final Object[] getEditor(View view) {
        if (!(view instanceof CodeEditor)) {
            return null;
        }
        char[] text = null;
        int[] styles = null;
        Color[] colors = null;
        BasicEditorPane pane = ((CodeEditor)view).getFocusedEditorPane();
        Document d = pane.getDocument();
        try {
            String s = d.getText(0, d.getLength());
            text = new char[s.length()];
            for (int i = 0; i < text.length; ++i) {
                text[i] = s.charAt(i);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (d instanceof BasicDocument) {
            styles = new int[text.length];
            colors = new Color[text.length];
            BasicDocument document = (BasicDocument)d;
            DocumentRenderer renderer = document.getDocumentRenderer();
            StyleRegistry registry = EditorProperties.getProperties().getStyleRegistry();
            LineMap lineMap = document.getLineMap();
            int firstLine = lineMap.getLineFromOffset(0);
            int lastLine = lineMap.getLineFromOffset(d.getLength());
            document.readLock();
            StyledFragmentsList fragments = renderer.renderLines(firstLine, lastLine);
            document.readUnlock();
            for (int i = 0; i < fragments.size(); ++i) {
                StyledFragment fragment = fragments.get(i);
                BaseStyle baseStyle = registry.lookupStyle(fragment.styleName);
                if (baseStyle == null) break;
                int style = baseStyle.getFontStyle();
                Color color = baseStyle.getForegroundColor();
                for (int k = fragment.startOffset; k < fragment.endOffset; ++k) {
                    styles[k] = style;
                    colors[k] = color;
                }
            }
        }
        return new Object[]{view.getGUI(), ((CodeEditor)view).getGutter(), text, styles, colors, pane.getSelectionStart(), pane.getSelectionEnd()};
    }

    private char[] getText(TextNode node) {
        TextBuffer text = node.acquireTextBuffer();
        return text.getChars(0, text.getLength());
    }

    private void out() {
        System.out.println();
    }

    private void out(Object object) {
        System.out.println("*** " + object);
    }
}

