/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print.ide;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import oracle.ide.config.Preferences;
import oracle.ide.migration.ExtensionMigrator;
import oracle.javatools.data.HashStructure;

public final class Migrator
extends ExtensionMigrator {
    private static final int DEFAULT_SIZE = 10;

    protected String getExtensionID() {
        return "oracle.ide.print";
    }

    protected List getSettingKeys() {
        return Arrays.asList("PrintingOptions");
    }

    public String[] migrate(File sourceDir, File destDir) {
        HashStructure structure = Preferences.getPreferences().getProperties();
        if (structure.containsKey("PrintingOptions")) {
            int oldValue;
            HashStructure prefs = structure.getHashStructure("PrintingOptions");
            if (prefs.containsKey("printFontStyles")) {
                oldValue = prefs.getBoolean("printFontStyles", true);
                prefs.putBoolean("print.text.font.style", oldValue != 0);
                prefs.remove("printFontStyles");
            }
            if (prefs.containsKey("wrapBehavior")) {
                oldValue = prefs.getInt("wrapBehavior", 1);
                prefs.putBoolean("print.text.wrap.long.lines", oldValue == 1);
                prefs.remove("wrapBehavior");
            }
            if (prefs.containsKey("printLineNumbers")) {
                oldValue = prefs.getInt("printLineNumbers", 1);
                prefs.putBoolean("print.text.line.numbers", oldValue == 1);
                prefs.remove("printLineNumbers");
            }
            if (prefs.containsKey("printFileHeader")) {
                oldValue = prefs.getBoolean("printFileHeader", true) ? 1 : 0;
                prefs.putBoolean("print.header", oldValue != 0);
                prefs.remove("printFileHeader");
            }
            if (prefs.containsKey("fontFamily") || prefs.containsKey("fontSize")) {
                String oldFamily = prefs.getString("fontFamily", "Monospaced");
                int oldSize = prefs.getInt("fontSize", 10);
                prefs.remove("fontFamily");
                prefs.remove("fontSize");
                prefs.putString("print.text.font", oldFamily + ",0," + oldSize);
            }
        }
        return null;
    }
}

