/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print.ide;

import java.awt.print.Pageable;
import java.awt.print.Printable;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.SingletonProvider;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintHelperDefinitions;
import oracle.ide.print.api.PrintIde;
import oracle.ide.print.api.PrintManager;
import oracle.ideimpl.print.ide.Ide;
import oracle.ideimpl.print.ide.Manager;
import oracle.ideimpl.print.ide.Provider;

public final class Menu
extends Provider
implements Controller {
    private static final int PRINT_SETUP_CMD_ID = oracle.ide.Ide.findCmdID((String)"Ide.PRINT_SETUP_CMD_ID");
    private static final int PRINT_CMD_ID = oracle.ide.Ide.findCmdID((String)"Ide.PRINT_CMD_ID");
    private static final int PRINT_PREVIEW_CMD_ID = oracle.ide.Ide.findCmdID((String)"Ide.PRINT_PREVIEW_CMD_ID");

    public Menu() {
        this.set(PrintIde.class.getName(), new Ide());
    }

    public boolean update(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == PRINT_CMD_ID || id == PRINT_PREVIEW_CMD_ID) {
            action.setEnabled(context.getView() != null);
            return true;
        }
        if (id == PRINT_SETUP_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == PRINT_CMD_ID || id == PRINT_PREVIEW_CMD_ID) {
            DocumentPrintFactory factory = this.findDocumentPrintFactory(context);
            if (factory != null) {
                Object object = this.createPrintObjectUsingFactory(factory, context);
                if (object != null) {
                    if (object instanceof Printable) {
                        PrintManager.getManager().print(this.createProviders((Printable)object), id == PRINT_PREVIEW_CMD_ID);
                    } else {
                        PrintManager.getManager().print(this.createProviders((Pageable)object), id == PRINT_PREVIEW_CMD_ID);
                    }
                }
            } else {
                PrintManager.getManager().print(this.createProviders(context), id == PRINT_PREVIEW_CMD_ID);
            }
            return true;
        }
        if (id == PRINT_SETUP_CMD_ID) {
            PrintManager.getManager().openPageSetup();
            return true;
        }
        return false;
    }

    private DocumentPrintFactory findDocumentPrintFactory(Context context) {
        return PrintHelperDefinitions.getInstance().getDocumentPrintFactoryForView(context.getView().getClass());
    }

    private Object createPrintObjectUsingFactory(DocumentPrintFactory factory, Context context) {
        factory.create(context);
        Object object = this.getOldPrintManager().getPageable();
        this.getOldPrintManager().setPageable(null);
        if (object == null) {
            object = this.getOldPrintManager().getPrintable();
            this.getOldPrintManager().setPrintable(null, null);
        }
        return object;
    }

    private Manager getOldPrintManager() {
        return (Manager)((Object)SingletonProvider.find(oracle.ide.print.PrintManager.class));
    }

    private void set(String key, Object value) {
        if (System.getProperties().get(key) == null) {
            System.getProperties().put(key, value);
        }
    }
}

