/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard.dWizard;

import java.util.NoSuchElementException;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.dWizard.WizardSequence;

public class ArraySequence
implements WizardSequence {
    int _index;
    WizardPage[] _pages;

    public ArraySequence(WizardPage[] wizardPageArray) {
        if (wizardPageArray == null || wizardPageArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this._pages = new WizardPage[wizardPageArray.length];
        System.arraycopy(wizardPageArray, 0, this._pages, 0, wizardPageArray.length);
        this.goToFirstPage();
    }

    public void goToFirstPage() {
        int n;
        this._index = 0;
        if (this.getCurrentPage() == null && (n = this._getNextIndex(this._index)) >= 0) {
            this._index = n;
        }
    }

    public void goToLastPage() {
        int n;
        this._index = this._pages.length - 1;
        if (this.getCurrentPage() == null && (n = this._getPreviousIndex(this._index)) >= 0) {
            this._index = n;
        }
    }

    public void goForward() {
        int n = this._getNextIndex(this._index);
        if (n < 0) {
            throw new NoSuchElementException();
        }
        this._index = n;
    }

    public void goBackwards() {
        int n = this._getPreviousIndex(this._index);
        if (n < 0) {
            throw new NoSuchElementException();
        }
        this._index = n;
    }

    public WizardPage getNextPage() {
        int n = this._getNextIndex(this._index);
        if (n < 0) {
            return null;
        }
        return this._pages[n];
    }

    public WizardPage getPreviousPage() {
        int n = this._getPreviousIndex(this._index);
        if (n < 0) {
            return null;
        }
        return this._pages[n];
    }

    public WizardPage getCurrentPage() {
        WizardPage wizardPage = this._pages[this._index];
        if (wizardPage.isEnabled() && wizardPage.isVisible()) {
            return wizardPage;
        }
        return null;
    }

    public int getPageCount() {
        int n = 0;
        for (int i = 0; i < this._pages.length; ++i) {
            WizardPage wizardPage = this._pages[i];
            if (!wizardPage.isEnabled() || !wizardPage.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private int _getNextIndex(int n) {
        while (n < this._pages.length - 1) {
            WizardPage wizardPage;
            if (!(wizardPage = this._pages[++n]).isEnabled() || !wizardPage.isVisible()) continue;
            return n;
        }
        return -1;
    }

    private int _getPreviousIndex(int n) {
        while (n > 0) {
            WizardPage wizardPage;
            if (!(wizardPage = this._pages[--n]).isEnabled() || !wizardPage.isVisible()) continue;
            return n;
        }
        return -1;
    }
}

