/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.statusBar;

import java.awt.Image;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.statusBar.StatusBarItem;

public class StatusBarImageItem
extends StatusBarItem {
    private ImageSet _imageSet;

    public StatusBarImageItem(Image image) {
        this(new SynthesizingImageSet(image), -1, false);
    }

    public StatusBarImageItem(ImageSet imageSet) {
        this(imageSet, -1, false);
    }

    public StatusBarImageItem(Image image, int n, boolean bl) {
        this(new SynthesizingImageSet(image), n, bl);
    }

    public StatusBarImageItem(ImageSet imageSet, int n, boolean bl) {
        super(n, bl);
        this._imageSet = imageSet;
    }

    public ImageSet getImageSet() {
        return this._imageSet;
    }

    public final void setImage(Image image) {
        this.setImageSet(new SynthesizingImageSet(image));
    }

    public void setImageSet(ImageSet imageSet) {
        if (this._imageSet != imageSet) {
            this._imageSet = imageSet;
            this.invalidate();
            this.repaint();
        }
    }

    protected Painter getPainter() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null) {
            return statusBar.getStatusBarUI().getImageSetPainter(statusBar);
        }
        return null;
    }

    public Object getPaintData(Object object) {
        if (object == PaintContext.IMAGESET_KEY) {
            return this.getImageSet();
        }
        return super.getPaintData(object);
    }
}

