/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.pivot;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.bigCell.AbstractBigCell;
import oracle.ewt.header.Header;
import oracle.ewt.pivot.PivotGrid;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.pivot.PivotTable;
import oracle.ewt.pivot.PivotValidateEvent;
import oracle.ewt.table.TableEvent;
import oracle.ewt.util.InputEventUtils;

class GridResizer
extends MouseAdapter
implements MouseMotionListener {
    private static final int _TARGET = 5;
    private static final int _MIN_SIZE = 2;
    private int _resizeItem = -1;
    private int _column;
    private int _row;
    private PivotHeader _header;

    public GridResizer(PivotHeader pivotHeader) {
        this._header = pivotHeader;
        this._header.getGrid().addMouseListener(this);
        this._header.getGrid().addMouseMotionListener(this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point point = grid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n2 = grid.getColumnAt(point.x);
        int n3 = grid.getRowAt(point.y);
        if (n2 < 0 || n3 < 0) {
            return;
        }
        Point point2 = grid.getCanvasOrigin();
        int n4 = mouseEvent.getX() + -point2.x - grid.getColumnPosition(n2);
        if (this._isResizing(grid, n2, n3, n4, n = mouseEvent.getY() + -point2.y - grid.getRowPosition(n3)) != -1) {
            this._header.getGrid().setCursor(this._getResizeCursor());
            mouseEvent.consume();
        } else {
            this._header.getGrid().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this._header.isEnabled()) {
            return;
        }
        if (!InputEventUtils.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Grid grid = this._header.getGrid();
        Point point = grid.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = grid.getColumnAt(point.x);
        int n2 = grid.getRowAt(point.y);
        if (n < 0 || n2 < 0) {
            return;
        }
        Point point2 = grid.getCanvasOrigin();
        int n3 = mouseEvent.getX() + -point2.x - grid.getColumnPosition(n);
        int n4 = mouseEvent.getY() + -point2.y - grid.getRowPosition(n2);
        this._resizeItem = this._isResizing(grid, n, n2, n3, n4);
        if (this._resizeItem != -1) {
            int n5;
            int n6;
            int n7;
            if (this._header.isHorizontal()) {
                n7 = 2013;
                n6 = this._resizeItem;
                n5 = -1;
            } else {
                n7 = 2015;
                n6 = -1;
                n5 = this._resizeItem;
            }
            if (this._fireCancelableTableEvent(n7, n6, n5)) {
                this._header.getGrid().setCursor(this._getResizeCursor());
                this._header.setResizeItem(this._resizeItem);
                this._column = n;
                this._row = n2;
                PivotTable pivotTable = this._header.getPivotTable();
                if (pivotTable != null) {
                    pivotTable.getPivotGrid().setCurrentlyResizing(true);
                }
                mouseEvent.consume();
            } else {
                this._header.getGrid().setCursor(Cursor.getDefaultCursor());
                this._resizeItem = -1;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            this._setSize(mouseEvent, false);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            int n;
            int n2;
            int n3;
            PivotTable pivotTable = this._header.getPivotTable();
            if (pivotTable != null) {
                pivotTable.getPivotGrid().setCurrentlyResizing(false);
            }
            this._setSize(mouseEvent, true);
            if (this._header.isHorizontal()) {
                n3 = 2014;
                n2 = this._resizeItem;
                n = -1;
            } else {
                n3 = 2016;
                n2 = -1;
                n = this._resizeItem;
            }
            this._fireTableEvent(n3, n2, n);
            this._header.getGrid().setCursor(Cursor.getDefaultCursor());
            mouseEvent.consume();
        }
        this._resizeItem = -1;
    }

    private int _isResizing(Grid grid, int n, int n2, int n3, int n4) {
        Header header;
        PivotGrid pivotGrid = this._header.getPivotTable().getPivotGrid();
        Header header2 = header = this._header.isHorizontal() ? pivotGrid.getColumnHeader() : pivotGrid.getRowHeader();
        if (!header.getCanResizeItems()) {
            return -1;
        }
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, n, n2);
        if (abstractBigCell != null) {
            return this._isResizing(grid, n, n2, abstractBigCell, n3, n4);
        }
        return -1;
    }

    private int _isResizing(Grid grid, int n, int n2, AbstractBigCell abstractBigCell, int n3, int n4) {
        int n5;
        boolean bl;
        boolean bl2;
        int n6;
        int n7;
        int n8;
        Point point = this._convertPoint(grid, abstractBigCell, n, n2, n3, n4);
        boolean bl3 = this._header.isHorizontal();
        if (bl3) {
            n8 = point.x;
            n7 = abstractBigCell.getColumn();
            n6 = n7 + abstractBigCell.getColumnCount() - 1;
        } else {
            n8 = point.y;
            n7 = abstractBigCell.getRow();
            n6 = n7 + abstractBigCell.getRowCount() - 1;
        }
        int n9 = bl3 ? this._getWidth(grid, abstractBigCell) : this._getHeight(grid, abstractBigCell);
        boolean bl4 = n8 >= n9 - 5;
        boolean bl5 = bl2 = n8 >= 0 && n8 <= 5;
        if (!bl4 && !bl2) {
            return -1;
        }
        boolean bl6 = bl = !bl3 || this._header.getActualReadingDirection() == 1;
        if (bl4) {
            if (bl) {
                return n6;
            }
            int n10 = n5 = bl3 ? grid.getColumnCount() : grid.getRowCount();
            if (n6 < n5) {
                return n6;
            }
        }
        if (bl2 && (n5 = n7 - 1) >= 0) {
            return n5;
        }
        return -1;
    }

    private void _setSize(MouseEvent mouseEvent, boolean bl) {
        Grid grid = this._header.getGrid();
        Point point = grid.getCanvasOrigin();
        int n = mouseEvent.getX() + -point.x - grid.getColumnPosition(this._column);
        int n2 = mouseEvent.getY() + -point.y - grid.getRowPosition(this._row);
        AbstractBigCell abstractBigCell = AbstractBigCell.getBigCell(grid, this._column, this._row);
        if (abstractBigCell == null) {
            this._setSize(grid, this._column, this._row, n, n2, bl);
        } else {
            this._setSize(grid, this._column, this._row, abstractBigCell, n, n2, bl);
        }
    }

    private void _setSize(Grid grid, int n, int n2, int n3, int n4, boolean bl) {
    }

    private void _setSize(Grid grid, int n, int n2, AbstractBigCell abstractBigCell, int n3, int n4, boolean bl) {
        PivotTable pivotTable = this._header.getPivotTable();
        int n5 = 0;
        if (this._header.isHorizontal()) {
            if (n != this._resizeItem) {
                abstractBigCell = AbstractBigCell.getBigCell(grid, this._resizeItem, n2);
            }
            boolean bl2 = grid.getActualReadingDirection() == 1;
            int n6 = abstractBigCell.getColumn() + abstractBigCell.getColumnCount() - 1;
            if (bl2) {
                n5 = n6 == n ? n3 : this._header.getColumnWidth(n6) + n3;
            } else {
                int n7 = n5 = n6 == n ? this._header.getColumnWidth(n6) - n3 : this._header.getColumnWidth(n6) + (this._header.getColumnWidth(this._resizeItem) - n3);
            }
            if (n5 < 2) {
                n5 = 2;
            }
            if (!bl) {
                this.trySetColumnWidth(n6, n5, true);
            } else if (pivotTable.getEqualSizedColumns()) {
                pivotTable.tryDefaultColumns();
                this._header.setColumnWidth(n6, -1);
                this.trySetColumnWidth(n6, -1, false);
                pivotTable.setDefaultColumnWidth(n5);
            } else {
                pivotTable.setColumnWidth(n6, n5);
            }
        } else {
            int n8;
            if (n2 != this._resizeItem) {
                abstractBigCell = AbstractBigCell.getBigCell(grid, n, this._resizeItem);
            }
            int n9 = n5 = (n8 = abstractBigCell.getRow() + abstractBigCell.getRowCount() - 1) == n2 ? n4 : this._header.getRowHeight(n8) + n4;
            if (n5 < 2) {
                n5 = 2;
            }
            if (!bl) {
                this.trySetRowHeight(n8, n5);
            } else if (pivotTable.getEqualSizedRows()) {
                pivotTable.tryDefaultRows();
                this._header.setRowHeight(n8, -1);
                this.trySetRowHeight(n8, -1);
                pivotTable.setDefaultRowHeight(n5);
                pivotTable.getPivotGrid().invalidateCanvas();
            } else {
                pivotTable.setRowHeight(n8, n5);
            }
        }
        if (bl) {
            this._header.setResizeItem(-1);
        } else {
            this._header.updateResizeFeedback(n5);
        }
    }

    private int _getWidth(Grid grid, AbstractBigCell abstractBigCell) {
        int n = 0;
        int n2 = abstractBigCell.getColumn();
        int n3 = abstractBigCell.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            n += grid.getColumnWidth(i + n2);
        }
        return n;
    }

    private int _getHeight(Grid grid, AbstractBigCell abstractBigCell) {
        int n = 0;
        int n2 = abstractBigCell.getRow();
        int n3 = abstractBigCell.getRowCount();
        for (int i = 0; i < n3; ++i) {
            n += grid.getRowHeight(i + n2);
        }
        return n;
    }

    private Cursor _getResizeCursor() {
        if (this._header.isHorizontal()) {
            return Cursor.getPredefinedCursor(10);
        }
        return Cursor.getPredefinedCursor(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetColumnWidth(int n, int n2, boolean bl) {
        PivotGrid pivotGrid = this._header.getPivotTable().getPivotGrid();
        boolean bl2 = this._header.getActualReadingDirection() == 1;
        boolean bl3 = bl ? bl2 : true;
        int n3 = pivotGrid.getGrid().getColumnCount();
        if (n < n3 && bl3) {
            pivotGrid.freezeRepaints();
            try {
                pivotGrid.setColumnWidth(n, n2);
            }
            finally {
                pivotGrid.unfreezeRepaints();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetRowHeight(int n, int n2) {
        PivotGrid pivotGrid = this._header.getPivotTable().getPivotGrid();
        int n3 = pivotGrid.getGrid().getRowCount();
        if (n < n3) {
            pivotGrid.freezeRepaints();
            try {
                pivotGrid.setRowHeight(n, n2);
            }
            finally {
                pivotGrid.unfreezeRepaints();
            }
        }
    }

    private boolean _fireCancelableTableEvent(int n, int n2, int n3) {
        PivotTable pivotTable = this._header.getPivotTable();
        PivotValidateEvent pivotValidateEvent = new PivotValidateEvent(pivotTable, n, n2, n3);
        pivotTable.postEvent(pivotValidateEvent);
        return !pivotValidateEvent.isCancelled();
    }

    private void _fireTableEvent(int n, int n2, int n3) {
        PivotTable pivotTable = this._header.getPivotTable();
        TableEvent tableEvent = new TableEvent(pivotTable, n, n2, n3);
        pivotTable.postEvent(tableEvent);
    }

    private Point _convertPoint(Grid grid, AbstractBigCell abstractBigCell, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = grid.getActualReadingDirection() == 1;
        if (!bl) {
            n3 = grid.getColumnWidth(abstractBigCell.getColumn()) - n3;
        }
        for (int i = abstractBigCell.getColumn(); i < n; ++i) {
            n3 += grid.getColumnWidth(i);
        }
        for (int i = abstractBigCell.getRow(); i < n2; ++i) {
            n4 += grid.getRowHeight(i);
        }
        return new Point(n3, n4);
    }
}

