/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText.im;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.im.InputMethodUtil;

class InputMethodRequestsHandler
implements InputMethodRequests {
    private InputMethodUtil _imeUtil;

    public InputMethodRequestsHandler(InputMethodUtil inputMethodUtil) {
        this._imeUtil = inputMethodUtil;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getCommittedText(n, n2);
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2) {
        return new AttributedString("").getIterator();
    }

    public int getCommittedTextLength() {
        return 0;
    }

    public int getComposedStart() {
        return this._imeUtil.getComposedStart();
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return new AttributedString("").getIterator();
    }

    public int getInsertPositionOffset() {
        return this.getComposedStart();
    }

    public Rectangle getCaretRectangle(TextHitInfo textHitInfo) {
        Rectangle rectangle = null;
        LWCommonText lWCommonText = this._imeUtil.getTextComponent();
        FontMetrics fontMetrics = lWCommonText.getGraphics().getFontMetrics();
        if (lWCommonText instanceof LWTextField) {
            int n;
            TextLayout textLayout = this._imeUtil.getDisplayTextLayout();
            if (textLayout != null && textHitInfo != null) {
                int n2 = textHitInfo.getInsertionIndex();
                if (n2 < 0) {
                    n = 0;
                } else {
                    int n3 = textLayout.getCharacterCount();
                    if (n2 > n3) {
                        textHitInfo = TextHitInfo.leading(n3);
                    }
                    n = Math.round(textLayout.getCaretInfo(textHitInfo)[0]);
                }
            } else {
                n = 0;
            }
            rectangle = new Rectangle(this.getTextOrigin().x + n, this.getTextOrigin().y + fontMetrics.getDescent(), 0, fontMetrics.getAscent() + fontMetrics.getDescent());
        } else if (lWCommonText instanceof LWTextArea) {
            TextPosition textPosition = ((LWTextArea)lWCommonText).getPosition(this._imeUtil.getComposedStart());
            rectangle = ((LWTextArea)lWCommonText).getSelectionBounds(textPosition, textPosition);
            rectangle.y += fontMetrics.getDescent();
        }
        return rectangle;
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        LWCommonText lWCommonText = this._imeUtil.getTextComponent();
        Rectangle rectangle = this.getCaretRectangle(TextHitInfo.leading(lWCommonText.getCaretPosition()));
        if (rectangle != null) {
            Point point = lWCommonText.getLocationOnScreen();
            rectangle.translate(point.x, point.y);
        } else {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public Point getTextOrigin() {
        LWCommonText lWCommonText = this._imeUtil.getTextComponent();
        Point point = lWCommonText.getCanvasOrigin();
        FontMetrics fontMetrics = lWCommonText.getFontMetrics(lWCommonText.getFont());
        if (lWCommonText instanceof LWTextField) {
            point.y += (lWCommonText.getInnerHeight() - fontMetrics.getHeight()) / 2;
        }
        return point;
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        Point point = this._imeUtil.getTextComponent().getLocationOnScreen();
        Point point2 = this.getTextOrigin();
        TextLayout textLayout = this._imeUtil.getDisplayTextLayout();
        if (textLayout != null && textLayout.getBounds().contains(n -= point.x + point2.x, n2 -= point.y + point2.y)) {
            return textLayout.hitTestChar(n, n2).getOffsetHit(-this.getComposedStart());
        }
        return null;
    }
}

