/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.ewt.layout.PreferredSizeLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.Scrollable;
import oracle.ewt.scrolling.ScrollableException;

final class ScrollableAdapter
extends LWComponent
implements Scrollable {
    private Component _content;
    private LWComponent _clip;
    private boolean _hScrollable;
    private boolean _vScrollable;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;

    public ScrollableAdapter(Component component, boolean bl, boolean bl2) {
        this._content = component;
        this._hScrollable = bl;
        this._vScrollable = bl2;
        this._clip = new LWComponent();
        this._clip.setLayout(PreferredSizeLayout.getInstance());
        this._clip.add("Content", this._content);
        this.setLayout(new BorderLayout());
        this.add("Center", this._clip);
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
        } else if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
        }
    }

    public void handleHScroll(int n, int n2) throws ScrollableException {
        if (!this.isHScrollable()) {
            throw new ScrollableException();
        }
        this.setCanvasOrigin(-n, this.getCanvasOrigin().y);
    }

    public void handleVScroll(int n, int n2) throws ScrollableException {
        if (!this.isVScrollable()) {
            throw new ScrollableException();
        }
        this.setCanvasOrigin(this.getCanvasOrigin().x, -n);
    }

    public Point getCanvasOrigin() {
        Point point = this._content.getLocation();
        if (this.isHScrollable() && this.getActualReadingDirection() == 2) {
            point.x = this.getSize().width - (point.x + this._content.getSize().width);
        }
        return point;
    }

    public Dimension getCanvasSize() {
        return this._content.getSize();
    }

    public Rectangle getCanvasBounds() {
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getCanvasSize();
        return new Rectangle(point.x, point.y, dimension.width, dimension.height);
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public Dimension getViewPortSize() {
        return this._clip.getSize();
    }

    public boolean isHScrollable() {
        return this._hScrollable;
    }

    public boolean isVScrollable() {
        return this._vScrollable;
    }

    public final synchronized void layout() {
        super.layout();
        if (!this._clip.isValid()) {
            this._clip.setSize(this.getSize());
            this._clip.doLayout();
        }
        this.setCanvasOrigin(0, 0);
        this._configureAdjustables();
    }

    public void setCanvasOrigin(int n, int n2) throws ScrollableException {
        if (this.isHScrollable() && this.getActualReadingDirection() == 2) {
            this._content.setLocation(this.getSize().width - (this._content.getSize().width + n), n2);
        } else {
            this._content.setLocation(n, n2);
        }
    }

    private void _configureAdjustables() {
        Dimension dimension = this._content.getSize();
        Dimension dimension2 = this.getSize();
        Adjustable adjustable = this.getHAdjustable();
        if (adjustable != null) {
            adjustable.setMinimum(0);
            adjustable.setMaximum(dimension.width);
            adjustable.setVisibleAmount(dimension2.width);
        }
        if ((adjustable = this.getVAdjustable()) != null) {
            adjustable.setMinimum(0);
            adjustable.setMaximum(dimension.height);
            adjustable.setVisibleAmount(dimension2.height);
        }
    }
}

