/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Component;
import java.awt.Image;
import oracle.ewt.lwAWT.BalkingDoubleBuffer;
import oracle.ewt.lwAWT.DoubleBuffer2;

public class WaitingDoubleBuffer
implements DoubleBuffer2 {
    private BalkingDoubleBuffer _buffer = new BalkingDoubleBuffer();
    private Thread _owningThread;
    private static final long _WAIT_TIME = 5000L;

    public synchronized Image getOffscreenBuffer(Component component) {
        if (this._owningThread == Thread.currentThread()) {
            return null;
        }
        Image image = this._buffer.getOffscreenBuffer(component);
        if (image == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            image = this._buffer.getOffscreenBuffer(component);
        }
        if (image != null) {
            this._owningThread = Thread.currentThread();
        }
        return image;
    }

    public synchronized Image getOffscreenBuffer(Component component, int n, int n2) {
        if (this._owningThread == Thread.currentThread()) {
            return null;
        }
        Image image = this._buffer.getOffscreenBuffer(component, n, n2);
        if (image == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            image = this._buffer.getOffscreenBuffer(component, n, n2);
        }
        if (image != null) {
            this._owningThread = Thread.currentThread();
        }
        return image;
    }

    public synchronized void releaseOffscreenBuffer(Image image) {
        if (image != null) {
            this._buffer.releaseOffscreenBuffer(image);
            this._owningThread = null;
            this.notifyAll();
        }
    }

    public void flush() {
        this._buffer.flush();
    }
}

